+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-10-25T12:37:00-04:00"
lastmod = "2015-04-14T10:15:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1547912330/media/2019/01/OAAlcina.png"
primary_image_credit = "Photo by Bruce Zinger"
publishDate = "2014-10-25T12:37:00-04:00"
related_articles = ["articles/in-review-opera-ateliers-armide.md", "articles/talking-with-singers-meghan-lindsay.md", "articles/boys-who-are-girls-who-love-girls-that-are-boys-or-handels-alcina.md", "articles/all-about-the-tafelmusik-baroque-summer-institute.md", "articles/american-baroque-opera-cos-first-staged-opera-a-winner-in-alcina.md", "articles/a-daring-desirous-doublebill-at-opera-atelier.md"]
related_companies = ["scene/companies/opera-atelier.md"]
related_people = ["scene/people/wallis-giunta.md", "scene/people/mireille-lebel.md", "scene/people/meghan-lindsay.md", "scene/people/mireille-asselin.md"]
short_description = "Greg and I headed to the Elgin Theatre to see opening night of Opera Atelier&#039;s Alcina, and we teamed up on another joint review. Bonus: Greg can speak intelligently about Atelier Ballet, something I won&#039;t pretend to know well."
slug = "he-saidshe-said-alcina-at-opera-atelier"
title = "He Said/She Said: Alcina at Opera Atelier"

+++
### On the singing

**Jenna**: I thought the singing was fantastic from the four leading ladies (lady singers, with variable genders). In the title role, soprano [Meghan Lindsay](http://www.meghanlindsay.com/) was fierce and manipulative; she made use of her warm, velvety middle range, and let her high notes rip with metallic ring. Alcina is a role that features lots of disingenuousness, and I thought Meghan made a clear distinction between Alcina's moments of honesty and her moments of lies. Very Queen-like. As Ruggiero, Alcina's lover-du-jour, mezzo-soprano [Allyson McHardy](http://www.allysonmchardy.com/) was spectacular. I've gotten to know Allyson's singing a bit over the years, and it's always a treat to hear her in Handel; it's really her thing. Allyson is a pro when it comes to pants roles, and Ruggiero was no exception. She had fantastic coloratura and stunning, still rendition of "Verdi prati". She sang with an honest, manly sound, and she paced her vocal colour palate wisely; she created a Ruggiero who really "spoke" differently to Alcina than to his lost-now-found fiancée, Bradamante. Speaking of whom, mezzo-soprano [Wallis Giunta](http://wallisgiunta.com/site/) showed off some seriously polished singing as Ruggiero's fiancée (who is at times dressed as a man, to give the pants role confusion another layer). She had incredible coloratura in a few damn-difficult arias, and I loved how she smartly used her chest voice to deal with the role's low writing. I liked that she ornamented her _da capos_ to show off her higher range, keeping Bradamante a lighter "male" foil to Ruggiero.
But as Morgana, the girl with the shortest attention-span ever, soprano [Mireille Asselin](http://www.mireilleasselin.com/) stole the show. She sounded flawless, with seemingly endless creative possibilities in her voice. Mireille is an Early Music pro as well, and she gave a lesson in how to ornament an aria; starting purely from her voice, she didn't let a word go by without a specific interpretation. Morgana had the precious few moments of comedic relief during the show, and her hilarious staging of "Tornami a vagheggiar" is now officially the New and Improved Coat Aria (go see it, you'll agree). Also, she plays a mean air-harpsichord.

In the two supporting roles were [Krešimir Špicer](http://operabase.com/a/Kresimir_Spicer/9872) (Oronte) and [Olivier Laquerre](http://www.olivierlaquerre.com/mb/index.php) (Melisso). Melisso doesn't really show off a singer's voice (it's mostly recit); I'd have liked a bit more voice in the recits, rather than a _parlando_ effect most of the time, but I don't know the role well enough to preach. Krešimir had a beautiful tenor sound with lots of sensitivity; much of the time, however, I didn't get the chance to really hear his voice. He was almost too affective with his sound, getting into off-the-voice or shouting territory. When he showed a beautiful legato in his last aria, I was left wondering why I didn't get to hear it more.

**Greg**: This is the good stuff. Come see this show for the singing and the rest is delicious, delicious gravy - it can even be a miso gravy for the veggie-types.

To say the growth I've heard in Megan Lindsay's voice over the last four years is exciting would be an understatement. Alcina is her role through and through. The comfort in her middle range coupled with crystal-clear diction added an incredible depth of colour when she went into the top end of her vocal line. Her aria at the top of Act II was breathtaking. It was probably the most quiet that the excited opening-night crowd had been the whole evening. Her cadenzas were lovely and she commanded quite a dramatic range in the versatility of her vocal colour. I hope she's as excited about this as I am. Mezzo Allyson McHardy was on fire. This Handel stuff was made for her. She had some incredibly tricky music and it was all delivered with skill, grace, and a genteel masculinity that proves the mettle of a true pants-role singer. Her dark tone and quick vocal action glid through the melismas effortlessly - I swear, girl didn't even break a sweat. Speaking of pants roles, Mezzo Wallis Giunta reminded us why we love her so much. Her deft navigation between head voice and chest, vocal lines that seemed to last forever, and delicate switches between the male Ricciardo and the female Bradamante. Giunta and McHardy together? I died. I'm dead now. To round out the quartet of astounding female singers we were privileged to hear Mireille Asselin's Morgana. You should be too. Seriously, get a ticket. She opens the show and from that point, any moment she steps on stage you're glued to her. In the dark at one point, I literally just wrote "Tornar!!!!" Yes, four exclamation points. Her ornaments, her cadenzas, her vocal line, her dramatic drive behind the text informing her voice, it was all just brilliant. Granted, her character is probably the most fun to play, but the music is incredibly difficult and it is no match for Asselin. Krešimir Špicer sang Oronte with a masculine line and an easy tone. I felt his upper range got spread and bordered on "yell-y" which can be a byproduct of the frenzied nature of the staging. Later in the show he delivered a lovely aria with a clean legato that made me with I'd heard more of it throughout the show. Similarly with Olivier Laquerre's Melisso, who unfortunately (I'm pretty sure) only sings recits during scenes with fairly high emotional stakes. I think the drama of the scene didn't afford Laquerre the chance to sing the lovely lines we're used to. That being said, Laquerre seemed the most at ease with the quick pace of the staging.

### On the production

**Jenna**: Alright, a disclaimer: the notable Opera Atelier aesthetic isn't my cup of tea. But I'll say that [Artistic Directors](http://www.operaatelier.com/about/creative-team/) Marshall Pynkoski (director) and Jeannette Lajeunesse-Zingg (choreographer) succeeded in creating an _Alcina_ full of stunning tableaus. There were beautiful and varied sets by [Gerard Gauci](http://debellefeuille.com/gauci-gerard-2/) and gorgeous costumes by [Michael Gianfrancesco](http://www.catalysttcm.com/michaelgianfrancesco.html), complemented by film projections by [Ben Shirinian](http://benshirinian.com/). There were floating harpsichords and gorgeous sky-blue fabric panels and dizzying stars. My issues come from the sense that, similarly to the music itself, this _Alcina_ was not directed using the text as a primary source. During the first act alone there were at least four _da capo_ arias where the return of the A section was delivered directly to the audience. This breaking of the fourth wall is really effective when it works with the text of the aria. But four wall-breaking _da capos_ in a row are a good way to show that not every aria is equal in affect. I'm a big believer in subtext as motivation for repeated text, especially in Handel arias. But there's something to be said for taking a score literally, at least as a starting point.
I had a feeling that Pynkoski prioritized the use of these dramatic tools over whether or not they were actually applicable to the scene. You could argue that there was indeed one visual theme throughout the show: naked guys. So many naked guys. I get it: Alcina is a nymphomaniacal queen who enslaves her lovers for her own private use. So I get the scattering of nude male bodies around the stage, or projected across a screen, or acting as Alcina's coffee table. But as the images of male nudes was used again and again, I couldn't shake my initial feeling of gratuitousness. Granted, Pynkoski cracked a joke about gratuitous nudity before the show began, but subtlety can go a long way. I mean, at one point in the third act, when Alcina's enslaved men are freed, the film projection shows a _deluge_ of naked men and their great butts flying past in resurrected ecstasy. I'm not saying it was the ugliest thing I ever saw (quite the opposite), but again, this _Alcina_ pushed its dramaturgical tool almost to a laughable point.

**Greg**: The staging is something new for Atelier. Unlike Jenna, I really enjoy the Pynkoski/Lajeunesse-Zingg aesthetic. It's a niche that Toronto deserves to have filled, and they fill it incomparably. I've noticed a depature from tradition with Atelier recently (bringing in later rep like _Der Freischutz_ and this year they're doing Berlioz) and I felt this lovely production was the first in a foray in exploring new modern techniques for the theatre to reinvigorate a several hundred year old score. It's a great idea and most of it ran successfully, however I felt a few glitches. The show starts as a meta play with dancers warming up and a cameo by the two Assistant Stage Managers. A great use of Handel's overture and a great way to get the ball rolling, however, they don't ever close the envelope of metatheatricality. We never see "the players" again as players and I think that's important for metatheatre to be successful. I'm always a little disconcerted when a director gets up and apologizes to the audience during the pre-amble, but it was a funny pre-amble so I gave Marshall the benefit of the doubt - and maybe I'm a total libertine, but I really don't think you need to warn an audience for nudity, if you see neither breasts nor genitalia. But it is nice to see men being objectified for a change. The design was striking. In looking at it, I felt like Dali was paying his respects to Bosch. The incorporation of Shirinian's projections worked great in assisting the audience in seeing how the whole island is cursed and transmutated former lovers. The costumes were lovely period numbers, with soft sparkly silks and crinolines for the ladies and burnished coppers and green-browns for the men. Here's where I felt the disconnect. I felt the traditional costumes were a little TOO traditional to jive with a much more modernized set and technical design. It could be argued that the disjunct effect lends to the "weirdness" of Alcina's enchanted isle, but it just caused me to only look at one or the other and rarely the whole picture. We get members of the Tafelmusik orchestra flown in from the ceiling, and playing from the boxes (in short, out of the pit) and I LOVED IT. It added a depth of colour to Handel's score that you really only get to hear when it's done on period instruments by players of the calibre of Tafelmusik. The characters fly around the stage quite quickly and while singing some darn difficult music. They were graceful, I can't deny them that, but I felt it robbed the show of just a touch of its elegance. I'm not entirely sure why the majority of the _da capo_ sections were done breaking the fourth wall and singing directly to us in the audience. While I thank Marshall for giving us the opportunity to hear some unencumbered beautiful singing, but it didn't seem like they were dramatically motivated. As a gay man, I was in no way put off by the barrage of naked men.

### On the acting

**Jenna**: I thought Mireille shone as an actor in this _Alcina_; she found the most organic way to transition between dramatic beats or to use sections of instrumental music to her advantage. Allyson and Wallis were great in their pants (and sometimes skirt) roles; Allyson came across very stoic and convincing in her male postures, and Wallis tackled the tricky character of Bradamante in and out of both genders. I sort of wanted more of a noticeable change when Bradamante reveals herself to be Ruggiero's lost (female) fiancée; but it struck me that her music remains masculine, suggesting a tomboyish character, so I'll hand it to Wallis for using Handel's score for character motivation. For the most part, much of the acting was seen from within the parameters of the particular aesthetic of Opera Atelier productions. Many of the dramatic decisions weren't coming from the text itself, and it made me wonder about the singers' own ideas about their characters' journeys throughout _Alcina_.

**Greg**: Remember when I said there was a time and a place for presentational theatre? This is that time and place. Staying true to the era, the physicalization of the characters is done in a demonstrative manner leaving the voice to be the part of the actor's instrument (body) to provide the emotional colour palette. When it's done well, it's remarkable - and this was remarkable. Lindsay's Alcina easily swung between dangerous viper and sweet fluffy-bunnykins. What was really engaging was when her heart breaks. Lindsay's vocal colours changed ever so slightly and as Alcina spirals out of control, you hear more desperation and loss. It was an astounding journey to watch someone take. Asselin's Morgana had the desperately needed comic relief duty in the show. Her fickleness and flightiness yet sincere, intense feelings remind me of a young, magical, female, Don Giovanni. She genuinely loves almost any man she meets. She was lithe and agile and spritely and never once at the cost of her incredibly beautiful singing. As Ruggiero, McHardy was at ease in a soldier's boots. She commanded the role and not once did it feel like an affectation. The moment of reunion with Bradamante made me a little misty, I'm not going to lie. Giunta, known well for her work in pants roles, takes it one step further actually playing a woman pretending to be her brother. There were moments when Lindsay and McHardy were doing some fabulous singing stage right and I was hopelessy glued to Giunta on stage left as she struggled to hide Bradamante's emotions behind the veil of Ricciardo. It was great stuff. I actually quite enjoyed Spicer's characterization of Oronte. He played the part of a man with a wounded ego but wouldn't let the spark die from his eye. He was quite charming.

### On the music

**Jenna**: Under the baton of [David Fallis](http://www.music.utoronto.ca/Page2353.aspx), the [Tafelmusik Baroque Orchestra](http://www.tafelmusik.org/) sounded fantastic, as I expected them to be. I always love hearing the difference between period and modern instruments, and there's always a moment of musical novelty that hits me when Tafelmusik begins to play. I thought there were some musical moments that could have had more spice; I wasn't always convinced that Maestro Fallis was conducting with the text in mind.

**Greg**: The orchestra for the run is the inestimable Tafelmusik under the baton of Maestro David Fallis. The tempi were spot-on and he kept a melodic line and pace that allowed the singers to have comfort with the devilish coloratura. I noticed no balance issues whatsoever. One of my favourite things about this era in music, is the composers' use of silence between notes, and Tafelmusik understands better than anyone, coupled with period instruments, that's what gives this entire piece its Baroqueness - when they let the silence sing too. In this piece the orchestra and ballet actually spend quite a bit of time at the forefront so we're treated to some extended instrumental interludes and dances. The minuets were graceful and smooth and the final Tamburino was thrilling. The offstage chorus, what little they were used, sang well. They handled the chorales extremely well. I found their counterpoint got a little muddled in the one fugal section, but diction was clear and precise and they had a strong inner-voice section.

### On the dancing

**Jenna**: I'll say the Atelier Ballet looked beautiful, and now I hereby cede all dance comments to Greg, who actually knows what he's talking about.

**Greg**: OOOOOoooooo!!!! I get to talk about dance!!! YAY!!! The Ballet of Opera Atelier are wonderful in this show. Handel wrote a lot of instrumental music specifically for a Ballet into the score and Atelier makes full use of that. The women danced with a poise and an elegance that when thrown against some of the more gratuitous content of the show, was what kept the piece from spiralling downward into offensive (to be fair there were only a couple moments where I thought "Okay, that's a little too much even for me." They were few and far between but they could have been dangerous). Supported lines, relaxed arms and backs. They danced lovely canons. Sometimes the spacing may have felt just a tiny, little, itty bitty titch off, but it also could have been the angle of my seat. Unfortunately, Michael Gianfrencesco's beautiful costumes were just a little to long to get a good view of the ladies feet, although they're necessary for the period of the design. You win some, you lose some and speaking of winning some. The men of the ballet (#salutlesboys) are riveting. The partner work was on point (not _en pointe_ - to be clear), beautiful footwork, and masculine graceful lines. It was exciting to see. Again, I mention the final Tamburino because the boys knock it out of the park.

### To see or not to see?

**Jenna**: _Alcina_ features some incredible singing by some of Canada's best, and you'll be treated to eye-candy of all sorts throughout the evening. I'm a Handel fan, and this production is a place to see it full of honed skills and lots of imagination. Would recommend, despite any personal quibbles.

**Greg**: Overall I really enjoyed it. It's Handel, so it takes a bit of a brain adjustment musically and historically, but when you're ready and this show takes off it's wonderful. Opera Atelier is trying new things which is really exciting, whilst not compromising any of the aesthetic and expertise in a niche Toronto desperately deserves. Keep going, OA, you're TOTALLY on the right track and I'm #stokedissimo about it.

<div class="intro">_Alcina_ plays at the Elgin Theatre until November 1st. Fore more info and to purchase tickets, [click right here](http://www.operaatelier.com/season/14-15-season/).</div>