+++
author = ["authors/jenna.md"]
categories = "Interview"
date = 2020-10-26T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Haymarket Opera Company's [10th-anniversary season](http://www.haymarketopera.org/anniversaryseason) starts October 30 with Handel's [_Acis and Galatea_](http://www.haymarketopera.org/acis). Individual tickets are $25, or $40 for all three productions."
preamble = "Old meets new on October 30, when Haymarket Opera Company launches its all-digital [10th Anniversary Season](http://www.haymarketopera.org/anniversaryseason). The Chicago-based producers of baroque and classical opera are replacing their usual mainstage season with cinematic productions of three Handel operas: _Acis and Galatea_, (streaming Oct. 30-Nov. 8), _Apollo e Dafne_ (Mar. 5-14, 2021), and _Orlando_ (Spring 2021, dates TBD).\n\nWe spoke with Haymarket General Director Chase Hopkins, about taking baroque opera out of the proscenium theatre, and streaming it online."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1603646448/media/2020/10/sqHaymarket-AcisRehearsal-AnnaCillan_jt0uos.jpg"
primary_image_credit = "Haymarket Opera Company in rehearsal for its digital 2020-21 season. Photo by Anna Cillan."
related_articles = []
related_companies = ["scene/companies/haymarket-opera-company.md"]
related_people = []
short_description = "\"What does 18th-century opera have to offer us now when we face such existential challenges? Haymarket's tenth season highlights the transformational power of beauty as presented through myth, storytelling, and exquisitely timeless music by one of western music's most empathetic and compassionate composers.\""
slug = "haymarket-opera-companys-10th-anniversary-season-goes-cinematic"
title = "Haymarket Opera Company's 10th Anniversary Season goes cinematic "
youtube_url = ""

+++
## How did you decide on the three operas in Haymarket's 10th anniversary season?

**Chase Hopkins:** The three operas for Haymarket's 10th Anniversary Season were chosen with a dual commitment to the safety of artists and audiences, while also considering how to imagine filming Baroque opera for online performances. Arriving at a milestone such as Haymarket's 10th season requires programming which is appropriately momentous -- but how to work within the parameters of pandemic precautions? We are lucky to be able to draw upon some of the repertoire's great masterpieces which call for relatively small forces.

Today, humanity is mired in the chaos of a global health crisis. What does 18th-century opera have to offer us now when we face such existential challenges? Haymarket's tenth season highlights the transformational power of beauty as presented through myth, storytelling, and exquisitely timeless music by one of western music's most empathetic and compassionate composers. Handel's irresistibly beautiful music offers us inspiration as humankind grapples with reimagining the future.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1603646493/media/2020/10/Haymarket-AcisRehearsal-AnnaCillan_icrlqv.jpg){{% /md %}}

<figcaption>Haymarket Opera Company in rehearsal for Acis and Galatea, part of the 2020-21 season. Photo by Anna Cillan.</figcaption>

</figure>

## What does it take to produce baroque opera as online content? What challenges are unique to this style?

**CH:** To produce baroque opera as online content, we have had to reimagine ourselves outside of the proscenium theater - without the painted perspective panels flanking the performers, and without the lush costumes for which we have gained a reputation. Our first projects are all about the music. It is exciting to imagine our orchestra and singers filling the film studio with their sounds -  a total juxtaposition to the industrial space with our art.  This is my first project with Haymarket Opera Company in my current role. Simultaneously this process has been exciting and difficult. Bringing musicians together to make music was a challenge. Reimagining Haymarket outside of the theater and concert hall was a challenge. Recording this performance to be shared in a way that keeps the audience safe AND entertained has been a challenge. Learning about the world of film has been difficult. Being a general director for the first time has been a challenge. (Very special shout out to our Board president, Jerry Tietz and OPERA America for their guidance.) But I'm grateful to my friend and collaborator, Craig Trompeter, Haymarket's fabulous board of directors, our artists, our sponsors, and our audiences for welcoming, trusting, and joining this endeavor.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1603646507/media/2020/10/Haymarket-AcisFilming-AnnaCillan_otipht.jpg){{% /md %}}

<figcaption>Haymarket Opera Company filming for Acis and Galatea, part of the 2020-21 season. Photo by Anna Cillan.</figcaption>

</figure>

## How will Haymarket Opera Company keep its artists safe during these rehearsals?

**CH:** Early in the process I hired a COVID Compliance Officer, who focuses her attention on safety procedures for our singers, instrumentalists, crew, and creatives. Kait Samuels joins Haymarket for the first time, bringing a background in stage and production management, as well as facilities management at the Ruth Page Center for the Performing Arts in Chicago. Kait has undergone a COVID training for theaters, which has been applied and adapted to Haymarket's own policy and procedure. We have taken the safety of anyone we invite to the space extremely seriously, and are pleased to see those practices be put into practice as we move through our rehearsals.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1603646545/media/2020/10/Haymarket-ChaseHopkins_nna7oi.jpg){{% /md %}}

<figcaption>Chase Hopkins, General Director of Haymarket Opera Company. </figcaption>

</figure>

## What do you hope audiences will take away from the productions in your 10th season?

**CH:** I hope audiences will take away a sense that we are working hard to employ our creativity to navigate unique challenges from the novel coronavirus, and that we are dedicated to producing and serving the community. These plans have not been easy or cheap, but we are so grateful to be performing. I hope that audiences will enjoy the hard work of our entire team, and will anticipate even more creativity from Haymarket's bright future. Joining in for Haymarket's 10th anniversary means I get the joy of imagining the next ten years. We're only just getting started!

<figure data-type="video">{{% md %}}<iframe width="1012" height="569" src="https://www.youtube.com/embed/2UlLdgu1vjo" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>