+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-01-20T19:36:58+00:00"
disclaimer = ""
image_gallery = []
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1548012889/media/2019/01/sqHeatherBuck_1_byCliveGrainger.jpg"
primary_image_credit = "Heather Buck in Haroun and the Sea of Stories, Boston Modern Orchestra Project, 2019. Photo: Clive Grainger."
related_articles = ["articles/distant-emotional-brokeback-mountain-a-paradoxical-success.md"]
related_companies = []
related_people = []
short_description = "It is always tricky to adapt a book about storytelling to any medium outside of the written word, and it is even more difficult when you deal with a work which wears its political overtones like a badge of pride."
slug = "haroun-and-the-sea-of-stories-a-surreal-timely-treat"
title = "Haroun and the Sea of Stories a surreal, timely treat"
youtube_url = ""

+++
Those of you who are faithful Schmopera readers will likely recall that, when I reviewed [Brokeback Mountain](/distant-emotional-brokeback-mountain-a-paradoxical-success/) at the conclusion of last year’s New York City Opera season, I pointed at the paradox of Wuorinen's highly dissonant score used to depict a romance, and the ways that paradox works in that opera's favor. At the time, I figured it was a logical choice, considering how Annie Proulx's prose worked to set up such a paradox. Having seen the Boston Modern Orchestra Project's concertized performance of his earlier opera _Haroun and the Sea of Stories_, however, I think it is rather apparent that Wuorinen has had a good amount of practice dealing in the rather strange paradox of being a serialist opera composer; and honestly, _Haroun_ almost works better just because the nature of the story lends itself better to a serialist opera.

> It was thrilling, it was dramatic, and it did not fail to address the book's political undertones.

_Haroun_, based on the children's book by Salman Rushdie, is a very surreal story: this tale of a boy trying to help his storytelling father Rashid regain the confidence to tell stories after his wife leaves him is essentially what you would get if Lewis Carroll's _Alice in Wonderland_ had been written as a modern-day fairy tale that is aware it's a fairy tale. However, the main thing that perhaps begs an unusual sonic language is that it is a rumination on the power of storytelling, and one that gets rather political owing to the fact that Rushdie wrote it while under the shadow of a _fatwa_ from Ayatollah Khamenei: the main villains Khattam-shud and Snooty Buttoo are motivated by a desire to end all storytelling because they cannot rule over the world of the story, which draws obvious parallels to the fact that the _fatwa_ was a direct consequence of Rushdie's previous work, _The Satanic Verses_.

<figure data-type="image"> {{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548012939/media/2019/01/Ensemble_1_byCliveGrainger.jpg){{% /md %}}

<figcaption>Haroun and the Sea of Stories, Boston Modern Orchestra Project, 2019. Photo: Clive Grainger.</figcaption>

</figure>

It is always tricky to adapt a book about storytelling to any medium outside of the written word, and it is even more difficult when you deal with a work which wears its political overtones like a badge of pride. One always risks losing the meta-narrative quality of the original when you take it out of the written word, after all, and here the adaptation would normally not be helped by the fact that the world of opera has a history of diluting the political overtones of the stories it claims as source material. It is also even harder when the plot operates on a Sheherazade-like nesting of plots, where all of the threads interconnect throughout the denouement in a really intricate way.

Thankfully, James Fenton's libretto manages to hang on to a lot of the surreal qualities of the source: it deftly blends together language that references things old and new, and furthermore it smartly refuses to dilute the political nature of the work. It also had a few excellent choices of arc words on which to anchor the audience while going on this journey, and considering Wuorinen's style this is something that is incredibly helpful. And here, Wuorinen meets Fenton halfway, giving each arching phrase something interesting, whether it be the pointed, jocular rise and fall with which he sets all instances of P2C2E ("Process Too Complicated To Explain"), or the contrasting ways that he manages to set the weighty, existential question of "what use is a story that isn't even true"? Wuorinen even manages to find operatic allusions to sneak into his work to mirror the libretto's allusions, from an indirect parody of _Ride of the Valkyries_ to a hilarious blink-and-you'll-miss-it "_nix_" that is ripped right out of _Wozzeck_.

> The production even smartly commented on today's political times in a way that would no doubt make Mr. Rushdie proud by playing Snooty Buttoo as a pitch-perfect send-up of Donald Trump.

But more than this, _Haroun_ gives Wuorinen room to go all out musically, perhaps owing to the fact that _Haroun_'s plot and setting both operate on an extreme emotional logic that lends itself really well to the opera stage. This emotional logic is a logic that still lends itself to opera even with the serialist language Wuorinen uses, and if anything the serialism emphasizes the surrealistic nature of the plot in a way that no other style could have. The finale of the first act, which sees the people of Gup declare war on the Chups, is nothing short of pulse-pounding. The way the music twists and turns when Haroun and his father Rashid navigate a land where the weather changes depending on the mood of the people is incredibly appropriate. The way Wuorinen colors his orchestral textures when Haroun and his companions Butt the Hoopoe and Iff the Water Genie get close to a ship shrouded in darkness lends itself well to the foreboding nature of the location, and the fact that Khattam-shud awaits within. And of course, Salman Rushdie's acrostic that opens the novel serves as a wonderful book-end to the opera, and Wuorinen finds a great way to get the whole work to book-end on this acrostic.

From there, it then becomes a matter of how to perform such a monumental score, and on this account I cannot find enough ways to praise everybody involved. For one thing, the production did not allow itself excuses despite the fact it is a concert staging. Costume designer Brooke Stanton is perhaps notable here for the production's costumes, which played into the way the libretto plays with old and new storytelling conventions by going with a costume aesthetic that is equal parts fairy-tale India and present-day America. The projections above the whole affair also did a rather excellent job of grounding the action where sets could not, and with how fast the opera is paced I couldn't imagine any other way to convey setting. And, on top of all of that, the production even smartly commented on today's political times in a way that would no doubt make Mr. Rushdie proud by playing Snooty Buttoo as a pitch-perfect send-up of Donald Trump - a creative decision that makes perfect sense considering that Trump's attitude towards news media that doesn't praise him mirrors Snooty Buttoo's attempts to force Rashid to tell stories that paint him in a good light while trying to oppress stories that he cannot control.

> I just wound up staring at Maestro Gil Rose's hands in wonder as he navigated the work's many weird, tricky changes of time signature.

And then, there are the performers. A score such as Wuorinen's is difficult to perform, and the fact that this was a concert version made that all the more apparent just because the audience got to see every single moving part of the action. There were multiple times throughout the running time where I just wound up staring at Maestro Gil Rose's hands in wonder as he navigated the work's many weird, tricky changes of time signature, and several times I found myself questioning how everybody managed to stay on the same page.

First, the entire cast was incredibly outstanding, such that I can't really seem to find a weak spot in the cast. Everyone sang through Wuorinen's score so effortlessly that it was truly a sound to behold, and practically everyone found a way to bring oodles of character to their performances. Prime among these was Heather Buck in the title role: she came in with a sense of childlike wonder and determination that anchored the work's surreal tone, and her voice floated above everything with a crystalline quality that cannot be understated. Other standouts in the cast include Boston opera mainstay Michelle Trainor intentionally singing "badly" as the Princess Batcheat, Stephen Bryant's turn as Haroun's storyteller father, [Neal Ferreira](/scene/people/neal-ferreira/)'s sinister turn as Khattam-shud, and [Matthew DiBattista](/scene/people/matthew-dibattista/) allowing his wild tenor to play into the Donald Trump impersonation that the stage direction went with.

<figure data-type="image"> {{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548013007/media/2019/01/Ensemble_2_CliveGrainger.jpg){{% /md %}}

<figcaption>Haroun and the Sea of Stories, Boston Modern Orchestra Project, 2019. Photo: Clive Grainger.</figcaption>

</figure>

And then, there is the Boston Modern Orchestra Project. BMOP has always been considered one of the preeminent new music groups of the greater Boston area, but opera is something that BMOP rarely delves into. It thus came as a shock just how well they took to opera performance: the orchestral playing was top-notch, in a way that it stayed out of the way of the singers while bringing Wuorinen's vivid, intense orchestrations to life. A score like this is only successful when the players go right in, and Maestro Rose gave a deft hand that acted as a thread for the audience to follow in Wuorinen's incredibly complex score.

There were, of course, two negatives. As with _Brokeback Mountain_, _Haroun_ suffers from an awkward placement of the intermission: it is a work that ends the first act with the same tableau that starts the second act, and I think it would perhaps have been wiser to drop the intermission at least ten, fifteen minutes into what is presently Act II. There is also the issue of the chorus: the sixteen-singer chorus that BMOP hired was generally excellent and hosted some incredible singing, but it is clear that the work was orchestrated with a much larger chorus in mind. Because of this, the poor singers of the chorus frequently got drowned out by the work's loudest moments, and unfortunately I get the sneaking suspicion that BMOP was fighting budgetary restrictions and that there was thus _nothing_ that anybody could do about it.

But even these two issues could not put a damper on the thrill ride that BMOP provided with _Haroun and the Sea of Stories_. It was thrilling, it was dramatic, and it did not fail to address the book's political undertones. Overall, the evening was a delight of surreal storytelling, and if there is any justice in this world _Haroun_ will start to see more performances, particularly in the era of "fake news".