+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-06-01T15:41:00-04:00"
lastmod = "2015-06-02T16:32:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433270355896/TwoBirds.jpg.jpg"
publishDate = "2015-06-02T14:41:00-04:00"
related_articles = ["articles/opera-in-spring.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/krisztina-szab.md","scene/people/stephen-hegedus.md","scene/people/christopher-mokrzewski.md"]
short_description = "It&#039;s not hard to see why Harawi is a good partner to Die Schöne Müllerin. Love, seemingly one-sided. results in the complete spectrum between ecstasy and death. I was curious to know more, so I sat down with pianist, Messaien enthusiast, and Against the Grain Theatre Music Director, Topher Mokrzewski."
slug = "harawi-whats-that"
title = "Harawi? What&#039;s that?"
+++

Olivier Messaien isn't known for his opera (he wrote just one, the 5-hour, heavily Catholic *St. Francois d'Assise*), but he's certainly known for lofty subjects. Against the Grain Theatre opens [*Death & Desire*](http://againstthegraintheatre.com/shows/deathanddesire) tonight, which combines Schubert's *Die schöne Müllerin* with Messaien's *Harawi*, shuffling them together "like a deck of cards," to quote Artistic Director Joel Ivany. Perhaps it's not surprising that, compared to the tomes written about Schubert and his famous song cycle, there is little to say about *Harawi* that can't be deduced from the score. While that didn't stop me from trying to find out more, I concluded early on that the dearth of contextual information about *Harawi* is indicative of how the audiences experiences the piece. 

Here's what we know: 
- Messaien was devoutly Catholic, and was interested in birds and astronomy. His first wife was suffering from mental illness, and she would later be institutionalized.
- *Harawi* is a type of Peruvian love song, where death is a central theme. The 12-song cycle mirrors the legend of Tristan and Isolde.
- The text of *Harawi* is by Messaien himself; it's written primarily in French, but he uses words and phrases in Quechua ([#doundoutchil](https://twitter.com/hashtag/doundoutchil?src=hash), in case you're following Against the Grain Theatre on Twitter).

It's not hard to see why *Harawi* is a good partner to *Die Schöne Müllerin*. Love, seemingly one-sided, results in a complete expressive spectrum between ecstasy and death. I was curious to know more, so I sat down with pianist, Messaien enthusiast, and Against the Grain Theatre Music Director, [Topher Mokrzewski](/scene/people/christopher-mokrzewski/).

Messaien's relationship with his first wife, Claire Delbos, is no small influence in the creation of *Harawi*. He had written pieces for her before, and dedicated to her his *Poèmes pour Mì* (Mì was his nickname for Claire). Mokrzewski describes them as "soul mates," crediting Messaien's deeply held Catholic beliefs for elevating their marriage to something divine. "She was a violinist, he was an organist/pianist; they both composed, and they had a kid together, and they had this *thing*."

*Harawi* was written in 1945, when Claire's mental healthy had begun to deteriorate; she would later be institutionalized until her death in 1959. "*Harawi* is a Peruvian form of song," explains Mokrzewski. "It's a love song that's about death, which ties in with what [Messaien] wanted to be an exploration of the *Tristan* [story], this conflagration of the fullness of love being death." It's interesting to note that Messaien writes *Harawi* strictly from the point of view of Piroutcha, the Isolde character. 

You could argue with some ease that Messaien's use of the *Tristan* story is a beautiful way of immortalizing the love between him and his wife. Realistically, *Harawi* may have less to do with Messaien's personal life than we like to imagine, but it's no doubt a story with which he identified deeply. The way Mokrzewski describes it, *Harawi* seems to serve as Messaien's grieving process over his wife. "The strongest aspect in the song cycle is this sense of sending off. By the middle of the cycle, the song called 'Adieu,' is basically a send-off."

For a devoutly Catholic man, *Harawi* is full of earthy, primal sounds. Messaien's fascination with birds, the cosmos, these things infused the devotional qualities that are conspicuous in his music. "The way that I access it is, when he's doing all that music, it tends to be about the universe, nature, the world," says Mokrzewski. "Even the stuff that's very outrightly religious has a certain cosmic quality to it."

Messaien seemed to experience religion in largely the same way as did Schubert and his contemporaries. "He loved nature, that was how he communed, religiously, in many ways, that's why so many of pieces sound like a celebration of nature."

*Harawi* is a piece that holds my attention in a way other pieces don't. There are all these exciting things about Messaien and his music: there are birdsongs, Quechua syllables that sound like ankle bells, staggering sonic depictions of brilliantly bright divinity and the enormity of the universe. Plus, the singer and pianist have technical challenges that really do rival on the impossible. 

What's driving me crazy about the piece is that I can't make much more sense of it than that. I don't mean to say that *Harawi* is nonsensical, but Mokrzewski can better articulate what I mean. "He's not very understandable. Fundamentally my approach to it, and the reasons that I'm into it or what I respond to, is very intuitive."

As a writer, I feel strangely defeated when I experience a show, or find a piece of music that thrills me, because I can only come up with insufficient *clichés* to describe it. I've had the chance to dip my toe into the pool of Messaien's music, and it makes me wonder at how a composer can get the kinds of sounds he does out of a good old piano and singer. 

"It blends certain things that I value a lot," says Mokrzewski. "There's obviously complexity, structure, organization, form...feeling, expression, and crazy ideas all wrapped into one. It's really multi-faceted music. It's weird-sounding."

If you've not yet, be sure to get your tickets for Against the Grain Theatre's [*Death & Desire*](http://againstthegraintheatre.com/shows/deathanddesire), combining Messaien's *Harawi* with Schubert's *Die schöne Müllerin.* Mokrzewski plays, with singers [Krisztina Szabó](/scene/people/krisztina-szabo/) and [Stephen Hegedus](/scene/people/stephen-hegedus/). Follow the links below for full details. #nottobemissed.
