+++
author = ["authors/greg.md"]
categories = "Review"
date = 2020-02-08T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "The Canadian Opera Company's production of [_Hansel and Gretel_](https://www.coc.ca/productions/18719) runs through February 21."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1581177637/media/2020/02/sqCOC-HG-19-20-04-MC-D-1008_pkloxo.jpg"
primary_image_credit = "Emily Fons as Hansel, Michael Colvin as The Witch and Simone Osborne as Gretel in the Canadian Opera Company's new production of Hansel and Gretel, 2020. Photo: Michael Cooper."
related_articles = ["articles/in-review-bluebeards-castle-erwartung.md", "articles/talking-with-singers-blythe-gaissert.md", "articles/tweaking-the-brothers-grimm-in-oper-frankfurt-s-hänsel-und-gretel.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/joel-ivany.md", "scene/people/annasophie-neher.md", "scene/people/michael-colvin.md", "scene/people/krisztina-szab.md", "scene/people/russell-braun.md", "scene/people/emily-fons-1.md", "scene/people/emily-fons.md", "scene/people/simone-osborne.md"]
short_description = "A wild visual ride from start to finish, it's great lighter fare to warm you up in the winter. I really appreciated the gestures (blunt as they were) to the fact that this started as traditionally holiday fare in Europe, yet didn't feel out of place a month after Twelfth Night. "
slug = "a-feast-for-the-eyes-in-the-cocs-new-hansel-and-gretel"
title = "A feast for the eyes in the COC's new Hansel and Gretel"
youtube_url = ""

+++
You've heard the phrase, "A feast for the eyes," right? That's definitely what happened during opening night of the Canadian Opera Company's new production of Engelbert Humperdinck's classic _Hansel and Gretel_.

The work is inspired by the fairy tale written by The Brothers Grimm, and started out as a series of songs composed, at the request of his sister, to be performed by her children for the holiday season. Humperdinck's sister, Adelheid Wette, came to him with a libretto, albeit with some judicious cuts to the Grimm version, and adding The Sandman and The Dew Fairy to protect the children through their night in the forest, that was markedly lighter than the original tale. The former protégé of Richard Wagner fell so in love with the songs that he fleshed them out into a full-scale operatic work. Wagner himself was noted to be a fan.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581177705/media/2020/02/COC-HG-19-20-04-MC-D-0095_mq3gvk.jpg){{% /md %}}

<figcaption>Emily Fons (Hansel) and Simone Osborne (Gretel) in the Canadian Opera Company's new production of Hansel and Gretel, 2020. Photo: Michael Cooper.</figcaption>

</figure>

Visionary director Joel Ivany re-imagines this piece and sets it in Toronto - as he is wont to do - and the transfer is successful in some parts, less so in others. The design, with costumes by Ming Wong, set and projections by S. Katy Tucker, and lighting by JAX Messenger, was pretty stunning and definitely something new and exciting for the COC. Not that projections and cool lighting palettes and strong expressionistic nods are new by any means, but this application is exciting and relatable as a Torontonian.

The opening projection sequence zooms in from a childlike drawing of Earth from outer space (which is far more adorable than I can successfully describe) all the way down to Toronto and the roof of the Four Seasons Centre itself, only to zoom out again in the direction of... North York? Jane and Finch? In any case, to a single high rise. I won't finish describing it all but it was a fantastic way to let the audience enjoy the overture which is surprisingly long considering the full length of the work itself.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581177728/media/2020/02/COC-HG-19-20-04-MC-D-0499_jvcfae.jpg){{% /md %}}

<figcaption>Russell Braun (Peter), Krisztina Szabó (Gertrude) and Michael Colvin (The Witch) in the Canadian Opera Company's new production of Hansel and Gretel, 2020. Photo: Michael Cooper.</figcaption>

</figure>

The scene opens on a hungry Hansel (mezzo [Emily Fons](/scene/people/emily-fons/)) and Gretel (soprano [Simone Osborne](/scene/people/simone-osborne/)) complaining about having to work and being hungry. Fons and Osborne together are so. much. fun. Fons' Hansel was energetic, animated, and very well-sung. Her voice remained full of line and focus while she was giving some almost hyperactive physicality, and kept Hansel's misbehaviour from coming across as mischief instead of malice. Osborne's Gretel, in an awesome nod to Punky Brewster, went toe to toe. Her little girl portrayal was never belittling, and you stood with her right to the end.

> Michael Colvin's characterization was a heckuva lot of fun to go on a ride with.

Gertrude, their Mother comes home from a hard day at work to find their kids not doing what they were told and sends them packing to "the woods" to "pick strawberries" (read: go ask the neighbours for food). Father comes home, having made a bunch of cash that day, with a boatload of food. Mezzo [Krisztina Szabó](/scene/people/krisztina-szab/) and baritone [Russell Braun](/scene/people/russell-braun/) play the parents, and they both sing the pants off the role. They turn the nastiness of the way the parents treat their kids in the original on its ear by playing it from a place of despair in the child's misbehaviour, and not so much the poverty they endure. Szabó's Gertrude takes that all upon her and her husband in her rendition of Gertrude's Aria.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581177767/media/2020/02/COC-HG-19-20-04-MC-D-0738_u6qunw.jpg){{% /md %}}

<figcaption>A scene from the Canadian Opera Company's new production of Hansel and Gretel, 2020. Photo: Michael Cooper.</figcaption>

</figure>

On the journey for food the kids finally end up in an upstairs neighbour's apartment with food and, well, stop to eat - and enter The Sandman. Sung by soprano Anna-Sophie Neher, he lulls the children to sleep, and calls on the angels to protect our title characters. Neher wakes us up as the Dew-Fairy after intermission with possibly my favourite costume of the night, complete with freshly brewed coffee to start the day and an open book doubling as her fairy wings.

> It is sure to be a production that's talked about for a good while to come.

Using a technique that didn't really help other productions, we see the parents concocting a plan to teach their kids a lesson while the children sing of delicious strawberries in the forest. This time the silent action wasn't intrusive, but was a great way to tell an offstage story, using the cross-section set of their high-rise. In the first half, the parents head to the super, who comes up with a costume and now emerges in full clown/drag/panto glory as The Witch. The part is kind of unforgiving vocally for the tenor, but Michael Colvin's characterization was a heckuva lot of fun to go on a ride with. His/her aria did kinda stop the show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581177784/media/2020/02/COC-HG-19-20-04-MC-D-0923_hswhlr.jpg){{% /md %}}

<figcaption>Simone Osborne (Gretel), Emily Fons (Hansel) and Michael Colvin (The Witch) in the Canadian Opera Company's new production of Hansel and Gretel, 2020. Photo: Michael Cooper.</figcaption>

</figure>

The second half of the show is where you really see the design innovation. The way the lighting and projections evoke a state of hallucination, as if being tossed around inside a kaleidoscope. The effects were entrancing.

After The Witch is dispatched and the gingerbread children come back to life, we get the wonderful Canadian Children's Opera Company to lead us into a thrilling finale. Under the baton of Johannes Debus, the orchestra played the thick, luscious, symphonic orchestrations incredibly, but the balance was off and there were some definite issues as a listener - which was unfortunate because the physicality of the acting was so on point, I know it was mirrored in the voices, and I just wanted to hear more of it.

A wild visual ride from start to finish, this _Hansel and Gretel_ is great lighter fare to warm you up in the winter. I really appreciated the gestures (blunt as they were) to the fact that this started as traditionally holiday fare in Europe, yet didn't feel out of place a month after Twelfth Night. It is sure to be a production that's talked about for a good while to come.