+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = "2019-02-03T14:42:19+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1549235358/media/2019/02/sqHannigan.jpg"
primary_image_credit = "Photo: Justin Holden, courtesy of the Cleveland Orchestra."
related_articles = ["articles/new-opera-repetiteur.md", "articles/in-review-hannigan-grazinyte-tyle-BBC-proms.md"]
related_companies = []
related_people = ["scene/people/barbara-hannigan.md"]
short_description = "Hannigan's well received turn at the podium, met by an immediate and unanimous standing ovation, should serve to demonstrate to the Cleveland Orchestra, and to classical music institutions across the continent and around the globe, that making an effort to include and elevate marginalized perspectives holds significance well beyond meeting a quota or \"catching up with the times.\""
slug = "all-too-rare-hannigan-takes-the-podium-with-the-cleveland-orchestra"
title = "All too rare: Hannigan takes the podium with the Cleveland Orchestra"
youtube_url = ""

+++
From the moment the orchestra finished tuning and the stage lights dimmed to total darkness, it became clear that the evening’s dose of symphonic convention had ended along with the oboe's A-440. As Principal Flute Joshua Smith played the final notes of Debussy's slinking _Syrinx_ from an offstage hideaway that had audience members' heads swivelling futilely to find him, the stage lights brightened to reveal that Barbara Hannigan had already taken the podium. No sooner had the audience marvelled at her sudden appearance than she raised her arms and readied the next downbeat.

> As the final lyrics of "I've Got Rhythm" so aptly pose, closing out the _Girl Crazy_ Suite with a showstopping high note fit for the Broadway stage – who could ask for anything more?

Capping off the Cleveland Orchestra's annual Miami residency at the Adrienne Arsht Centre with a program inspired by her Grammy-winning album _Crazy Girl Crazy_, Hannigan delivered a gripping display of virtuosity and theatre in her U.S. conducting debut. The performance stands out not only for its exquisite execution and healthy dash of operatic spirit, but also as one of only two programs in Cleveland's 2018-19 season to be led by a woman conductor – begging worthy consideration toward the systemic barriers that make boundary-pushing concerts such as this one all too rare.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549235666/media/2019/02/HanniganWide.jpg){{% /md %}}

<figcaption>Photo: Justin Holden, courtesy of the Cleveland Orchestra.</figcaption>

</figure>

The seamless segue from _Syrinx_ into Sibelius' mesmerizing tone poem _Luonnotar_ launched the program with a flair for drama. Depicting the creation of the moon and stars as recounted by Finnish mythology, _Luonnotar_ offered cascades of densely woven textures on a cinematic scale, the orchestra lurking and cresting with the narrative arc. Hannigan doubled as soprano soloist, turning to face the audience and sing the cryptic Finnish syllables with enthralling fluidity, while her shoulders, elbows, and an occasional toss of the head kept the orchestra on their mark. Floating over the shimmering orchestration, Hannigan lent colour and warmth to Sibelius' sombre dissonances, swelling _senza vibrato_ in an effect that tantalizingly tested the tensile strength of every luminous note.

The spell was abruptly broken when the orchestra disbanded to reset for the next piece, a Haydn symphony requiring reduced personnel. Even with the return to a more standard repertoire and the familiar between-the-pieces orchestral bustle, Haydn's Symphony No. 86, an otherwise lacklustre selection, was enhanced by its placement on a program operatic in scale. With colourful brushstrokes of sustained woodwind harmonies hovering across barlines and a playful showcase of agility from the low strings, the orchestra balanced Classical delicacy with an energy and scope that was all Hannigan's.

> What other gripping and dynamic concert experiences are audiences missing out on because orchestras prefer to celebrate the upcoming #Beethoven250?

After intermission, the concert's second act plunged back into the theatrical, with Berg's haunting _Lulu_ Suite again calling on Hannigan to pull double duty. While at times the orchestra seemed unconvinced of the work's quieter moments, they skillfully conquered Berg's chaotic yet richly Romantic orchestration as Hannigan led the five-movement suite to moments of hair-raising intensity. Exotic timbres appeared and disappeared in mystifying wisps – was that an English horn/trombone duet in the fourth movement? – and Hannigan's fervent vocals in "Lulu's Song," though her lowest register at times was overpowered by the strength of the orchestra behind her, conjured all the darkness and drama of the opera's complicated heroine.

> Following a chaotic few months of #MeToo upheaval resulting in the dismissal of two of the orchestra's most prominent players, it was powerful to watch a woman command the storied Cleveland Orchestra podium.

To close out the evening, Gershwin's _Girl Crazy_ Suite made for a crowd-pleasing finale, co-arranged by Hannigan along with Tony-winning orchestrator Bill Elliot. Featuring three iconic hits from the 1930 musical – the very same year Berg was at work on his grisly _Lulu_ – the arrangement was more than just a medley of showtunes, refusing to shy away from Gershwin's modernist tendencies and serving as the perfect canvas for Hannigan's skillful command of humour and range of style. After a tender verse of "Embraceable You," she turned back to face the orchestra as they set down their instruments and began to sing, eliciting gasps of delighted surprise from the audience. Doubling down on the theatrical punch, Hannigan's conducting took on elements of choreography, playing off the jazz rhythms like a dazzling Broadway routine.

Following a chaotic few months of #MeToo upheaval resulting in the [dismissal of two of the orchestra's most prominent players](https://www.npr.org/2018/10/24/660248392/cleveland-orchestra-fires-two-leading-musicians-after-sexual-misconduct-investig), it was powerful to watch a woman command the storied Cleveland Orchestra podium. That said, Hannigan joins only one other woman guest conductor in a season of mainstage concerts led by 16 different male conductors, performing 69 different works by male composers and only one work by a woman.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549235583/media/2019/02/Hannigan.jpg){{% /md %}}

<figcaption>Photo: Justin Holden, courtesy of the Cleveland Orchestra.</figcaption>

</figure>

Hannigan's well received turn at the podium, met by an immediate and unanimous standing ovation, should serve to demonstrate to the Cleveland Orchestra, and to classical music institutions across the continent and around the globe, that making an effort to include and elevate marginalized perspectives holds significance well beyond meeting a quota or "catching up with the times." Could it be that placing women in positions of creative leadership yields an equally, if not _more_, unique and engaging artistic product? What other gripping and dynamic concert experiences are audiences missing out on because orchestras prefer to celebrate the upcoming #Beethoven250 by programming Every. Single. Symphony. while refusing to engage meaningfully with the breadth of creative practice artists like Hannigan have to offer?

From the first note to the last, Friday evening's concert was one that challenged the status quo, with Hannigan's narrative programming, sharp interpretation, and charismatic performance in both of her dual roles bringing out the well honed talents that make the Cleveland Orchestra widely considered one of America's finest. Surely this is impetus enough to inspire more diverse programming and guest talent as the orchestra's 2019-20 season announcement looms; as the final lyrics of "I've Got Rhythm" so aptly pose, closing out the _Girl Crazy_ Suite with a showstopping high note fit for the Broadway stage – who could ask for anything more?