+++
author = ["authors/greg.md"]
categories = "Review"
date = "2018-10-18T20:41:00-04:00"
lastmod = "2018-10-19T12:28:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539909628086/sqHADRIAN-18-19-02-MC-D-1307.jpg.jpg"
primary_image_credit = "Thomas Hampson as Hadrian in the Canadian Opera Company's world premiere production of Hadrian, 2018. Photo: Michael Cooper."
publishDate = "2018-10-18T20:41:00-04:00"
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/thomas-hampson.md","scene/people/isaiah-bell.md","scene/people/ambur-braid.md","scene/people/karita-mattila.md","scene/people/roger-honeywell.md","scene/people/gregory-dahl.md","scene/people/john-macmaster.md","scene/people/joel-allison.md","scene/people/samuel-chan.md","scene/people/ben-heppner.md","scene/people/annasophie-neher.md","scene/people/thomas-glenn.md"]
short_description = "Antinous, Hadrian&#039;s lover, has possibly the dopest (and gayest) entrance of any opera, ever. Surrounded by a bevy of mostly-nude, highly-sculpted, male dancers, I can only imagine tenor (and friend of Schmopera&#039;s) Isaiah Bell was living his absolute best life - and it showed in his singing. From his first &quot;Antinous&quot; when the cacophany in the pit mirrors the chaotic joy Hadrian feels, to his final moment onstage, Bell is a vision."
slug = "hadrian-a-true-grand-opera"
title = "Hadrian: a true grand opera"
+++

*Hadrian* has finally made it to the stage.

After much anticipation, Rufus Wainwright's new opera [*Hadrian*](https://www.coc.ca/productions/16480) has opened at the [Canadian Opera Company](/scene/companies/canadian-opera-company/) for its world premiere, telling the story of the Roman Emperor at the end of his life and during the time of Jesus's ascent to fame. 

The music is at times cinematic and bombastic, other times it's introspective and intimate. Not surprisingly, the arias seem to be the most successful, given Wainwright's pedigree as a singer/songwriter. The score is a mix of jazz, contemporary "classical", and broadway that melded together pretty seamlessly. A trio that reminded me of Barber's *Adagio for Strings*, a rocking sextet, and some almost irreverent use of tonic resolutions all lend a hand to Wainwright's dramatic score. Daniel MacIvor's libretto is stark and poignant, exploring the many sides of these unfolding events. The concept of two ghosts visiting Hadrian to relive two nights from his life before he passes (think one ghost shy of *A Christmas Carol*) was an excellent tool to focus in on the two days in question which highlight cleanly the struggles each character faces.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539909294382/HADRIAN-18-19-02-MC-D-1460.jpg.jpg)
<figcaption>A scene from the Canadian Opera Company's world premiere production of *Hadrian*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

In the title role, [Thomas Hampson](/scene/people/thomas-hampson/) is stellar. His strong body, handsome face, and kind smile is suited perfectly to the beloved Emperor. He plays his Hadrian as proper, reserved, and polite yet with this undercurrent of charisma roiling beneath the surface. The singing is outstanding. Often skirting the line between operatic and musical theatre production (similar to Wainwright's score), Hampson takes us on a viable emotional journey in an accessible and visceral way; his aria in Act II reveals layer after layer of a man torn between honoring his true self and the conquering, ever-masculine Roman Emperor at the time of Jesus's rise to prominence.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539909312644/HADRIAN-18-19-02-MC-D-0851.jpg.jpg)
<figcaption> Thomas Hampson as Hadrian and Isaiah Bell as Antinous in the Canadian Opera Company's world premiere production of *Hadrian*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

Antinous, Hadrian's lover, has possibly the dopest (and gayest) entrance of any opera, ever. Surrounded by a bevy of mostly-nude, highly-sculpted, male dancers, I can only imagine tenor (and friend of Schmopera's) [Isaiah Bell](/authors/isaiah-bell/) was living his absolute best life - and it showed in his singing.  From his first "Antinous" when the cacophany in the pit mirrors the chaotic joy Hadrian feels, to his final moment onstage, Bell is a vision. Reminiscent of a classical statue himself, Bell's voice is full, lyrical, and unexpectedly darker than one would anticipate. His love scene (yes there is one) is tender and titillating, but most of all, it's supremely tasteful - nay, beautiful. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539909319800/HADRIAN-18-19-02-MC-D-0618.jpg.jpg)
<figcaption>Isaiah Bell (Antinous) in the Canadian Opera Company's world premiere production of *Hadrian*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

Soprano [Ambur Braid](/scene/people/ambur-braid/) shines once again as Hadrian's wife Sabina. Always adept at playing nobility, Braid's Sabina was is nuanced, grounded, and full of nerve. Her gradual realization of Hadrian's true heart is devastating; and her moment of acceptance at seeing Hadrian happy and in love, is equally restorative. Her aria "Will You Have Egypt with Me?" was a moment of exquisite, tangible beauty and I would wager the best singing of the night. I have visions of the next generations of operatic superstars ensuring this aria ends up on all their recital programs. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539909438875/HADRIAN-18-19-02-MC-D-1014.jpg.jpg)
<figcaption>Isaiah Bell as Antinous and David Leigh as Turbo in the Canadian Opera Company's world premiere production of *Hadrian*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

Playing the ghost Plotina and the Sybil, soprano powerhouse [Karita Mattila](/scene/people/karita-mattila/) shows Toronto audiences why she's a force to be reckoned with. From her first note to her last, stalking around the stage in a somehow slinky-yet-stilted manner, Mattila sings every note with her full body and soul. Her music was probably (actually, I'd wager by far) the most intricate, complex, and downright difficult in the whole piece, in spite (or because?) of that Mattila was flawless. Plotina's spectral accomplice, Trajan, is sung supremely well by tenor [Roger Honeywell](/scene/people/roger-honeywell/). His brassy tone mixed wonderfully with Hampson's heroic baritone and Mattila's incredible instrument. [David Leigh](/scene/people/david-leigh/) thrills as the treacherous Turbo. His massive tone and incredible range were on full display.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539909447748/HADRIAN-18-19-02-MC-D-0941.jpg.jpg)
<figcaption> in the Canadian Opera Company's world premiere production of *Hadrian*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

A rather large and stellar supporting cast of none other than [Ben Heppner](/scene/people/ben-heppner/) alongside [Gregory Dahl](/scene/people/gregory-dahl/), [Anna-Sophie Neher](/scene/people/anna-sophie-neher/), [John MacMaster](/scene/people/john-macmaster/), [Thomas Glenn](/scene/people/thomas-glenn/), Josh Fralick of the Canadian Children's Opera Company and COC Ensemble Studio members [Samuel Chan](/scene/people/samuel-chan/) and [Joel Allison](/scene/people/joel-allison/) flesh out a dynamic and intricate society in the midst of some of their most volatile policital turmoil. Shout out to the incredible small ensemble work accomplished by this lot of remarkably talented singers; particularly, by Neher's Egyptian Rosanne Rosannadanna realness in Act II. The Canadian Opera Company Chorus stuns in some of their best singing yet. Wainwright's music allows them the opportunity to sing with their fullest sound which is thrilling. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539909456885/HADRIAN-18-19-02-B-MC-D-OPENING-2485.jpg.jpg)
<figcaption>A scene from the Canadian Opera Company's world premiere production of *Hadrian*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

Glorious are the exaggerated and colourful costumes by Gillian Gallow, and the sets by Michael Gianfresco, which reminded me of grand productions of the late 80s and early 90s (part of me really hopes it's a slight nod to [this](https://youtu.be/QpX80Soj44M")). I really enjoyed the ballet corps through Denise Clarke's choreography being used almost to highlight Hadrian's roiling emotions (read: hormones) - the more agitated Hadrian is, the more agitated they become. Clarke's dance vocabulary ranges from baroque to classical ballet with dashes of contemporary with lyric connections between the two. The shadow dancers during the pivotal love scene at the beginning of Act II are a thing of sheer beauty. 

The staging, I found a bit bizarre. Much of it has the singers facing directly out to the audience. It seems at odds with the emotionally charged, brilliant singing that was happening. Braid and Bell seem the most natural at negotiating the imposing fourth-wall; luckily, the show moved at such an excellent pace (for the most part - the final act might benefit from some judicious cuts) so you barely noticed. The COC Orchestra under Johannes Debus play the lush orchestrations and complicated timings brilliantly, although there were definite balance issues between the sheer amounts of instruments playing versus those singing on stage. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539909463266/HADRIAN-18-19-02-B-MC-D-OPENING-2285.jpg.jpg)
<figcaption>Ambur Braid as Sabina and Thomas Hampson as Hadrian in the Canadian Opera Company's world premiere production of *Hadrian*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

To see a love story that looks like the love I experience as a gay man was probably the most moving of all. The piece is a true grand opera written by a Canadian-American, premiered in Canada; now, let's see it produced all over the world. 

In the meantime, you'll have to hit the Four Seasons Centre in Toronto before October 27. Tickets are [available here](https://www.coc.ca/productions/16480) or at the box office. 

