+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-02-26T21:06:00-05:00"
lastmod = "2018-03-01T08:11:00-05:00"
preamble = "Lawrence Edelson founded American Lyric Theater in 2005 as a response to the dearth of opportunities for new opera to truly develop. In the thirteen years since, ALT has developed works like *The Golden Ticket* (2010), *The Long Walk* (2015), and most recently, *JFK* (2016). A key part of the workshopping of new projects is ALT's [Composer Librettist Development Program](https://www.altnyc.org/composer-librettist-development-program/) (CLDP), a mentorship and creation opportunity for the creators of opera.\n\nWe spoke with Edelson about the value of the CLDP, and the upcoming [*The Living Libretto: Opera in Eden*](https://www.altnyc.org/events/) on **March 18, 3pm** at the National Opera Center, the first public outing of three new works by resident artists of the program: *Bloodlines*, *Nana's Ghost*, and *The Tree of Eternal Youth*."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519772755526/sq---Lawrence-Edelson-and-Justin-F-Chen---photo-credit-David-Perlman.jpg.jpg"
primary_image_credit = "Lawrence Edelson works with Justine Chen, composer of American Lyric Theater's in-progress opera, The Life and Death(s) of Alan Turing."
publishDate = "2018-02-27T21:49:00-05:00"
related_articles = ["articles/american-opera-projects-youre-seeing-the-opera-in-microcosm.md"]
short_description = "&quot;We emphasize a very detailed outlining process at ALT, wherein the librettist and the composer create beat-by-beat outlines - for both the libretto and the score - before a word of the text or a note of the music is written. For a short piece, like those in the upcoming Living Libretto event, this might take one month. For a longer, full-length work, the planning process could take six months or more, especially if extensive research is required.&quot;"
slug = "great-operas-dont-just-happen"
title = "&quot;Great Operas Don&#039;t Just Happen.&quot;"
+++

## Why is something like the CLDP a necessary part of the opera industry in the 21st century?

Great Operas Don't Just Happen. That's American Lyric Theater's tagline, but in brief, that's the answer to your question.

I started the Composer Librettist Development Program (CLDP) just over ten years ago, because I saw a real void in our industry.  I was attending many new operas, but I was frustrated that so few of them were strong both musically and dramatically. I was seeing works by talented composers and librettists, but they didn't seem to quite hit their mark. Why was that?  The answer became clear when I did a deep dive into how works were being developed at opera companies, and what sort of training (or lack thereof) was available for those who wanted to write opera.  

Almost every opera company in the country had some sort of young artist program for singers, but no company had something equivalent for operatic writers. I decided to address that problem. One can be the most talented composer of symphonic music, of art song, but still not have the skills and tools to effectively write an opera. Similarly, one can be an incredibly gifted playwright, lyricist or poet, but not have developed their gifts to bring them forth as powerfully as possible on the opera stage. 

The CLDP was designed to provide training and mentorship, with some of the most successful practitioners in the country (including composers, librettists, dramaturgs, conductors, directors, and performers), that didn't exist anywhere else. In partnership with founding faculty members Mark Adamo and Cori Ellison, I developed the first full-time curriculum for opera composers and librettists in the country - and that's something of which I'm very proud. But what makes me even prouder is to see the success our alumni are having all over the country - writing new operas for companies large and small - from coast to coast.  It is also very exciting to see that since ALT started the CLDP, other companies are now dedicating more resources to training opera composers and librettist. But ALT still is the only full-time, multi-year training program of its kind in the country, and I believe, in the world.

## What about the process of creating opera might be surprising or unexpected to those who aren't composers or librettists?

As I alluded to above, operas take planning before anything is actually written. It is critical for the composer and librettist to take the time to make sure they are really writing the same piece before they actually start writing. This may seem obvious, but it is not always the case!

We emphasize a very detailed outlining process at ALT, wherein the librettist and the composer create beat-by-beat outlines - for both the libretto and the score - before a word of the text or a note of the music is written. For a short piece, like those in the upcoming Living Libretto event, this might take one month. For a longer, full-length work, the planning process could take six months or more, especially if extensive research is required. The process is very detailed, and can be time consuming, but I believe it is critical. 

The other thing that I feel is critical, is the participation of a skilled dramaturg. A dramaturg's job in the new works development process is a kind of diagnostician to help the composer and librettist realize their vision. When developing a new opera, those involved (writers, performers, director, conductor) can become very close to the work and aren't always able to look at the piece objectively. This isn't to suggest that those 'in the trenches' aren't an important part of the process, but an objective set of eyes and ears - someone focused solely on the work itself and not their role in realizing the work - is invaluable. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519774916510/Librettists.jpg.jpg)
<figcaption>Clockwise from top left: Julian Crouch (librettist, *The Tree of Eternal Youth*), Lila Palmer (librettist, *Bloodlines*), and Lorene Cary (librettist, *Nana's Ghost*).</figcaption>
</figure>

## What can audience members expect from CLDP's upcoming event, *The Living Libretto: Opera in Eden?*

Our upcoming *Living Libretto* event showcases work in process by our current first-year resident artists. These three composers and three librettists, have the opportunity to collaborate with each other all season. When the enter the CLDP, they don't enter as pairs, but rather, we encourage artistic polygamy! Every composer works with every librettist, often multiple times, during the first half of their first year with us. During that time, we seek to identify collaborative synergy - that elusive creative spark that has the potential to develop into a longer term artistic relationship. 

This January, we paired up the writers, and they are now working on a one-act opera project under the guidance of Mark Adamo. Mark created this workshop project during the first year of the CLDP in 2007, and it has proven to be one of the most effective teach tools in our arsenal - but it also results in the creation of some very entertaining short operas! The writing teams are provided with a thematic scaffold upon which they develop their operas. Using a template that consists of the same outline and structure, each team develops a unique work, from outline, to libretto, to score. The process encourages extensive communication between composer and librettist at the earliest stages of an opera's development, and reinforces many ideas introduced in the early part of the CLDP curriculum. 

The *Living Libretto* event in March provides us with the opportunity to explore the libretti of these new short operas, before a note of music is written. The three libretti will be read by professional actors, followed by discussion with the writers, which I will moderate.  The discussion explores collaborative style, dramatic structure, characterization, and the timing of action in opera vs. spoken drama, providing audiences with a unique perspective into the early stages of each work's development. Audiences then have the opportunity to hear how these operas have evolved on May 17th, when we present them in concert at Merkin Concert Hall.

## What are highlight projects that have come out of the program since its beginning?

The CLDP has fostered the careers of some of the most exciting artists working in opera today. It's hard for me to name one artist or one project without feeling that I've excluded others that are equally worthy! 

Since our upcoming event focuses on the libretto, I have to mention Royce Vavrek - probably our most prominent alum. Royce was in the inaugural class of the CLDP in the 2007-08 season, and has become one of the most in demand librettists in the world. We were thrilled to co-commission *JFK* with Fort Worth Opera from him and David T. Little. (David is not an alum of the program, but the two of them met at ALT's first CLDP event in 2008, in which two of Royce's first works were featured!) *The Long Walk*, by Jeremy Howard Beck and Stephanie Fleischmann, is a work that I was personally very involved in, having both commissioned it at ALT, and having produced the world premiere at Opera Saratoga. I believe *The Long Walk* is one of the greatest operas to have been written so far in the 21st century. It's already received three productions (at Opera Saratoga, Utah Opera, and Pittsburgh Opera), and deserves to be heard and seen everywhere.  

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519774874857/THE-LONG-WALK---Daniel-Belcher-and-Heather-Johnson---Photo-Gary-David-Gold---Opera-Saratoga.jpg.jpg)
<figcaption></figcaption>
</figure>

In a completely different vein, *Monkey and Francine in the City of Tigers* - a new opera for school touring - just premiered at Houston Grand Opera. It was great fun to collaborate with Houston Grand Opera on this new piece by two CLDP artists, composer Kamala Sankaram, and librettist David Johnston. There are so many more…

I'm proud of all of the incredible work our alumni artists are creating. The CLDP's impact is being felt across the country - with many premieres scheduled that I can't even talk about yet!
