+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-04-25T10:30:00+01:00"
lastmod = "2016-04-25T13:51:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1461588377579/2016-04-25---CooteClaytonFinley.jpg.jpg"
primary_image_credit = "Clockwise from top left: Allan Clayton, Alice Coote, Gerald Finley."
publishDate = "2016-04-25T13:51:00+01:00"
related_articles = ["articles/still-stunning-written-on-skin.md","articles/in-review-enos-the-magic-flute.md"]
related_people = ["scene/people/allan-clayton.md","scene/people/alice-coote.md","scene/people/gerald-finley.md"]
short_description = "Coote and Clayton shared perfect moments of acknowledgement from their places on opposite sides of the conductor&#039;s podium. She was stunning to watch; she had such specificity on her face, from her almost-shy greeting of Gerontius, to her wise, tour-guide qualities as she takes him through his first moments in the afterlife."
slug = "great-nights-the-dream-of-gerontius"
title = "Great nights: The Dream of Gerontius"
+++

It's said that Edward Elgar wasn't satisfied with calling his *The Dream of Gerontius* an oratorio, and it's not hard to see why. Last night's performance by the London Symphony Orchestra, under Sir Mark Elder, had the look of an oratorio, with singers holding scores and in-concert dress filling the stage of the Barbican Centre's Hall, yet the work itself was full of such specificity and honed drama that it felt, well, operatic.

*Gerontius* is set to the poem by John Henry Newman, about a man's journey from his deathbed to his arrival in purgatory. The music seems to begin in the third act of an ongoing tale, a beautiful mirror to meeting a man at the end of his life. 

The LSO played with warmth and fire, as a huge unit and as a collection of chamber ensembles. Maestro Elder left room to breathe around Elgar's sweeping phrases, and he took care to constantly create theatre, not just music. The London Symphony Chorus sang with a lush sound that matched the orchestra's, and they had some of the most exciting moments of drama in Elgar's score. They were beautiful as mourners and angels, and appropriately terrifying as the chorus of demons. 

Three exciting solo singers shared the "roles"; tenor [Allan Clayton](/scene/people/allan-clayton/) was Gerontius, opposite [Alice Coote](/talking-with-singers-alice-coote/) as the Angel, and [Gerald Finley](/scene/people/gerald-finley/) sang the Priest and the Angel of the Agony. Together, the singers were a perfect trio of excellent voices and touching drama; we were drawn in immediately by the constant creativity of their sounds, and even more impressively, the "show" they created even from their seats.

Clayton seemed to embody the "everyman" quality of Gerontius. He sang with a strong, versatile sound that always felt vulnerable. He could go from hollow, wary whispers, to a thrilling silvery sound at the height of his volume and range. He began part II with a stunning hushed voice, and ended with a moving wail that felt like Gerontius was trying to express a lifetime of wants in one breath.

Finley's dark sound was a gorgeous complement to Clayton's, and he sang with attention and energy given to every letter of his text. His Angel of the Agony was particularly exciting; he sounded more human than superhuman, like a man with endless baggage, trying to pay goodness forward towards Gerontius. 

Alice Coote held her status as one of the most moving singers we've ever heard onstage. She took enormous vocal risks, and shared Finley's human traits even as a guardian angel. That spacious warmth in her middle and low voice drives up to an exciting focus and power at the top of her range; she seemed to have a knowing benevolence in her sound that suited the story beautifully. Coote and Clayton shared perfect moments of acknowledgement from their places on opposite sides of the conductor's podium. She was stunning to watch; she had such specificity on her face, from her almost-shy greeting of Gerontius, to her wise, tour-guide qualities as she takes him through his first moments in the afterlife.

The night seemed to be a perfect melding of work and artists. It was our first hearing of *The Dream of Gerontius*, and with the dramatic elements so beautifully highlighted by Sir Mark Elder, the LSO and chorus, and by Clayton, Coote, and Finley, we're now itching to see a staged experiment of Elgar's work.
