+++
author = ["authors/greg.md"]
categories = "Review"
date = "2018-02-05T11:53:00-05:00"
lastmod = "2018-02-05T13:06:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517849262594/sq---17-18-03-MC-D-1526.jpg.jpg"
publishDate = "2018-02-05T11:53:00-05:00"
related_articles = ["articles/searching-for-superlatives-locs-suberb-rigoletto.md","articles/the-price-of-vengeance-rigoletto-at-roh.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/christopher-alden.md","scene/people/stephen-lord.md","scene/people/stephen-costello.md","scene/people/anna-christy.md","scene/people/neil-craighead.md","scene/people/lauren-eberwein.md","scene/people/roland-wood.md"]
short_description = "We find ourselves in the domain of the Duke. He exerts his power over the masses through his manipulation of Rigoletto&#039;s remarkable skill for what is now popularly known as &quot;reading&quot; people."
slug = "great-music-distracting-sexuality-rigoletto"
title = "Great music &amp; distracting sexuality: Rigoletto"
+++

The story of *Rigoletto*, one of Giuseppe Verdi's masterpieces, is one of power, lust, love, and betrayal. Director Christopher Alden and designer Michael Levine have the entirety of the plot taking place in a 19th-century games room, where men of status would retire to play their games of chance, class, and power. This production - and the libretto by Francesca Maria Piave - highlights the class differences that Verdi was noticing at the time of his writing, and brings to the forefront a society that is part-and-parcel of why the 21st-century terms "toxic masculinity" and "patriarchy" exist at all. 

We find ourselves in the domain of the Duke. He exerts his power over the masses through his manipulation of Rigoletto's remarkable skill for what is now popularly known as "reading" people. As you can imagine, this doesn't make Rigoletto any friends. The Duke also exerts his power over other men's wives - right in front of them. An old man throws a curse around, a woman is deflowered, an assassin double-crosses, people die. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517849278204/17-18-03-MC-D-0010.jpg.jpg)
<figcaption>Roland Wood (Rigoletto) in the Canadian Opera Company's production of *Rigoletto*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

Now that you know said story, let's talk about some fine music-making. On February 1st, I finally got the chance to catch the [Canadian Opera Company's *Rigoletto*](https://www.coc.ca/productions/13071). On the podium, conductor Stephen Lord led the COC Orchestra and singers through a great ride of some thrilling music. His tempi were brisk yet fluid, and the musicians under his baton brought all the fire and verve that we love from this incredible composer. The men of the COC Chorus were on point and sang particularly well. Verdi's is incredibly exciting music - and it gets more exciting the more people are involved in making the sound. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517848826588/17-18-03-MC-D-1089.jpg.jpg)
<figcaption>Roland Wood (Rigoletto) and Anna Christy (Gilda) in the Canadian Opera Company's production of *Rigoletto*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

In the title role, baritone [Roland Wood](/scene/people/roland-wood/) was incredible. His massive tone and bright production is a voice made for this kind of singing. Remarkable displays of power and delicacy coupled with a flawless physicalization brought to light Verdi's attempt to humanize the hunchback. When singing with the Duke ([Stephen Costello](/scene/people/stephen-costello/)) there were some breathtaking moments and when sharing the scene with his daughter Gilda, the connection was palpable and fierce. 

Playing the role of Rigoletto's daughter, Gilda, soprano [Anna Christy](/scene/people/anna-christy/) evoked every milligram of innocence and naïveté that makes us feel so strongly for Gilda and her fate. Her bright eyes and honest face shone out from the dark, stern construction of the sets that surrounded her. Her bright, sparkling soprano was used incredibly creatively. For the most part, I found her production to be somewhat bashful, unleashing a dragon of a voice during points of heightened drama. This was definitely most on display during her famed aria, "Caro nome", which rightfully stopped the show. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517848851332/17-18-03-MC-D-0668.jpg.jpg)
<figcaption>Anna Christy (Gilda) and the COC Chorus in the Canadian Opera Company's production of *Rigoletto*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

Stephen Costello's Duke was a highlight for sure. His steely, strong tenor was a perfect fit for this cavalier Lothario. A very handsome man with an incredible instrument, he carried himself with that level of arrogance that both makes you hate a man while making you desperately want to be accepted by him. Basically, think of junior-high heartthrob with all the licence of a wealthy, grown man. 

THE aria - "La donne è mobile" - was brilliant. He sang it with care and finesse, while his body and physicality expressed a nonchalance that made you both envy and despise him. Not going to lie, I'm not sure I'd be able to resist this Duke, and I did feel a bit of an affinity for both Gilda and Maddalena watching him carouse around the stage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517848940036/17-18-03-MC-D-0498.jpg.jpg)
<figcaption>Anna Christy (Gilda) and Stephen Costello (the Duke of Mantua) in the Canadian Opera Company's production of *Rigoletto*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

One important thing to note is that during the time of the original telling of the story of *Rigoletto* is that the men and women were extremely superstitious. One of the things that carried the most weight in this time were curses - in particular if they were uttered by an old man. Enter Monterone, sung phenomenally by [Robert Pomakov](/scene/people/robert-pomakov/). The rage, despair, and embarrassment of what happened to his poor daughter at the hands of the Duke and his horrid henchmen dripped like treacle from every note he uttered. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517848982461/17-18-03-MC-D-1277.jpg.jpg)
<figcaption>(l-r) Bruno Roy (Marullo, in background), Carolyn Sproule (Maddalena), and Stephen Costello (the Duke of Mantua) in the Canadian Opera Company's production of *Rigoletto*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

Bass Goderdzi Janelidze sang the role of the assassin Sparafucile. Well sung, with a profundo that sailed through the hall, Janelidze cut a tall, muscular, handsome figure across the stage. His vocal colour brought the shade of Sparafucile's character to the fore. I did find the presentation to be somewhat presentational and seemed to be a little out of place with the high-drama realism being brought by his fellow soli. As his sister and accomplice, Maddalena, mezzo-soprano Carolyn Sproule sang with a dark, rich, active tone that parried well againt both Janelidze and Costello. 

Supporting roles played by [Neil Craighead](/scene/people/neil-craighead/) (Count Ceprano), [Lauren Eberwein](/scene/people/lauren-eberwein/) (Countess Ceprano), [Bruno Roy](/scene/people/bruno-roy/) (Marullo), Jon Kriter (Borsa), and [Megan Latham](/scene/people/megan-latham/) (Giovanna) were carried out to excellence and each played their role in a way that advanced the drama of the plot and sung with care and excellence. It's always a treat to see current members of the COC Ensemble studio hitting the boards in mainstage productions. Making their COC debuts this time around were two ensemble members [Samuel Chan](/scene/people/samuel-chan/) (Usher) and [Simone McIntosh](/scene/people/simone-mcintosh/) (Page). I'm excited to see these two singers as the grow through the ranks - also, I'm in LOVE with the Page's crimson riding suit costume. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517848991951/17-18-03-MC-D-0096.jpg.jpg)
<figcaption>A scene from the Canadian Opera Company's production of *Rigoletto*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

While a very important part of this story is the use of sexuality as a point of power, I have to say I'm starting to join the camp that is starting to tire of gratuitous displays of it. We see the Duke "park" himself between the legs of Gilda, we see Monterone's daughter being tormented in her undergarments, The Duke leaves from deflowering Gilda and lights up a smoke (which in my view is as dated an expression as walking away zipping up your fly) - it all just seemed a bit much when you already had such great music-making and acting taking place on the stage. Seeing things like Sparafucile manhandling his sister just made me think, "Not everything has to be like a *Game of Thrones* episode." It also made me stop listening to his singing trying to find the connection or the reason for this choice. 

Nevertheless, Verdi was there and on point. The music was stellar and the production was a lavish feast for the senses. Congrats to all on some really remarkable music.

>Rigoletto runs through February 23 at the Four Seasons Centre. For details and ticket information, follow our box office links below.
