+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-05-05T09:43:00+01:00"
lastmod = "2016-05-05T13:37:00+01:00"
preamble = "It's hard to find a more opinionated bunch than a group of theatre and opera lovers. Those who are passionate about these art forms react not only to what and whom they see onstage, but to how productions are cast, funded, and marketed to audiences. \n\nUK-based theatre company [Improbable](http://www.improbable.co.uk/openspace/) has been holding Open Space conversations since 2005, under the banner of [Devoted & Disgruntled](http://www.devotedanddisgruntled.com/); it's a place where opinion and action have a tangible chance to meet. \"Devoted and Disgruntled was born out of frustration,\" writes Improbable Artistic Director Phelim McDermott. \"I was frustrated both with theatre and with myself. I knew things could be better in theatre and I also knew the way I responded to that situation could be more creative. I wanted to stop moaning and actually do something about it.\"\n\nWe spoke with [Sarah Grange](http://www.devotedanddisgruntled.com/profiles/sarahgrange/), Open Space producer and multidisciplinary artist, about the nature of these forums."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1546053309/media/2018/12/sqDandD.jpg"
publishDate = "2016-05-05T12:04:00+01:00"
related_articles = ["articles/the-future-of-opera-is-indie.md", "articles/tete-a-tete.md"]
related_companies = ["scene/companies/devoted-disgruntled.md", "scene/companies/improbable.md", "scene/companies/royal-opera-house.md"]
short_description = "As opera fans, we can&#039;t help but dream about attending similar forums hosted specifically by opera companies, large and small. There&#039;s an inevitable default to trial-and-error with programming seasons, casting singers, and developing relationships with audiences; with an equalizing environment similar to Devoted and Disgruntled, perhaps what audiences want out of opera can become less nebulous."
slug = "great-ideas-devoted-disgruntled"
title = "Great ideas: Devoted &amp; Disgruntled"

+++
## "A holder of an infinite number of opinions"

"Open Space is a process," says Grange. "It's basically a really simple framework that allows people some time and some space to do things that they care about." The conversations address the often unbridgeable gap that lies between people looking for innovation in theatre, and their ability to do something about it. "People feel as though they're not being listened to," explains Grange, and Devoted & Disgruntled's events are about "putting the power to make change into the hands of those who want it."

At the start of an event, participants find a blank timetable posted on the wall, and "whoever turns up fills the timetable with the stuff they want to learn about." The devoted and disgruntled, comprising of theatre fans as well as the people who work in the industry, have a chance to connect with individuals and discuss specific challenges. "It might be as simple as someone getting a really practical answer they needed about how to fill in a bit of a form that they can use to get funding." Often the discussions centre on small desires and ideas, yet "some of them are quite huge things." 

The Open Space framework is exactly that. "We're a kind of holder of an infinite number of opinions and thoughts on things, but all we do is hold them," says Grange. "There's no such thing as Devoted & Disgruntled's opinion on something."

## Conversations, one-sided and otherwise

Part of the struggle in enacting change in the theatre world is not always knowing where, or to whom to direct opinions and ideas. Open Space events are an equalizer of sorts, and "people have found that they're suddenly sitting next to the person they really should be talking to." Of course, that only happens when the right people attend. "The really mainstream companies tend not to turn up," admits Grange. 

"There are a lot of sessions that get called where [people are saying], 'we have a problem with the National Theatre, we've got a problem with some big organization,' etc., but they're not there to sort of defend themselves. It can become a bit of a one-sided conversation, because they're not engaging in it. Whereas if they came, they'd hear a lot of really useful stuff from their audiences and from their emerging artist companies. But they have to be in the room to have that conversation."

Implied silence from no-show companies isn't necessarily damning, but it can be indicative of how seriously a company takes the opinions of their audiences, or at least how welcome those opinions are. 

The theatre-centric Open Space events attract a lot of students and representatives from fringe companies, but in terms of big players, opera has a decent track record of responding to the disgruntled. In fact, the [Royal Opera House](http://www.roh.org.uk/functions/devoted-and-disgruntled) hosted a two-day Open Space event in June of 2015. "The opera one's quite interesting," adds Grange, "in that compared to the more theatre-based events that we run, I'd say there were more venue-running heads of companies."

## Encouraging companies to respond

Themes of diversity in the theatre world come up often at Open Space events, particularly access for disabled persons, both on and off the stage. One ongoing catalyst for this kind of conversation was the trend of disabled actors, with years of experience and training, who weren't granted auditions for roles. At least, for roles that don't focus primarily on a character's disability. "I think if you were a disabled actor you would get quite bored of only being able to tell the one story," says Grange. "They're not defined by their disabilities."

One "funny bunch" at a diversity-themed event, "came up with the idea that they would go on strike from the jobs that they didn't have anyway. So they all turned up outside the National Theatre with placards." In this case, the National Theatre responded to the clear implication that an entire group of actors had not been fairly considered in the audition process. "The National Theatre did end up doing a whole special 'audition call' couple of days, specifically for people with disabilities. So I think they were quite embarrassed about that."


## Taking positive steps

On top of awareness, Open Space events have fostered positive action. In 2013, [Stella Duffy](http://funpalaces.co.uk/fun-palaces-at-shift-happens/) called a session to be focused on the centenary of Joan Littlewood, the English theatre director who was among the first to work with "immersive theatre", the concept of a theatre workshop, and to develop the idea of a "Fun Palace" with architect Cedric Price. Littlewood and Price said of their fun palace, "Choose what you want to do – or watch someone else doing it. Learn how to handle tools, paint, babies, machinery, or just listen to your favourite tune. Dance, talk or be lifted up to where you can see how other people make things work. Sit out over space with a drink and tune in to what's happening elsewhere in the city. Try starting a riot or beginning a painting – or just lie back and stare at the sky."

Out of D&D's conversation about celebrating Littlewood's work has come the support of over 100 theatre companies, and fun palaces have been getting built over the past three years. "It's kind of really exploded," says Grange, "so that's a massive thing." The whole thing came out of Open Space participants who asked about celebrating Joan Littlewood, and "someone in the session felt the responsibility, not just to say 'yeah we should', but to go and do it."

Improbable has taken advantage of their front-seat view of the Devoted & Disgruntled community, and while they're a small company with their own sets of limited resources, they've adopted the concerns voiced over 11 years of Open Space conversations. Grange notes that Improbable has been able to develop "a huge awareness of access issues. As a company we've become advocates and we've taken that on board."

It's a beautifully simple way of responding to the public, who are full of opinions that can seem to disappear into a vacuum, and gaining access to a broader range of input and ideas that aren't necessarily directed towards Improbable.

As opera fans, we can't help but dream about attending similar forums hosted specifically by opera companies, large and small. There's an inevitable default to trial-and-error with programming seasons, casting singers, and developing relationships with audiences; with an equalizing environment similar to Devoted & Disgruntled, perhaps what audiences want out of opera can become less nebulous.