+++
author = ["authors/molly-simoneau.md"]
categories = "Review"
date = "2018-05-07T11:05:00-04:00"
lastmod = "2018-05-07T20:54:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525705419433/SopranoEmilyPogorelcCunegondeandTenoAlekShraderCandideinWNOsproductionofCandide_creditScottSuchman.jpg.jpg"
primary_image_credit = "Emily Pogorelc (Cunegonde) and Alek Shrader (Candide) in Candide, Washington National Opera, 2018. Photo: Scott Suchman."
publishDate = "2018-05-07T11:52:00-04:00"
related_articles = ["articles/candide-the-best-of-all-possible-productions.md","articles/too-many-jewels-the-search-for-meaning-pbos-candide.md"]
related_companies = ["scene/companies/washington-national-opera.md"]
related_people = ["scene/people/alek-shrader.md","scene/people/emily-pogorelc.md"]
short_description = "The production is the focal point of the Kennedy Center&#039;s programming in honor of Bernstein&#039;s 100th birthday, and amounts to the most enjoyable night of theater offered by WNO this season with its just-right combination of thrilling music, vocal gymnastics, impressive theatrical effects, belly-aching comedy, and effective storytelling."
slug = "grappling-with-daily-life-wnos-candide"
title = "Grappling with daily life: WNO&#039;s Candide"
+++

As I sat down to the computer to write my review of Saturday night's premiere of [Washington National Opera](/scene/companies/washington-national-opera/) Artistic Director Francesca Zambello's [production of *Candide*](http://www.kennedy-center.org/calendar/event/OSOSF), I began by glancing at the front page of a couple major US newspapers. "Storms, Missteps, and an Ailing Grid Left Puerto Rico in the Dark," "SpaceX using Rocket Technology that could Endanger Lives, Nasa Advisers Say," "Hawaii's Big Island Rocked by Historic Earthquake as Lava Flow Threatens Homes," "Bombing Kills at least 14 Afghans Registering to Vote." Tragedies happen everywhere, every day. People motivated by greed or power commit evil acts over and over again. They always have, and they always will. It's this daily, unrelenting horror of life that Leonard Bernstein's adaptation of the Voltaire classic attempts to grapple with, and somehow does it hilariously.

The production is the focal point of the Kennedy Center's programming in honor of Bernstein's 100th birthday, and amounts to the most enjoyable night of theater offered by WNO this season with its just-right combination of thrilling music, vocal gymnastics, impressive theatrical effects, belly-aching comedy, and effective storytelling.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525705131417/WynnHarmonPanglossEdwardNelsonMaximilianAlekShraderCandideEmilyPogorelcCunegondeandElizaBonetPaquetteinWNOsCandide_creditScottSuchman.jpg.jpg)
<figcaption>Wynn Harmon (Pangloss), Edward Nelson (Maximilian), Alek Shrader (Candide), Emily Pogorelc (Cunegonde) and Eliza Bonet (Paquette) in *Candide*, Washington National Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

The famous overture opened the evening, conducted by Nicole Paiement, and lacked some "oomph," perhaps down to a tempo which was just a hair too slow. (But I want to take a moment to commend WNO for hiring women conductors for half of their operas this season, a goal which every company should be aiming for.) During the overture, the curtain rises on a run down theatrical scaffold, cluttered with old furniture, storage trunks, boxes of props, piles of junk covered with drop clothes, and plain muslin backdrop. A man dressed in 18th-century clothes walks on stage and surveys the space, walks over to a trunk, moves it across the stage, opens it and reaches in, and to gasps from the audience, holding his hand, out walks the first member of the ensemble, followed by another and another, then the rest of them emerge from under the drop cloths. It's a simple bit of theatrical trickery that is delightfully effective, and perfectly sets the tone for the evening. This man is Voltaire, the all-powerful storyteller, and anything that happens happens because he makes it happen.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525705195368/BaritoneEdwardNelsonMaximilianBaritoneWynnHarmonPanglossTenorAlekShraderCandidandSopranoEmilyPogorelcCunegondeinWNOsCandide_credtScottSuchman.jpg.jpg)
<figcaption>Edward Nelson (Maximilian), Wynn Harmon (Pangloss), Alex Shrader (Candide), and Emily Pogorelc (Cunegonde) in *Candide*, Washington National Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

Voltaire (as well as the hilariously stubborn optimist, Dr. Pangloss) is played with scene-stealing charm by Wynn Harmon, a baritone whose past credits walk the line between musical theater and opera, making him ideally suited for this role. He has superb comic timing and owns the stage during his several rambling monologues as Dr. Pangloss, which never become tedious, although the characters sharing scenes with him would hardly agree.

Voltaire introduces the titular Protagonist, Candide, sung by tenor [Alek Shrader](/scene/people/alek-shrader/) who seems very at home in Bernstein's quasi musical theater style. Shrader's portrayal of the loveable doofus is so endearing, as he is bounced from one hilarious predicament to another, that the moment where he finally gives up and loses hope is a painfully profound punch in the gut.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525705179862/TenorAlekShraderasCandideinWNOsproductionofCandide_creditbyScottSuchman.jpg.jpg)
<figcaption>Alek Shrader (Candide) in *Candide*, Washington National Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

There has been some buzz about the new young coloratura, [Emily Pogorelc](/scene/people/emily-pogorelc/), who was announced just last month to fill in as Cunegonde for Katheryn Lewek who withdrew from the production due to pregnancy. At only 21 years old, she is just finishing her degree at the prestigious Curtis Institute, and has been making a splash in the competition circuit. Pogorelc doesn't fail to impress with her performance of the showstopper "Glitter and be Gay", executing Bernstein's impossibly high-flying vocal acrobatics with apparent ease, her voice sparkly and bright. Although her limited experience shows somewhat in her acting which lacks a certain depth, she is certainly a fast-rising star, and one to watch. Her acting is helped however by Zambello's sharp direction of the scene, which has Cunegonde attempting, and failing, to mask her rage and resentment at the abuse she has suffered by smiling and laughing through her pain. She spits the words "See how deftly I conceal the dreadful, dreadful shame I feel," angrily at Voltaire who looks on bemusedly from an armchair in the corner. At the end of the piece as the audience erupts into the customarily huge ovation for such a difficult vocal showpiece, Cunegonde exits and it is Voltaire who smiles and bows and accepts the audience's adoration. Just another man taking credit for a woman's hard work, in one of the many all-too familiar scenes of this biting satire.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525705226094/SopranoEmilyPogorelceinWNOsproductionofCandide_creditScottSuchman_Fotor.jpg.jpg)
<figcaption>Emily Pogorelc (Cunegonde) in *Candide*, Washington National Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

A cast of supporting characters is filled with singers who excel in ensemble acting, several of whom play more than one role, and all of whom appear to be having a rollicking good time. Baritone Edward Nelson minces and whines as the spoiled peacock Maximilian; bass-baritone Matthew Scollin brings rich vocals to James the anabaptist and Martin the pessimist; Frederick Ballentine sings with a rich and pingy tenor, and lands several laugh-out-loud moments; tenor Alexander McKissick takes his characters the Grand Inquisitor and the Governor hilariously to their limits; soprano Kerriann Otaño sings impressively as Vanderdendur, and creates hilarious physical comedy as the Baroness; Eliza Bonet sings admirably as Paquette, and I wanted to see more of her.

As the Old Woman, WNO brought back beloved hometown mezzo-soprano Denyce Graves.  There's a tradition of casting singers who are retired or in the twilight of their careers in roles like this one, which are more about stage presence than vocal beauty, so it made sense to hire the veteran Graves. Unfortunately, her worn voice is not even up to this role, sounding harsh and shrill anytime she reached for her upper register, and she failed to make up for her waning voice with her stilted and robotic dialogue. Many of her jokes missed their mark. For this musical-theater adjacent performance filled with spoken dialogue, singers were mic'd and Grave's voice, considerably larger than those of her colleagues, stuck out unpleasantly in ensemble numbers.

Wisely, Zambello fleshed out the WNO Chorus with several musical theater actors, resulting in an appropriately brighter, brassier sound, and a more intensely physical performance than I've ever seen from an opera chorus. The chorus never misses a dramatic beat and earned quite a few laughs, especially in the Act I battle scene, and in the *Auto da fé*.  And the entire ensemble sang beautifully in the moving finale.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525705253978/TenorsAlekShraderCandideandFrederickBallentineCacambvisitEldoradoinWNOsproductionofCandide_creditScottSuchman.jpg.jpg)
<figcaption>Alek Shrader (Candide) and Frederick Ballentine in *Candide*, Washington National Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

At the end of his long series of tribulations, the weary Candide resolves to move to a mountaintop farm and to "Make our Garden Grow." Philosophers have debated the meaning of the conclusion of Voltaire's satire for centuries. Is it about retreating to solitude, shutting oneself off potentially painful situations? Bernstein seems to take it to mean that you must be the gardener of your own fortune. As the old saying says, "you reap what you sow." In this turbulent time of political strife, war, corruption, refugee crises, and climate change, "Make our Garden Grow," feels like an encouragement to sow seeds of kindness and charity, and to cultivate a garden of hope.
