+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-09-22T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1569198345/media/2019/09/sqMichaelChioldi_withOrchestra_ryga9k.jpg"
primary_image_credit = "Michael Chioldi in Henry VIII, Odyssey Opera, 2019. Photo: Kathy Wittman."
related_articles = ["articles/chemistry-sizzles-onstage-in-paride-ed-elena.md", "articles/in-review-stiffelio.md"]
related_companies = ["scene/companies/odyssey-opera.md"]
related_people = ["scene/people/michael-chioldi.md"]
short_description = "Of course, when the music found its dramatic stride, Saint-Saëns could deliver the drama in spades.The septet (actually an octet) that closed Act II made me wonder why it was cut to begin with, for it's the perfect musical climax to the second act."
slug = "grand-if-overlong-henry-viii"
title = "Grand, if overlong, Henry VIII"
youtube_url = ""

+++
This is perhaps the second season in a row that [Odyssey Opera](/scene/companies/odyssey-opera/) has chosen to open their season with a French grand opera from the Romantic era. From an artistic standpoint, this makes a certain amount of programming sense: these operas are typically grandiose, and they fit perfectly in Odyssey Opera's mission statement of performing repertoire that is commonly underperformed today.

> It can veer on the side of being overlong, and goodness was this opera overlong.

Thus, one would think that opening the season with Camille Saint-Saëns' opera _Henry VIII_, about the tumultuous time in his reign when he divorced Catherine and married Anne Boleyn, would prove to be a good opener in Odyssey Opera's season-long exploration of the Tudor dynasty, particularly when it restores content that had been cut from the opera's many versions.

Of course, the problem with opening with an opera from this era is that it can veer on the side of being overlong, and goodness was this opera overlong. The program stated the runtime was three and a half hours: when I checked my watch at the end of the concert, it had been almost five hours, with a few elderly patrons slowly leaving Jordan Hall throughout the last two acts.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569198041/media/2019/09/Ensemble_withOrchestra_w2ff11.jpg){{% /md %}}

<figcaption>The ensemble of Henry VIII, Odyssey Opera, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

Worse, some of it is down to pacing issues in Saint-Saëns' score even beyond the lengthy ballet halfway through the opera. The program makes mention about the cuts to the score being mostly against Saint-Saëns' will, but apart from a truly head-scratching cut at the end of Act II, I wonder just how reluctantly he made a few of those cuts: some arias could have been shortened or completely cut to perhaps more concise dramatic effect, in particular the Cardinal Carpeggio's aria midway through Act III and Catherine of Aragon's aria that opens the scene in her bedchambers in Act IV.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569198057/media/2019/09/MichaelChioldi_yg3f2g.jpg){{% /md %}}

<figcaption>Michael Chioldi in Henry VIII, Odyssey Opera, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

Sometimes even without the cuts, the music had a tendency to get a little meandering, particularly in the outer two acts with the least work done. That aspect can perhaps be best described by the first twenty minutes of this performance: the music was quite lovely, but a technical hiccup meant that the audience spent the first twenty minutes of the whole work stuck without subtitles, and it proved deadly since the music gave the audience nothing to pinpoint exactly what the mood should have been.

> The confrontation between Henry's wives in Act IV also made for a satisfying musical climax, particularly when Henry storms in.

Of course, when the music found its dramatic stride, Saint-Saëns could deliver the drama in spades.The septet (actually an octet) that closed Act II made me wonder why it was cut to begin with, for it's the perfect musical climax to the second act. The courtroom scene at Westminster in Act III was nothing short of a musical marvel, with the music living up to the grand scale of the scene. Particularly inspired, too, were several arias throughout the second and third acts that shone spotlights on characterization. The confrontation between Henry's wives in Act IV also made for a satisfying musical climax, particularly when Henry storms in.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569198068/media/2019/09/HilaryGinther_kggrnm.jpg){{% /md %}}

<figcaption>Hilary Ginther in Henry VIII, Odyssey Opera, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

It does ultimately tie into Odyssey Opera's mission statement to shine a light on underperformed gems of the repertoire, and there is a lot to like about Saint-Saën's _Henry VIII_. But alas, perhaps some of the cut content should have stayed cut, because as is the work is simply too long, particularly for a concert staging.

> From the moment she stepped on-stage, she embodied Anne Boleyn's every dramatic beat with pitch-perfect conviction.

The performance, at least, was absolutely top-notch from everyone involved, and it was to an extremely high standard even by Odyssey Opera's already high standards. The orchestral playing was sensitive, always providing great accompaniment in that it supported the singers while highlighting Saint-Saëns' use of the orchestral palette to indicate a mood change. The choral singing was reliably great as always, with powerful tutti singing and even several chorus members who knocked it out of the part in several solo parts. Maestro Rose navigated both forces through the rich score with a deft hand that held the balances just right.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569198157/media/2019/09/EllieDehn_ErinMerceruio_withOrchestra_lcckps.jpg){{% /md %}}

<figcaption>Ellie Dehn and Erin Merceruio in Henry VIII, Odyssey Opera, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

But the lead singers commanded the show from beginning to end. [Michael Chioldi](/scene/people/michael-chioldi/) in particular made for a commanding _Henry VIII_: his mannerisms throughout the performance were pitch-perfect (he elicited some laughs from a particularly well-placed chuckle in response to Anne Boleyn asking him something in Act II), but his voice easily shone above all else. He easily overpowered Saint-Saëns' thick orchestration with great ease, with a voice that could be both tender and menacing, often at the flip of a hat.

From the moment she stepped on-stage, Hilary Ginther embodied Anne Boleyn's every dramatic beat with pitch-perfect conviction, and her voice proved both tender and powerful: her Act II aria where she contemplates how Henry is considering making her his new queen very nearly stopped the show, and was one of the highlights of the evening.

Also of note was Yeghishe Manucharyan as Don Gomez de Feria, the man that Anne Boleyn leaves to be with Henry. He did flag out a little towards the end owing in big part to the sheer length of the opera, but he still maintained a beautiful tone throughout, and he leant a pathos to what I imagine would be a typically thankless role.

> I feel only that I would have enjoyed the whole evening much more, however, if some of the content had been trimmed down somewhat.

Ellie Dehn took a little bit of time to warm up to Catherine of Aragon, but once she found her dramatic footing in the conflicts her character endured, she really took to the role. Her Act III aria where she addresses the jury at the trial in Westminster was brimming with pathos and warmth, and it made me wonder why she seemed so disconnected from the text in Act I.

The minor roles also had rather excellent singing, but in particular Kevin Deas stood out as the Cardinal Campeggio, who managed to fill his Act III aria with just enough authority that I could almost overlook the fact that it was about two minutes too long.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569198228/media/2019/09/YeghisheManucharyan_ggyv4u.jpg){{% /md %}}

<figcaption>Yeghishe Manucharyan Henry VIII, Odyssey Opera, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

There was certainly quite a lot to like about Camille Saint-Saëns' _Henry VIII_. Odyssey Opera certainly showed as much with a performance that was committed across an entire five-hour runtime, even if a few pieces did flag out on occasion. I feel only that I would have enjoyed the whole evening much more, however, if some of the content had been trimmed down somewhat.

As is, the night was simply too long, and even people with the attention span for Wagner would have flagged out at some point in the evening. Still, there is something to _Henry VIII_ that does beg closer examination, and so we will only have to hope that another company will pick up where Odyssey Opera started and continue to find a way to stage this work.