+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-04-06T12:12:00+01:00"
lastmod = "2017-04-06T22:59:00+01:00"
preamble = "Update: Fleming may not be retiring after all. Thanks to one of our readers, we found [Tom Huizenga's WRTI article](http://wrti.org/post/hold-ren-e-fleming-not-retiring-opera) clarifying some of the points made in Fleming's interview with the New York Times."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1491480465749/2017-04-06---Fleming-Domingo.jpg.jpg"
primary_image_credit = "Renée Fleming in Der Rosenkavalier, ROH/2017, Plácido Domingo in La traviata, LAO/2014. Photos: Catherine Ashmore/Craig Mathew."
publishDate = "2017-04-06T13:18:00+01:00"
related_articles = ["articles/placido-baritones-ripple.md","articles/whos-afraid-of-the-aging-singer.md"]
related_companies = ["scene/companies/washington-national-opera.md","scene/companies/los-angeles-opera.md","scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/renee-fleming.md","scene/people/plcido-domingo.md"]
short_description = "Why, when Domingo is clearly still involved in the operatic industry in a huge way, must his schedule still include staged performances in roles meant for true baritones? When his work at WNO, LAO, and Operalia includes time spent with such skilled artists at the starts of their careers, has Domingo considered the possibility that he is taking opportunities from these rising stars - particularly the hardworking baritones?"
slug = "graceful-exits-double-standards"
title = "Graceful exits &amp; double standards"
+++

"You don't want people to be saying, 'Oh my God, please stop...Or, 'I heard her when.'"

That's what superstar soprano [Renée Fleming](/scene/people/renee-fleming/) told [*The New York Times*](https://www.nytimes.com/2017/04/05/arts/music/the-diva-departs-renee-flemings-farewell-to-opera.html?action=click&contentCollection=undefined&region=Footer&module=WhatsNext&version=WhatsNext&contentID=WhatsNext&moduleDetail=most-emailed-2&pgtype=undefined) about her soon-approaching final performances on the opera stage, as the Marschallin in Robert Carsen's [stunning production of *Der Rosenkavalier*](http://www.schmopera.com/in-review-der-rosenkavalier-at-roh/) at the Metropolitan Opera. Fleming couldn't have planned for a more fitting exit; Strauss' opera is a favourite, the Metropolitan Opera holds significance in Fleming's career, and the role of the Marschallin is filled with elegant and wise musings on what it means for a woman to grow older.

Of course, Fleming won't disappear from the spotlight, only from staged operatic productions. She'll continue to sing concerts, make recordings, and dedicate more time to her position as a creative consultant at the Lyric Opera of Chicago. At 58, Fleming still sounds fit; but it's no surprise that the savvy career woman is making sure her stage career wraps up strictly on her own terms, before anyone else suggests she should call it quits. She's retiring, to the dismay of many of her fans - and frankly, there isn't a better way of closing a chapter of one's career.

It's interesting to consider what another, perhaps even more famous, operatic star observes about Fleming's decision and timing. At 76 years old, [Plácido Domingo](/scene/people/placido-domingo/) has acknowledged that the undeniable fire, beauty, and visceral thrill of his tenor voice have waned in recent decades, yet his response has been to turn instead to baritone repertoire. The reception has been mixed for Domingo's performances of Verdi's Simon Boccanegra, Macbeth, and Giorgio Germont in *La traviata*; it's clear that his highest notes may have faded, but the singer retains his star presence onstage.

We've [written before](/placido-baritones-ripple/) about what it means for someone like Domingo to do what most in the operatic industry cannot. In effect, he has decreed for himself a major change in voice type, and has leapt into his second life as a baritone with major roles written for the so-called "Verdi baritones", and at the world's biggest houses. It's a hard pill to swallow, in a competitive industry that overflows with skilled singers who can't land enough work, that Domingo has opted to take some of the major baritone opportunities for himself. 

For a few reasons, it's a bit baffling that his 2017 [calendar](http://www.placidodomingo.com/us-en/calendar) currently has him set to sing Rodrigo in *Don Carlo* in Vienna, Germont in Munich, and the title role in an in-concert performance of *Macbeth* in Madrid. Domingo's schedule also includes a fair amount of conducting, and in the last 15 years, he has held leading positions at Washington National Opera and Los Angeles Opera (the latter of which he still holds until 2019). He's also the founder of Operalia, the World Opera Competition, and he remains heavily involved today.

So, the questions include: why, when Domingo is clearly still involved in the operatic industry in a huge way, must his schedule still include staged performances in roles meant for true baritones? When his work at WNO, LAO, and Operalia includes time spent with such skilled artists at the starts of their careers, has Domingo considered the possibility that he is taking opportunities from these rising stars - particularly the hardworking baritones? 

The most interesting question that comes out of comparing Fleming and Domingo is this: could Fleming have gotten away with a similar shift, from soprano roles to mezzo-soprano? Could she have made a second career singing Carmen, Azucena, or Amneris?

It's hard to say whether Domingo is that much more of a star than Fleming. It likely depends on who you ask. It's equally hard to say whether or not the double-standard - if it indeed exists - has anything to do with gender, but generally, women have a a more delicate path to tread as they grow older in the public eye. What's clear is that Domingo's second career as a baritone hinges unambiguously on his leverage within the opera industry; his positions at major houses, his ability to continuously sell tickets, and his genuinely impressive legacy seems to have major power.

We're excited to see what Fleming's coming decades look like; if it does simply come down to an excellent instrument and significant power, she should be pretty darn unstoppable.
