+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-10-17T16:39:00+01:00"
lastmod = "2016-10-18T16:48:00+01:00"
preamble = "Originally commissioned by [Opera Theater of Saint Louis](/scene/companies/opera-theater-of-st-louis/) in 2014, *27*, the opera by Ricky Ian Gordon and Royce Vavrek, is getting its New York premiere this week, as part of the 75th anniversary season of MasterVoices. On [October 20 and 21](http://www.nycitycenter.org/tickets/productionNew.aspx?performanceNumber=10076#.WAT2T5MrJE4), the opera about the life and relationship of Gertrude Stein and Alice B. Toklas will come to the [New York City Center](http://www.nycitycenter.org/tickets/productionNew.aspx?performanceNumber=10076#.WAT2T5MrJE4), starring the iconic [Stephanie Blythe](/scene/people/stephanie-blythe/) as Stein, and Heidi Stober as Toklas.\n\nThe semi-staged production features direction by James Robinson, and conductor Ted Sperling leads the Orchestra of St. Luke's. The [New York premiere of *27*](http://www.nycitycenter.org/tickets/productionNew.aspx?performanceNumber=10076#.WAT2T5MrJE4) features newly-composed music for the MasterVoices chorus, expanded from its original three-voice form. \n\nWe spoke with Gordon and Vavrek about this new presentation of their opera, and about their unique perspective on the story of Gertrude Stein, Alice B. Tolkas, and their salons at 27 rue de Fleurus in Paris.\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476719707669/2016-10-18---Square-27.jpg.jpg"
primary_image_credit = "Elizabeth Futral, Theo Lebow, Tobias Greenhalgh, and Daniel Brevik in OTSL’s 2014 production of 27. Photo: Ken Howard."
publishDate = "2016-10-18T16:00:00+01:00"
related_companies = ["scene/companies/opera-theatre-of-st-louis.md"]
related_people = ["scene/people/stephanie-blythe.md","scene/people/royce-vavrek.md"]
short_description = "&quot;The idea was inspired by the idea of writing an opera for Stephanie, because of the personal relationship I have with her and knowing how her favorite thing to do is PRESIDE! It seemed a perfect fit and it has been a dream. She is an outsized voice and personality like Stein, it is a perfect fit. Stephanie has enormous love, artistry, courage, basically, BALLS!&quot;"
slug = "gordon-vavreks-27-the-new-york-premiere"
title = "Gordon &amp; Vavrek&#039;s 27: the New York premiere"
+++

## What prompted you to focus on this aspect in the life of Gertrude Stein, her relationship with Alice B. Toklas?

**Ricky Ian Gordon**: Because that is what interested me. There is so much music theatre that deals with Gertrude Stein as a librettist. I wanted to somehow evoke what fascinated me about their brave before their time open union and the incredible stimulation and fun of the salon.

**Royce Vavrek**: While I was doing my initial research, digging into countless books by and about Gertrude Stein, my imagination was really ignited by the relationship of Gertrude and Alice.  We really wanted to explore the salons that were held at their residence at 27 rue de Fleurus in Paris, and Alice played such a huge role tending the guests, particularly the wives of the genius artists and writers that would make their way to their apartment.  I also knew that I wanted the piece to be a memory play, so the work begins with Alice, who outlived Gertrude by many years, knitting the world that they shared back to life.  It really is a story of the grand romance of two of the 20th century's most iconoclastic figures.

## Can you tell us about the new developments of *27* for this semi-staged production with MasterVoices? How do the additional chorus voices change the affect of this story?

**RIG**: By adding the chorus I was able to expand the choral palette, which was already there, only I created it for three male voices. This was that opportunity you never get, to make something BIGGER! It expands the world of "denizens" but it also provides a larger sense of witness. 

**RV**: Narratively, the work remains the same, but what I’m most excited about is to hear the density that the chorus adds to the experience.  Gertrude and Alice’s apartment on rue de Fleurus was rather small, but it hosted many of the most important minds (artistic and otherwise) every Saturday. I think that having such a mighty choral compliment is going to make us feel the warmth and population of Stein and Tolklas' salons in a very vibrant way.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/mt261BIAH1A" frameborder="0" allowfullscreen></iframe>
</figure>

## How has it been to work with Stephanie Blythe in creating, and now recreating the role of Gertrude Stein?

**RIG**: Magnificent. The idea was inspired by the idea of writing an opera for Stephanie, because of the personal relationship I have with her and knowing how her favorite thing to do is PRESIDE! It seemed a perfect fit and it has been a dream. She is an outsized voice and personality like Stein, it is a perfect fit. Stephanie has enormous love, artistry, courage, basically, BALLS! This has felt like a blessed union since the idea was born! 

**RV**: Stephanie Blythe has one of the most amazing, singular voices in the world today.  When I dreamed up the libretto it was always with the knowledge that Stephanie was Gertrude, so she was always in my imagination when I was crafting the text and drama for the opera.  More and more it seems like I am writing works for particular performers, which really does help in creating multi-dimensional portraits. There is a great deal of alchemy that exists when creating opera, and when all of the parts come together – text, music, performance, production – it creates a world more dynamic than the sum of its parts, and something truly special happens. I feel like that is the case with *27*… we all came together knowing that the soul of the work resided in Gertrude Stein and we all wanted to celebrate her spirit in the most vigorous way possible.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476719668024/2016-10-18---27.jpg.jpg)
<figcaption>Stephanie Blythe as Gertrude Stein in Opera Theatre of Saint Louis’ 2014 production of *27*. Photo by Ken Howard.</figcaption>
</figure>

## Do you have any favourite moments in your opera?

**RIG**: I like this opera very much, it just sort of rolled out. But the final act kills me. Alice's exchanges with Picasso after Gertrude has died, and Gertrude's reemergence moves me very much. I love these two women. 

**RV**: I really love the flashback scene in the first act when Gertrude sits for Picasso (Theo Lebow). It dramatizes the hundredth and final time that Gertrude modeled for the portrait that now hangs in the Metropolitan Museum.  The scene ends with a duet where Gertrude tells Picasso, who is frustrated and "can't see [her] face anymore" in the painting, that "the face will emerge" and that genius requires “doing nothing, nothing, and more nothing.”  I have so many other moments that I love, too: Hemingway (Daniel Brevik) and his Bullshit aria, the doughboy scene when Gertrude begs an American soldier (Tobias Greenhalgh) for some coal, eggs and cigarettes, and Alice's (Heidi Stober) lullaby as Gertrude is dying.

