+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-08T13:25:00-04:00"
lastmod = "2017-07-10T07:48:00-04:00"
preamble = "Conductor [Gordon Gerrard](/scene/people/gordon-gerrard/) is an in-demand favourite among the Canadian operatic and symphonic scenes. He is Music Director of the Regina Symphony Orchestra, which kicks off its Masterworks Series on September 23 with solo percussionist Dame Evelyn Glennie. Later this season, Gerrard returns to the National Ballet to conduct [*The Nutcracker*](https://national.ballet.ca/Productions/2017-18-Season/The-Nutcracker), before he heads to the University of British Columbia for [*La Cenerentola*](https://music.ubc.ca/ubc-opera-presents-la-cenerentola) in February 2018.\n\nIt was a delight to chat with the passionately pragmatic Gerrard (who has some great writing of his own [up on the *Regina Leader Post*](http://leaderpost.com/author/gordon-gerrard)). He spoke about learning from singers, rehearsal time management, and taking literally one's job description.\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499534706158/2017-07-08---Gordon-Gerrard.jpg.jpg"
publishDate = "2017-07-10T07:48:00-04:00"
related_articles = ["articles/spotlight-on-christopher-allen.md","articles/talking-with-conductors-harry-bicket.md","articles/talking-with-conductors-riccardo-frizza.md","articles/talking-with-conductors-alexander-joel.md","articles/elektra-and-parsifal-yannick-at-the-met.md","articles/talking-with-conductors-lidiya-yankovskaya.md","articles/talking-with-conductors-damian-iorio.md"]
related_people = ["scene/people/gordon-gerrard.md"]
short_description = "&quot;My job is to get the orchestra to support how the singer wants the piece to go. My favourite singers are the ones who bring convincing ideas of the shapes they want to make in the music. If communication lines are open, I can act as the link between them and the players in the orchestra.&quot;"
slug = "gordon-gerrard-music-doesnt-really-work-without-breath"
title = "Gordon Gerrard: &quot;Music doesn&#039;t really work without breath.&quot;"
+++

## What do you think conductors and singers can learn from each other?

An awful lot of what I know about music, I learned from working with singers and even singing myself. (This may surprise some, but there was a time when I was actually paid money to sing—in public!) I'm not sure I can fully articulate why, but music doesn't really work without breath. As human beings, we express so much in how we breathe just in our everyday communications with each other. When we make music, the expressive capabilities of breath are only heightened. If all conductors learned to breathe the way singers do, there'd be a lot more great conducting out there.

As for singers learning from conductors, the biggest thing may be understanding how an orchestra functions, especially when it comes to rhythmic organization and rubato. There are things you can do with a piano that you just can't get an orchestra to do. Conductors can offer the best insight on how to organize what you want to do with a phrase in such a way that all 70 people on stage (or in the pit) can understand it.

## How is conducting an orchestra different from leading singers, and how does your process change when there are both involved?

One of the biggest misconceptions about conducting is that "keeping the beat" is the conductor's number one job. Of course, someone has to decide when to start and when to stop, and that is an important aspect of conducting, to be sure; but when you're dealing with an orchestra, usually 60+ players and limited rehearsal, the more important part of a conductor's job is to communicate to the orchestra *how* to play, not when. So assuming the players are playing together, which most professional orchestra do well on their own, it's my primary job to make a convincing shape of the music.

When singers are involved, it's a whole different ballgame. It's much more like how an orchestra shifts its function when accompanying a concerto soloist. My job is to get the orchestra to support how the singer wants the piece to go. My favourite singers are the ones who bring convincing ideas of the shapes they want to make in the music. If communication lines are open, I can act as the link between them and the players in the orchestra. 

## In terms of the balance between conductor and director, how would you describe an ideal rehearsal room environment while staging an opera?

I suspect this is the same with any work environment, but in opera, it really should always come down to knowing what your job description says. The tricky thing in our line of work is that you can't really find these job descriptions written down anywhere. Once you're around it all for a while though, you start to get a pretty clear picture. Know your job, do it…and only it. Even if you think you can help with some aspect of someone else's job description, don't. This applies absolutely to both conductor and director. It's essential to respect your colleagues enough to let them do their job. This means that even if I think I may have a solution to a particular staging issue that may be causing problems, I keep my mouth shut. On the other side, a director of course is always entitled to an opinion on the tempo of a particular passage, but the room is more comfortable for all if he or she keeps this opinion to themselves.

I've had almost entirely positive experiences working with stage directors. I'd like to think that the era of oversized-ego conductors and directors is largely behind us. Maybe that's just me and my rose-coloured glasses.

## Do you have any standout moments from your conducting career so far? What about "bucket list" items?

I've been able to make a lot of great music over the past years, but the real standouts are the collaborations with artists I respect. There are many to list, but most recent in my mind is a concert version of *Candide* we did with the Regina Symphony this past spring. We were very lucky to have artists like [Judith Forst](/scene/people/judith-forst/), [Tracy Dahl](/scene/people/tracy-dahl/) and [Colin Ainsworth](/scene/people/colin-ainsworth/) with us. It was a remarkable night for me personally, and also for our audience. These are the things you don't forget.

As for my bucket list, it's a long one. There’s a whole whack of German operas I've never worked on that I'd really like to take a crack at. Wagner isn't done much in this country, so I haven't yet really had a chance to experience from the inside yet. I'm a big John Adams fan, so I'd like to delve into more of his music. And *Peter Grimes*. 
