+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-12-29T15:44:00-05:00"
lastmod = "2016-01-08T14:13:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451944574407/2016-01-04---Open-Door.jpg.jpg"
publishDate = "2016-01-09T09:00:00-05:00"
related_articles = ["articles/4-tips-for-when-there-are-too-many-notes.md","articles/rehearsing-a-messiah-that-moves.md"]
short_description = "For those involved in the creation of opera, we know that there&#039;s a less-glamourous method of reaching that finished product; so, we&#039;re able to experience the joy of watching a singer achieve something we watched her struggle to do, or admire how things like set, costume, and lighting design can turn a regular old opera scene into utter magic. "
slug = "good-ideas-rehearsalasperformance"
title = "Good ideas: rehearsal-as-performance"
+++

We know you love to go to the opera. So, wouldn't you also love to be a fly on the wall for the rehearsals?

[R.B. Schlather](/scene/people/rb-schlather/) is a rising figure among opera directors, working often with [Christopher Alden](/talking-with-director-christopher-alden/) on productions like *La clemenza di Tito* (Canadian Opera Company) and *Die Fledermaus* at English National Opera. He's making waves on his own, too, and Schlather recently reinvented the operatic experience; it was one of those things that seems glaringly brilliant in hindsight.

In the fall of 2014, Schlather collaborated with New York's [Whitebox Art Center](http://whiteboxnyc.org/), and their *WhiteboxLab > SoundLounge* exhibition series, to put up Handel's *Alcina*. The [reviews were rave](http://www.nytimes.com/2014/09/24/arts/music/alcina-from-r-b-schlather-at-the-whitebox-art-center.html?_r=1), and not just because the cast was solid and the direction strong. 

Schlather opened up the two-week rehearsal period to the public, letting them watch, free of charge, as *Alcina* went from the page to the stage. These rehearsals were part of the collective listening experience for the audience, part of "The Show". The project was a success, and so in 2015, Schlather followed up with Handel's *Orlando* for a second performance exhibition with Whitebox. After checking out some of the open rehearsals for *Orlando*, [Jennifer Rivera](/scene/people/jennifer-rivera/) wrote for [*Huffington Post*](http://www.huffingtonpost.com/jennifer-rivera/rb-schlathers-handel-inst_b_7197470.html), "My first instinct when hearing that the rehearsals were open and part of the installation was "Why has nobody thought to do this before??'"

It's a great question. I doubt that nobody has thought to do this before, but for some reason, it doesn't really happen. It's perhaps a too-obvious response to the ongoing question of how to bring new butts in the seats at the opera. A large proportion of the people who love opera are the same people who make it. They're pianists, singers, directors, perhaps not all as full-time professionals, but they've seen opera from onstage as well as from the audience. As one of those people myself, I can say confidently that an opera's rehearsal process has unfailing power to make everyone involved fall in love with the final product.

You might counter my argument with something like, "Of course you love it, you're a part of it!" Well, yeah.

Look. Opera, as a finished product, is impressive. It's so impressive, perhaps, that the average "uneducated" listener has nothing to connect themselves with what they're seeing. The orchestra plays *so well*, the singer sing *so loudly* and the whole operatic experience is so full of people and their polished skills that it's outside of the realm of understanding (or caring) for people who have no introduction to opera at all. At best, it's, "Oh wow, look at that!" At worst, it's, "I don't feel like I belong here."

For those involved in the creation of opera, we know that there's a less-glamourous method of reaching that finished product; so, we're able to experience the joy of watching a singer achieve something we watched her struggle to do, or admire how things like set, costume, and lighting design can turn a regular old opera scene into utter magic. Part of the reason we artists love opera so much, is because we know how difficult all of it is; on opening night, it's a culmination of crazy amounts of talent and hard work.

I say all this to argue that opening up the rehearsal process can help bridge the gap between opera and its new, potential audiences. The finished product is already exciting, but it's hard to appreciate the soprano's wicked coloratura or a Wagnerian's sheer vocal stamina, without hearing anything *except* The Show. They don't know Zerbinetta’s agonizing perfection of singing a high D while being lifted in the air, because no one let them see that part of the process. And no, the inherent skills on the operatic stage *may not actually be obvious* to these audiences.

Open rehearsals aren't entirely new, I'll grant you that. In my experience, the rehearsals that allow spectactors are carefully chosen, and I can't help but notice that many of the opera donors come to the "fun" rehearsals, near the end of the process, in the theatre, with the orchestra, where everything is basically already figured out. 

Artists aren't always comfortable with the idea, either; they're often hesitant to show an unfinished product to people outside of the creative team. Singers, unless you're a nightmare to work with, or you showed up to the first rehearsal underprepared, I guarantee that where you start with a piece like *Alcina* is already impressive; and what you'll do within a few weeks can appear almost superhuman. The impact can't really be compared to hearing 2-3 hours of the finished product.

R.B. Schlather's idea for opening up his *Alcina* rehearsals is simple and obviously effective. He may not have been thinking about attracting new audiences with this project in particular, but to make rehearsals a part of The Show is to allow listeners to experience opera the way its biggest fans do: as a progression of steps towards something greater than the sum of its parts.

Opera is like magic; we all want to know the magician’s secrets. 
