+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-04-10T22:28:00-04:00"
lastmod = "2015-04-12T19:28:00-04:00"
preamble = "[Tapestry Opera](https://tapestryopera.com/)_ continues its 35th anniversary season with _[_Tap:Ex Tables Turned_](https://tapestryopera.com/tapex-tables-turned/)_, running March 20 & 21 at the Ernest Balmer Studio in the Distillery District. Soprano _[Carla Huhtanen](http://www.carlahuhtanen.com/)_ (right) teams up with Montréal-based composer and turntablist_[ Nicole Lizée](http://www.nicolelizee.com/)_ (left) to present \"a boundary-breaking, multi-media concert.\" I was curious about the combination of electronic and acoustic sounds, and the collaboration between artists of such different professional backgrounds. I was able to chat with Carla, Nicole, and Tapestry Opera Artistic Director _[Michael Mori](https://tapestryopera.com/about/who-we-are/)_, about this must-see concert. _"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428719082442/HuhtanenLizee.jpg.jpg"
primary_image_credit = "Photo credits l-r: Murray Lightburn, carlahuhtanen.com​"
publishDate = "2015-03-15T10:28:00-04:00"
related_articles = ["articles/go-see-this-tapex-metallurgy.md","articles/dont-miss-anthropologies-imaginaires.md"]
related_companies = ["scene/companies/tapestry-opera.md"]
related_people = ["scene/people/carla-huhtanen.md","scene/people/michael-mori.md"]
short_description = "Tapestry Opera continues its 35th anniversary season with Tap:Ex Tables Turned, running March 20 &amp; 21 at the Ernest Balmer Studio in the Distillery District. Soprano Carla Huhtanen (right) teams up with Montréal-based composer and turntablist Nicole Lizée (left) to present “a boundary-breaking, multi-media concert.” "
slug = "go-see-this-carla-huhtanen-and-nicole-lizee-in-tapex-tables-turned"
title = "Go See This: Carla Huhtanen and Nicole Lizée in Tap:Ex Tables Turned"
+++

## 1\. A soprano and a turntablist are an unlikely pair to share a stage; what brought you together for this project?

**Nicole**: "Michael [Mori] brought us together. And I had met Carla after a show about a year ago and knew I wanted to work with her. I'm not sure that we're really an 'unlikely pair'. I can anticipate my practice of melding turntablism, electronica, glitch, with 'classical' and 'concert' music extending into the world of opera. And Carla is a perfect collaborator – amazing chops, dynamic, forward thinking, great ideas. We both come from the classical tradition while loving and working in the experimental art scene." 

**Carla**: "I've always loved [Nicole's] music. I approached her and asked her if she'd written a lot for the voice, and she admitted that she hadn't. I basically asked her to consider writing something with me in mind. I thought that it was about high time that she got writing for the voice, considering that she has a really good ear for timbre and sound colour." 

**Michael**: "[Nicole's music is] not popular or generic in any way; I don't know anyone else who has that kind of a voice. So instantly I'm thinking, 'Ok, how can we bring Nicole into the opera world?' because I think it's something that we need desperately, a fresh look at popular art forms." 

## 2\. What has it been like to work together with such different professional backgrounds?

**Carla**: "Yeah, I'm learning a lot about her process, I guess? I'm learning a lot about, let's say, electronic timing, for lack of a better word. She gives me notes, she gives me scores, but actually have trouble matching up the score with the video and the audio, because I can tell that's not the way she's composing. She'll have bars that switch from 3/16 to 8/16 to 9/16, and I'm like, this doesn't make sense, if I could just figure out a click track or something! So, I found I could learn it better by just listening and watching the video. 

"It gives you a surprising amount of freedom when you're used to being stuck to a piano and a score, and I like it because it gets you off the page right away. It calls for a different type of learning…it's like improvisation." 

**Nicole**: "It's been great. But we do share a lot of interests – and actually share some background, coming from the classical and new music worlds. And we both want to see opera and classical music forge ahead, experiment, and remain vital." 

**Carla**: And our percussionist, don't forget that. [Ben Reimer](http://music.cbc.ca/#!/artists/Ben-Reimer) plays the drumkit and various percussion instruments, and he's so talented, and he knows Nicole very well, he's worked with her for a long time. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428719219823/NicoleLizee-pc-ChrisHutcheson.jpg.jpg)
<figcaption>Nicole Lizée. Photo: Chris Hutcheson</figcaption>
</figure>

## 3\. Why have you included video footage of icons like Alfred Hitchcock and Maria Callas?  

**Nicole**: "The pieces include both audio and video footage as starting points for new pieces. The new Callas work and my previous work The Criterion Collection are based on glitch that delve into the worlds of certain icons, films and filmmakers that have made a marked impact on my aesthetic. Each work is constructed around damaged and deconstructed audio and video – chewed and warped videocassettes. The resulting errors and imperfections are woven together to create a sonic landscape over which accompanying instrumental material – itself emulating the traits of broken or malfunctioning media – is performed live. 

"The relationship between the live performer and the icon is important. The living performer interacts with the lost, forgotten or even dead icon, simultaneously breathing new life and emotion into the characters while bending, stretching, and hacking the original context, function and storyline. The performer infiltrates the scene and engages with the character; at once becoming part of the mise-en-scène, while simultaneously guiding it into a new direction." 

**Michael**: "What was sort of, we'd been wondering what ties this show together, and really I think it's the idea of taking on icons. We look up to these people, and they sort of set the standard of beauty for us with these iconic shows. [Nicole] is not afraid of taking on a "legend", and seeing how she could find inspiration." 

**Nicole**: "Ultimately I treat the source material as a musical instrument – as part of the ensemble. It is a very specific colour or timbre – not unlike a violin or any member of the orchestra – that has its own distinctive sound or appearance. I want to use that sound like I would any other instrument and integrate it into a chamber work." 

## 4\. What do you think _Tap:Ex Tables Turned_ has to do with today's opera scene?

**Nicole**: Opera had at one time been about reflecting the 'now' – both sonically and conceptually – and I think there's a place for stories to be told that reference our generation and encapsulate the wide array of sounds and images therein. I grew up in the '70s and '80s (and even the '90s – there was possibly some growing up done in University). This was the age of rapid technological advancements – uniquely straddling both analogue and digital. Music and art were experimental and many disparate genres were born. Counterculture was important and had a following. I was obsessed with all of this while simultaneously being obsessed with classical music. What happens when worlds merge? New stories, sounds, visions, ideas, etc. There's room in classical music and opera for ideas and devices that very much exist and mean something to a lot of people: electronic instruments, hi-hats, glitch, grooves, sampling, iconography, etc. My formative years were filled with both so it feels very natural for these worlds to coexist. 

**Michael**: "Sometimes you have to view [projects like] this as production development, for a product. A company like Apple, when they come out with a new product, they want to test it, they want to put it out there and see how people's reactions are. This is certainly a time when we want to take more risks, and try some things that are more bold. 

"The significance of Nicole's music is that her electronic music is based on acoustic recordings. As opposed to being completely electronically-generated sounds, what she's doing is capturing and twisting and deconstructing and reconstructing and making new music out of bits of things that were once ours. I think the cool balance with Nicole is that the sound effect is electronic, but it has come from live recording. 

The way she deconstructs things and messes with them, there's so much potential there…that is opera, having connections with other art forms." 

**Carla**: "You get an emotional reaction from it. You can hear what [Nicole] is doing and how she's creating it, and there's a really clear effect emotionally, it's really of inescapable. Good opera does that, using sound, or whatever technique it has. You will feel a certain way, and you'll certainly walk away with very good conversations to have at the bar afterwards.
