+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-03-28T08:12:00-04:00"
lastmod = "2015-04-24T09:39:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429882714583/CanadianArtSong.jpg.jpg"
publishDate = "2014-03-28T08:12:00-04:00"
related_people = ["scene/people/lawrence-wiliford.md","scene/people/monica-whicher.md","scene/people/brett-polegato.md","scene/people/colin-ainsworth.md"]
short_description = "I went to hear some music by Canadians yesterday at the Richard Bradshaw Amphitheatre, as part of the Free Concert Series (that you should all be checking out!). It was a chance for the public to hear some of the products of the ongoing Canadian Art Song Project, headed by artistic directors Lawrence Wiliford and Steven Philcox."
slug = "go-canada"
title = "Go, Canada!"
+++

I went to hear some music by Canadians yesterday at the Richard Bradshaw Amphitheatre, as part of the [Free Concert Series](http://www.coc.ca/PerformancesAndTickets/FreeConcertSeries.aspx) (that you should all be checking out!). It was a chance for the public to hear some of the products of the ongoing [Canadian Art Song Project](http://www.canadianartsongproject.ca/), headed by artistic directors [Lawrence Wiliford](http://www.lawrencewiliford.com/) and [Steven Philcox](http://www.music.utoronto.ca/faculty/faculty_members/faculty_n_to_z/steven_philcox.htm).

At [this particular concert](http://files.coc.ca/pdfs/concert140327.pdf), I had the chance to hear three sets of songs that were entirely new for me, and one world-premiere that was new for everyone. Soprano [Monica Whicher](https://learning.rcmusic.ca/glenn-gould-school/programs-and-faculty/studio-faculty-biographies/monica-whicher) and pianist [Kathryn Tremills](http://www.kathryntremills.com/) began the program with _Dissidence (trois poèmes de Gabriel Charpentier),_ written in 1955 by late composer [Pierre Mercure](http://en.wikipedia.org/wiki/Pierre_Mercure). Throughout the set I was reminded of how much I love Claude Debussy's _Chansons de Bilitis_. The songs had that blurred, impressionistic, and almost modal sound you can hear in Ravel and Poulenc. Monica Whicher sounded beautiful this set, and she was utterly committed to singing every single word. I loved the end of the second song, "Psaume", which used a hymn-like steadiness to rise slowly and continuously, grasping upwards in the final words. It was a vocal risk that Monica took, and I'm glad she did. Kathryn's playing was full of specificity, and she maintained a soloistic way of playing that actually helped the singers deliver text in a simple way.
Monica and Kathryn returned later in the afternoon to perform the world premiere of young Canadian composer [Matthew Emery](http://composermatthewemery.wordpress.com/)'s _Three Songs, _written between 2011-2013\. I thought they were simply beautiful, spontaneous and improvisatory; Emery also chose wonderful poetry, by Archibald Lampman, Eugene Field and the ever-heartbreaking Oscar Wilde. I was reminded of Samuel Barber and Carlisle Floyd. The communication of these texts was a clear priority for Emery, and Monica again had me hanging on her last word. The music itself had a few pop-inspired chords; I thought of André Previn, and even [Jason Robert Brown](http://jasonrobertbrown.com/). If there were listeners who decided this made Emery's work less legitimate, I was too busy enjoying myself to notice. I thought he treated these special texts with care and lots of heart. At the keys, Kathryn took advantage of the warmth in Emery's harmonies, and Monica simply moved me very, very much with her singing.

Kathryn was also joined by celebrated Canadian tenor [Colin Ainsworth](http://www.colinainsworth.ca/), to perform selections from _A Play of Passion_, written in 2012 by [Derek Holman](http://www.musiccentre.ca/node/37210/biography) with texts by Sir Walter Raleigh, Samuel Daniel, Robert Laurence Binyon and James Joyce. It was no easy sing, but Colin took to making his primary task the frankness and clarity of text. Holman set the famous Joyce text, "I hear an army" in an uncomfortable, uneasy way that couldn't have been farther from the deafening, cathartic setting by Samuel Barber. I thought Colin was an open and honest orator in this set, taking enormous risks that paid off. I appreciated Kathryn's playing the most in this set; Holman's writing for the piano was of course complementary to the voice, but asked a certain level of autonomy of the player, so that the singer would be free to deliver the poetry. It's often hard for a pianist to identify this type of song, and Kathryn did it beautifully.

The final set of songs was the world premiere of [James Rolfe](http://en.wikipedia.org/wiki/James_Rolfe_(composer))'s _Moths_, with texts by [André Alexis](http://www.thecanadianencyclopedia.com/en/article/andre-alexis/); _Moths_ was performed by baritone [Brett Polegato](http://www.brettpolegato.com/index.html) and pianist Steven Philcox. James was at the concert, and he spoke briefly about the set. It's really a song cycle, about the experiences of a dreaming person throughout a night of sleep. I loved this premise, and I thought the songs lived up to the grand imaginative scope that comes with dreaming. The songs were schizophrenic, jumping from what felt like bizarre musical jokes to the nagging dread that accompanies a nightmare. I loved the poetry because it used unexpected words like "electromagnetic" and "watermelon".

Steven's playing was assertive and versatile, and he gave each song its own personality. Brett's singing was inviting and warm; I thought he seemed under-energized in this performance, and it might have been that he chose to use a score. I missed some of the great words, and I noticed it after the clarity I heard in Monica Whicher and Colin Ainsworth. But I liked his reedy sound, and both he and Steven sold me on this song cycle.

Stay posted for a look at _[Ash Roses](http://www.musiccentre.ca/node/81884)_, the first commercial recording from the Canadian Art Song Project, featuring the works of Derek Holman. The team of Canadian artists includes soprano [Mireille Asselin](http://www.mireilleasselin.com/), tenor Lawrence Wiliford, harpist Sanya Eng, and pianist [Liz Upchurch](http://www.arts-orford.org/en/academie/professors/liz-upchurch-2/). The future of Canadian art song is certainly in good hands.

Who's your favourite Canadian artist? Let us know in the comments below!
