+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = "2018-10-20T14:42:00-04:00"
lastmod = "2018-10-23T14:24:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540063244541/sqErinWall_JanaiBrugger_IDOMENEO_0V8A5918_c.jpg.jpg"
primary_image_credit = "Erin Wall (Elettra) and Janai Brugger (Ilia) in Idomeneo, Lyric Opera of Chicago, 2018. Photo by Kyle Flubacker."
publishDate = "2018-10-20T15:23:00-04:00"
related_articles = ["articles/talking-with-singers-matthew-polenzani.md","articles/an-operas-evolving-relevance-turandot.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/matthew-polenzani.md","scene/people/janai-brugger.md","scene/people/erin-wall.md","scene/people/angela-brower.md"]
short_description = "Matthew Polenzani, in his fifteenth(!) role at the Lyric, is the dramatic anchor of the cast. His dependably excellent and grounded singing is ideal for the role of this grand, eloquent king. Even in the most bravura moments, Polenzani&#039;s singing was refined and elegant."
slug = "glamour-fury-idomeneo-in-chicago"
title = "Glamour &amp; fury: Idomeneo in Chicago"
+++

[*Idomeneo*](https://www.lyricopera.org/idomeneo?gclid=CjwKCAjwpKveBRAwEiwAo4Pqm656DoDhYc1kknLj3a-GcYjgCu9T8ehsgtK46tGb2TVIAjtziJLQ9hoCEEEQAvD_BwE) is often referred to as Mozart's first mature opera, though he wrote it when he was just twenty-four. While its trappings — a vengeful god, a sea monster, a beautiful captive princess — have all the hallmarks of a conventional fairytale, the crux of the story is the love between a father and his son. 

The myth is a familiar one and at its heart is a plot that echoes across storytelling and faith traditions: a father, (Idomeneo, King of Crete), survives a terrible shipwreck after making a ominous bargain: Idomeneo promises Neptune that in exchange for sparing him, he will kill the first person he sees when he reaches dry land. Horror of horrors, Idomeneo is met by his beloved son, Idamante, who has come to the shores of Crete to mourn the loss of his father, who by that time is presumed drowned. 

The rest of the opera revolves around Idomeneo desperately trying to avoid the inevitable sacrifice of his son, while Idamante reckons with his father's sudden coldness toward him. That the conflict and love between Idomeneo and Idamante felt so real and urgent in this production, despite the plot's fantastical elements and the staging's highly-stylized and artificial form of movement, is down to the beautiful work of tenor [Matthew Polenzani](/talking-with-singers-matthew-polenzani/) (Idomeneo) and mezzo-soprano [Angela Brower](/scene/people/angela-brower/) (Idamante).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540063096009/IDOMENEO_0V8A6337-Cropped_c.jpg.jpg)
<figcaption>A scene from *Idomeneo*, Lyric Opera of Chicago, 2018. Photo by Kyle Flubacker.</figcaption>
</figure>

Matthew Polenzani, in his fifteenth(!) role at the Lyric, is the dramatic anchor of the cast. His dependably excellent and grounded singing is ideal for the role of this grand, eloquent king. Even in the most bravura moments, Polenzani's singing was refined and elegant. An especial highlight was his Act II "Qual mi conturba i sensi… Fuor del mar", when Idomeneo realizes the full tragedy of his vow to Neptune, in one of the most poignant musical and poetic moments of the score: 

"Yes, there will<br>
be three victims for Neptune on the same altar,<br>
afflicted with like pain –<br>
son, father and Ilia,<br>
one pierced by the knife, two by grief."<br>

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540063106105/AngelaBrower_ErinWall_MatthewPolenzani_DavidPortillo_IDOMENEO_0V8A5208_c.jpg.jpg)
<figcaption>Angela Brower (Idamante), Erin Wall (Elettra), Matthew Polenzani (Idomeneo), and David Portillo (Arbace) in *Idomeneo*, Lyric Opera of Chicago, 2018. Photo by Kyle Flubacker.</figcaption>
</figure>

In her Lyric debut, Angela Brower is stellar as Idamante. With a fresh, agile sound and beautiful dramatic instincts, Brower is a fantastic Mozartian singer, imbuing every moment with emotion. When Idamante sings to his beloved Ilia, there was aching tenderness in Brower’s voice, (especially in the duet "S'io non moro a questi accenti," the musical highpoint of the evening), but elsewhere, there was youthful bravado, acute desperation, and yet another radically different vocal color when Idamante nobly accepts his fate. I'm unabashed to say that Brower was my favorite part of this immensely talented cast of singers.

At the beginning of the opera, we are also introduced to the two women whose fates frame the story: Elettra and Ilia. While certainly in later works, Mozart's women are among his most fleshed-out and richly complex characters, in this opera, he is content to leave them as archetypes. Ilia, the captive princess, is good — the story takes pains to demonstrate her apparently limitless capacity for forgiveness, love, and self-sacrifice. Against all odds, she has fallen in love with Idamante, the clement son of her captor. At the opera's long-awaited climax, she offers herself to be sacrificed in place of her beloved — an act of love that inspires Neptune's change of heart. Idamante is spared and Ilia's devotion is rewarded with marriage and title. Soprano [Janai Brugger](/scene/people/janai-brugger/), returning after a lovely debut last year as Lìu in *Turandot*, sang the role with a gracious, easy sound ideal for this heroine. Never self-indulgent but always expressive and nuanced, Brugger's "Zeffiretti lusinghieri" was one of my favorite moments of the night. Dramatically, Brugger seemed stymied by the minimalist staging, which perhaps just didn't give her enough to do.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540063116648/JanaiBrugger_AngelaBrower_IDOMENEO_0V8A4435_c.jpg.jpg)
<figcaption>Janai Brugger (Ilia) and Angela Brower (Idamante) in *Idomeneo*, Lyric Opera of Chicago, 2018. Photo by Kyle Flubacker.</figcaption>
</figure>

By (extreme) contrast, the outrageous Elettra, Ilia's self-proclaimed rival, is malignant jealousy in the shape of a woman. A spectacular [Erin Wall](/scene/people/erin-wall/) plays her as incessantly shaking with barely-contained rage. Wall smartly studs Mozart's gorgeous writing with vocal effects — howling, hissing, and cackling her way through the role. Lurching around the stage in a gown with extravagant pannier, Wall's Elettra was the perfect combination of glamour and uncouth fury. The absurdity of Elettra and her ultimate demise, (she implodes at the end of her final outburst), is rightly played for laughs. 

*Idomeneo* involves the chorus much more than Mozart's later operas. Unfortunately, the LOC chorus, (usually so strong), underwhelmed and tended to lag behind Sir Andrew Davis' baton. In more dramatic moments, the sopranos threatened to unbalance the ensemble with gratuitously loud and strained singing. However, there were moments of pure bliss, as in the pastoral "Placido è il mar" of Act II, which also features Elettra (in a rare moment of calm).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540063127216/NoahBaetge_DavidPortillo_ErinWall_IDOMENEO_0V8A7665_c.jpg.jpg)
<figcaption>(l-r) David Portillo (Arbace), Erin Wall (Elettra), and Noah Baetge (High Priest) in *Idomeneo*, Lyric Opera of Chicago, 2018. Photo by Kyle Flubacker.</figcaption>
</figure>

The opera house loudly cheered the return of the Lyric Orchestra, which was recently on strike for five days after negotiations with management reached an impasse\*. Sir Andrew Davis looked very happy to be back on the podium, where he inspired a light, fresh interpretation of the score.

Noah Baetge deserves special mention for his rich-voiced portrayal of the High Priest. David Portillo, and current Patrick G. and Shirley W. Ryan Opera Center members Whitney Morrison, Kayleigh Decker, Josh Lovell, Alan Higgs, and David Weigl round out the cast. Sir Andrew Davis conducts [*Idomeneo* at the Lyric Opera of Chicago](https://www.lyricopera.org/idomeneo?gclid=CjwKCAjwpKveBRAwEiwAo4Pqm656DoDhYc1kknLj3a-GcYjgCu9T8ehsgtK46tGb2TVIAjtziJLQ9hoCEEEQAvD_BwE) until November 2nd.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540063142463/ErinWall_IDOMENEO_0V8A6015_c.jpg.jpg)
<figcaption>Erin Wall (Elettra) in *Idomeneo*, Lyric Opera of Chicago, 2018. Photo by Kyle Flubacker.</figcaption>
</figure>

\*While this is not the appropriate place to detail the strike or the specifics of those negotiations, if you’re looking for insight, I strongly recommend [this article](http://www.consideredsources.com/lyric-opera-strike/?fbclid=IwAR0RGJ9GV0cv2JHNDabGLY-EOJaP6v_ivVX5kVqGUwnOYbQNDG23HpEgY6A), which describes some of the specifics of the  situation and how journalists color how labor disputes are presented to the public. Insightful, important points.
