+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-06-04T16:42:00-04:00"
lastmod = "2015-06-11T08:52:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433559406329/Nemo.jpg.jpg"
publishDate = "2015-06-11T08:52:00-04:00"
related_articles = ["articles/why-this-opera-singer-took-a-nonsinging-job-at-an-opera-company.md","articles/wells-fargo-isnt-antiarts-everyone.md","articles/in-defense-of-the-day-job-.md","articles/taking-the-leap-from-freelance-to-fulltime.md","articles/moving-on-up-3-ways-my-old-career-prepared-me-for-my-new-one.md"]
short_description = "A couple of articles popped up this week that circle around the big issue of taboo in the arts. Allison Ford, in her &quot;I Gave Up My Dream And I&#039;d Do It Again,&quot; talks about her decision to walk away from pursuing a career in theatre, at the tender age of 20-something. Closer to opera is Kathryn McAdam&#039;s &quot;Soprano on Sabbatical...What on earth does she mean?&quot;, where she reveals a beautifully personal story about her struggles with vocal health that finally trumped all."
slug = "giving-up-caring-too-little-and-other-taboos"
title = "Giving up, caring too little, and other taboos"
+++

A couple of articles popped up this week that circle around the big issue of taboo in the arts. Allison Ford, in her ["I Gave Up My Dream And I'd Do It Again,"](http://www.thegloss.com/2012/06/05/career/i-gave-up-my-dream-and-id-do-it-again-731/) talks about her decision to walk away from pursuing a career in theatre, at the tender age of 20-something. Closer to opera is Kathryn McAdam's ["Soprano on Sabbatical...What on earth does she mean?"](https://sopranoonsabbatical.wordpress.com/2015/06/04/soprano-on-sabbatical-what-on-earth-does-she-mean/), where she reveals a beautifully personal story about her struggles with vocal health that finally trumped all.

McAdam describes trying out various diets, taking tons of supplements, staying hermit-like and sober, and hydrating so much she turned into a human water-balloon. Given the struggle, she writes, "But when you spend a decade dedicated solely to making it all happen, you can’t just give up. And to be fair, music had been my whole life since the age of four, so I felt I had no option but to crack on."

Similarly, Ford writes about common questions from friends and colleagues on her exit from the theatre rat-race. "When people ask me if I regret putting my childhood dream aside, I know that what they’re really asking is whether I feel guilty about cutting my losses so soon. After all, maybe my big break was waiting right around the corner."

From my own experience in post-secondary music academia, it's true that there is not only pressure to succeed, but pressure to *want* to succeed. In the case of Allison Ford, her decision (*her* decision!) to leave a difficult and unforgiving industry was questioned; I agree with Ford's perceived subtext of said questions, that her colleagues were saying that she basically hadn't been patient or hardworking enough to make her career work. It's said in opera circles that if you can see yourself doing *anything else*, you should do that instead. Desire equals drive, right? Those that bow out when the going gets tough can be labelled as not tough, a victim of one of the many filtering points along the road from student to professional. It's a taboo, similar to the way teaching is associated with copping out, or not having what it takes to be a performer ("those who can't do, teach," etc.). It's not a universal way of thought, but it's there, and ironically in higher densities among students in a performance stream of post-secondary education.

In the case of McAdams, she really wanted to be an opera singer. It was her body that disagreed. I think that today, singers are more than ever able to be honest about issues of vocal health; it's something that's generally taken seriously by music administrators. But if a singer's voice is tired, or a pianist starts feeling pain in her arms, they have to stop doing the thing that they love to do. If it's not love, it's pressure; as a young pianist, I always had some new aria, or song cycle, or cello sonata to learn, and I couldn't do that by *not* playing. The conflict causes young musicians to stay quiet about how bad the problem is. In some cases, injury or fatigue can mean weakness; I don't know many who really feel this way, but artists tend to be terribly hard on themselves. "In my own eyes," writes McAdams, "I’ll always be the one that failed; didn’t make it; fell by the wayside."

I think that's the crux of the taboo. Just like the athlete that suffers a career-ending injury, we know it's a devastating thing for a singer who wants to sing, but can't. It may be similar among athletes, but I think there's an added layer of *personal* when we talk about singers and their voices. It's related to the walking on eggshells that comes with communicating criticism to a singer; the line between one's voice and oneself can be blurry, and so addressing problems with the voice can feel like problems with the self. It's harsh, and not made better by discussing it in hushed tones.

McAdams has a fantastic attitude about it now, after what I'm sure was a lot of turmoil and soul-searching. She writes, "I so often hear of successful singers having to take time out on the quiet. In fact, on my own journey, I sought hushed advice from a few very inspiring individuals who had faced their own troubles, but it’s not out there to discuss freely. The subject is always taboo – vocal health in particular – and I’d love that to change; starting right at the bottom, in colleges, to the top, at the big opera houses, where they can be accepting of the fact that we are only human and, if you excuse the expression, ’shit happens’."

Allison Ford's story rings true with myself in particular; she found a way to bring her skills and knowledge elsewhere. "Without my background in entertainment, I might not have been able to get my first regular writing gig — as a theater and film critic. It was only by pursuing one dream — and then giving it up — that I was able to find a new, better one."

I that's a fantastic way to look at it, one that suggests that the arts are a moving target. Best of all, it doesn't place performing at the top of the arts career food chain, and it takes away the association with personal failure. If our egos aren't at risk, I suppose nothing can really be taboo.
