+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-04-10T21:06:00-04:00"
lastmod = "2015-04-12T18:48:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428714180897/EvelynNesbit.jpg.jpg"
publishDate = "2015-03-30T09:05:00-04:00"
related_articles = ["articles/why-we-all-love-florence-foster-jenkins.md","articles/5-people-who-would-make-great-opera-roles.md","articles/schoenbergbach-other-unlikely-pairs-atg-theatre-heads-to-tiff.md","articles/sawney-bean-his-cannibal-clan-would-make-a-great-opera.md","articles/dont-miss-bandits-in-the-valley.md"]
short_description = " I think the story, the mythology, even, of the Gibson Girl would make a great opera in itself. The story could speak about women, men, the media, the human urge to follow trends; there&#039;s even a story in the lives of Mr. and Mrs. Gibson, whose understanding of social issues seemed ahead of their time."
slug = "gibson-girls-and-the-great-opera-theyd-make"
title = "Gibson Girls, and the Great Opera They&#039;d Make"
+++

I came across this BBC [article](http://www.bbc.com/culture/story/20141222-the-worlds-first-supermodel) about Evelyn Nesbit, who was one of the first supermodels at the turn of the 20th century. She was just 14 years old when she began her modelling career, posing artists on the streets of Philadelphia, who favoured her as their muse for paintings and sketches. After she moved with her mother to New York City in 1900, Evelyn quickly became one of America's most sought-after models. She was on the covers of _Vanity Fair_, _Ladies' Home Journal_,_ Harper's Bazaar_, and _Cosmopolitan, _and posed for ads for Coca-Cola; she was even a chorus girl on Broadway. 

As you'd expect from a teenaged fashion model, Evelyn had no shortage of interested, rich men. One of them was Stanford White, an architect 30 years her senior, who made a lasting impression with things like red velvet swings and "mirror rooms." Evelyn was 15 years old, Stanford was 47\. Another of her suitors was millionaire Harry Kendall Thaw, who somehow convinced Evelyn to marry him in 1905, after spending years beating her and chastising her for not being a virgin. In June of 1906, on the roof of Madison Square Garden, Thaw shot White three times, killing him. Evelyn was tied up in what became known as "The Trial of the Century," in which the media was treated to gruesome details about White's murder, and the complicated web of jealous husbands and ex-lovers. 

This story of a love-triangle-gone-murder has all the stuff of good drama, no doubt; in fact, the story was turned into a film by Richard Fleischer in 1955, called _The Girl in the Red Velvet Swing_. I couldn't help but think to myself, jeez, Evelyn's story ould make a _great_ opera. The way-too-young pin-up girl who grows up fast in New York City; the wealthy and manipulative men around her; the murder that happens atop Madison Square Garden, right after a show. Plus, there would be more than enough excuses to squeeze a little ragtime into the score. The operatic version of this story could resemble a mash-up of _Manon_ and _Lulu_, but set in New York. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428714246856/GibsonGirlsBeach.jpg.jpg)
<figcaption>Gibson Girls on the Beach. By Charles Dana Gibson</figcaption>
</figure>

Even more fascinating was the trail of clicks that led beyond my interest in Evelyn Nesbit. Evelyn's résumé included her status as a Gibson Girl, the illustrated feminine ideal, from the mind of artist [Charles Dana Gibson](http://en.wikipedia.org/wiki/Charles_Dana_Gibson) in the 1890s. Evelyn was one of several models of the Gibson Girl image, which included a towering, bouffant hairstyle, a "sporty jaw," and a wasp waist. The Gibson Girl was considered one of the first big fashion crazes in the United States, representing "thousands of American women."  

Looking at Gibson's illustrations, it struck me that he was one of those artists who really did know that women held immense power over men. His work shows Gibson Girl-type women in everyday places, like dinner parties and beaches, almost apathetic over their clear control. This is one of my favourites; it's called _They Are Only Collecting the Usual Fans and Gloves:_ 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428714322515/GibsonIllustration.gif)
<figcaption>Illustration: Charles Dana Gibson</figcaption>
</figure>

When we think of fashion trends (and the people who create them), there's a pretty strong association with creating low self-esteem in women. The concept of an "ideal" beauty wouldn't go over well on the Internet. But I think it's fascinating that Gibson, the man responsible for one of the very first fashion trends, was so entirely aware of why women should never have low self-esteem; to him, women were fantastically powerful. Gibson's wife, Irene Langhorne Gibson, was a Gibson Girl herself, but she's known more for her political work. She helped found Big Sisters Inc., and demonstrated for the women's suffrage movement. So, the Gibsons were generally pretty great. 

Anyway. I think the story, the mythology, even, of the Gibson Girl would make a great opera in itself. The story could speak about women, men, the media, the human urge to follow trends; there's even a story in the lives of Mr. and Mrs. Gibson, whose understanding of social issues seemed ahead of their time. What would the opera sound like? I imagine you could have a neat mix of diegetic and non-diegetic music, as we follow the Gibson Girls in and out of parties and along the streets of New York. I keep thinking of composers like Debussy and Honegger, to go with the misty, almost supernatural feminine archetypes. 

There you have it, opera composers; I've done all the hard work, right?
