+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = 2023-05-17T03:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1684463806/sqGianni_SchicchiBaranova-9313.jpg"
primary_image_credit = "Joseph Parrish as Gianni Schicchi in Juilliard Opera's double-bill of Suor Angelica and Gianni Schicchi, 2023. Photo: Maria Baranova."
related_articles = ["articles/in-review-tosca-at-the-coc.md", "articles/wno-tosca.md", "articles/tosca-at-heartbeat-opera-art-to-the-point-of-distraction.md"]
related_companies = ["scene/companies/the-juilliard-school.md"]
related_people = []
short_description = "Puccini considered Suor Angelica his favorite work; it was also his most personal, inspired by his sister who was an actual nun. The music is all pleasingly lyrical but it's all a slow set-up for the eventual entrance of La Zia Principessa (as mentioned, portrayed here by the highly talented Ms. Lewis.)"
slug = "gianni-schicchi-suor-angelica-professional-puccini-at-juilliard"
title = "Gianni Schicchi & Suor Angelica: professional Puccini at Juilliard"
youtube_url = ""

+++
Puccini didn't want the three one-acts of his _Il trittico_ split up, but you rarely get to see all three (_Il tabarro_, _Suor Angelica_ and _Gianni Schicchi_) in one evening. (SAS performed them all, [reviewed here](https://www.schmopera.com/il-trittico-slices-of-puccini/).) More often, we get to see the individual one-acts as stand-alone presentations (i.e. _Il tabarro_, [reviewed here](https://www.schmopera.com/il-trittico-slices-of-puccini/)) or in the popular pairing of _Suor Angelica_ and _Gianni Schicchi_. The two work very well together as an evening – _Suor Angelica_ is a dramatic curtain raiser followed by an intermission that gives the audience time to recover before facing all-out hilarity in _Gianni Schicchi_; you get your fix of both tragedy and comedy. Presented by The Juilliard School, both were a qualified success.

The casts of both operas are made up of students who are in the undergraduate, master's and diploma programs. However, there aren't varying degrees of proficiency – almost without exception you are treated to performances that you'd expect to see on a professional level. Director John Giampietro is at the helm of both productions. He fills the first half of the evening with metaphors, and his choices in the second half of the evening are somewhat unusual. The title character of _Gianni Schicchi_ is not portrayed as a rural clown who fools everyone; from the very beginning, baritone Joseph Parrish is the epitome of 'cool' and in complete control like the slickest of con men. Mr. Parrish, who made a great impression in Juilliard's production of _Proving Up_, is not a comedian here, so the humor in this production comes from the situation and not from the comic chops of Gianni Schicchi himself. Mr. Parrish, however, gets an "A" for his vocals and commanding presence.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684463806/Suor_Angelica_Baranova-8131.jpg){{% /md %}}

<figcaption>A scene from Juilliard Opera's Suor Angelica, 2023. Photo: Maria Baranova.</figcaption>
</figure>

_Gianni Schicchi_ is the story of the self-centered members of the Donati family. Buoso Donati has died, and all his relatives have gathered for some fake mourning and, they hope, some real monetary gain. They're all angling to get a piece of Donati's greatest assets – "the mule, the house and the mills" – but they don't know what's in Donati's will. They've heard that he's leaving all his money to a monastery and so they frantically search for the will to find out if the rumor is true.

When they find the scroll which confirms the bad news, they turn to Gianni Schicchi for help. At first they're reluctant – Gianni was originally a 'rube' from the country, and not a fellow sophisticated city dweller from Florence. One of the youngest members of the family, Rinuccio, tells them that they're all wrong about Gianni in the aria "Avete torto." (Ecuadorian tenor Cesar Andres Parreno delivers an almost perfect recitation.) Gianni is described by others rather vaguely as a "villain", but since the Donati family is looking for some criminal mischief, they decide to take a chance on him.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684463807/Suor_Angelica_Baranova-8847-2.jpg){{% /md %}}

<figcaption>A scene from Juilliard Opera's Suor Angelica, 2023. Photo: Maria Baranova.</figcaption>
</figure>

Every member of the Donati family deserves mention here. Mezzo Natalie Lewis gives two knockout performances, first as La Zia Principessa in _Suor Angelica_ and then as the matriarch of the Donatis. Likewise, soprano Erin O'Rourke does excellent double duty first as the Prima Sorella Cercatrici in _Suor Angelica_ then as Nella in the second half of the program. Ms. Lewis, Ms. O'Rourke and soprano Georgiana Adams (as La Ciesca) blend beautifully and seductively in their trio as they put Gianni Schicchi to bed.

Bass Younggwang Park has a powerful presence as Simone, the patriarch of the family, and baritone Shavon Lloyd (Betto di signa), tenor Colin Aikins (Gherardo), and baritone Minki Hong (Marco) all have wonderful moments rounding out the rest of the Donati men.

Also making impressive cameo appearances are Jason Hwang as the doctor Spinelloccio, Lewei Wang as the notary Amantio Di Nicolao, baritone Joe Gervase (Pinellino) and bass-baritone Nazrin Alymann (Guccio.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684463807/Suor_Angelica_Baranova-9014.jpg){{% /md %}}

<figcaption>A scene from Juilliard Opera's Suor Angelica, 2023. Photo: Maria Baranova.</figcaption>
</figure>

One of the most oft-performed arias of all time, "Oh, mio babbino caro," is always a challenge for the soprano playing Lauretta who has a century of shoes to fill. But endearing soprano Sydney Dardis most certainly delivers. It's supposed to be the one serious moment in the opera buffa, but Mr. Giampietro has also turned the "Addio Fierenze," which is usually a laugh-out-loud meditation on fear, into a pensive moment of mortal terror. Other comedic misfires include the corpse of Buoso Donati, represented here by a mummified skeleton. The family of mourners must have been sitting at his bedside for a long, long, time completely oblivious to his rotting corpse. It's momentarily funny but  then the absurdity wears out its welcome.
 ___________________________________________________________________

There isn't much action in the libretto of _Suor Angelica_, and so director Giampietro fills as many moments as he can with his unscripted imagination. As with his inexplicable flying piano in his production of _The Turn of the Screw_ ([reviewed here](https://www.schmopera.com/julliards-turn/)), Mr. Giampietro is all over the place with visuals. For the first half of _Suor Angelica_, the nuns of the convent tell us about their life of denial and some reveal their hidden desires. For one, it's food; for another, a former shepherdess, it's to once again pet a baby lamb. The title character (soprano Deborah Love) tells the other sisters that she has no such desire but they accuse her of lying. To highlight – or rather underline this all with a thick blue marker – Mr. Gaimpietro represents these "desires" by having the nuns continually pull blue scarves out of their sleeves and out from hidden compartments in the floor and in the walls. They twist and turn the scarves, wrap, and unwrap their arms with them, stretch them and caress them. And the metaphor consumes the entire stage at the end when Suor Angelica prays to the Virgin Mary to grant her greatest wish and she completely wraps herself in a large swath of blue fabric (same color as the scarves.) There is also a large lighted globe that Suor Angelica hides in the floor before the overture and then it's retrieved at the end. The symbolism here means a great deal to Mr. Giampietro, but escapes this reviewer.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684463806/Gianni_SchicchiBaranova-9675.jpg){{% /md %}}

<figcaption>A scene from Juilliard Opera's Gianni Schicchi, 2023. Photo: Maria Baranova.</figcaption>
</figure>

Puccini considered _Suor Angelica_ his favorite work; it was also his most personal, inspired by his sister who was an actual nun. The music is all pleasingly lyrical but it's all a slow set-up for the eventual entrance of La Zia Principessa (as mentioned, portrayed here by the highly talented Ms. Lewis.) La Zia Principessa is Suor Angelica's aunt and breaks the languid pace of the story by revealing some dramatic secrets. One is a secret only to the other nuns: Suor Angelica had given birth to an illegitimate child who was immediately taken away from her. The other secret is a shock to the mother: the child has recently died.  Ms. Lewis gives us a fully three-dimensional villainess - more concerned about the family reputation than her niece's heartbreak, but revealing a glimmer of the sadness and sympathy she is trying to hide. 

Both individually and as a group, the sisters of the convent sing sublimely. Soprano Jazmine Saunders (as La Suora Infermiera) is dynamic for her brief moment as she relays some bad news. Mezzo Stephanie Bell as La Badessa and Sophia Baete (La Suora Zelatrice) both command the stage and our attention as convent leaders and Song Hee Lee (Suor Genovieffa) is absolutely charming as the giddy nun who seems to be excited about everything, especially the way the light shines on the convent fountain.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684463806/Gianni_SchicchiBaranova-9872.jpg){{% /md %}}

<figcaption>A scene from Juilliard Opera's Gianni Schicchi, 2023. Photo: Maria Baranova.</figcaption>
</figure>

Ms. Love, in the title role, is often too dampened in her vocals. While this works well for the piercing high notes, which she ascends to with ease, her lower and middle register are often drowned out by the orchestra (and this through no fault of the superb student orchestra led by Daniela Candillari.) Acting-wise, Ms. Love is giving it her all as was evidenced by the tears streaming down her face through much of the performance.

The production elements at Julliard are always superlative and equal to anything you'd see outside of academia.. Kudos to costume designer Audrey Nauman, lighting designer  Kate Ashton, and scenic designer Alexis Distler. Distler's set serves both operas well. The bare, gray brick walls and exposed wooden frames and rafters work both as an ascetic nunnery and as the bleak interior of a villa from the Middle Ages. One of the walls is cracked and there is something smoking and glowing on the other side. Another allusion to the burning inner lives of the sisters, perhaps, and although it's an arresting image, it does steal a lot of focus particularly while emitting a "hissing" sound which never allows a moment of complete silence on stage. The wall is "repaired" during the intermission and poses no interference with the farce that follows.
