+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-10-24T11:57:00-04:00"
lastmod = "2017-10-24T22:28:00-04:00"
preamble = "Following recent seasons of \"hard-hitting monologues\" like *Erwartung*, *Twice Through the Heart*, and *The Diary of One Who Disappeared*, [Shadwell Opera](/scene/companies/shadwell-opera/) is taking on the challenges of Peter Maxwell Davies' [*The Lighthouse*](https://www.hackneyshowroom.com/the-lighthouse/). Based on the true-story disappearance of three lighthouse keepers from the Outer Hebrides, Artistic Director Jack Furness teams up with Music Director Finnegan Downie Dear and designer Alex Berry for a \"multi-sensory experience that plays with the idea of theatrical immersion and suspension of disbelief\".\n\nPerformances of [*The Lighthouse*](https://www.hackneyshowroom.com/the-lighthouse/) run **November 3-12** at Hackney Showroom; we spoke with Furness about telling true stories, and directing shows that stay with an audience long after they end."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508860180332/2017-10-24---Jack-Furness.jpg.jpg"
publishDate = "2017-10-24T22:07:00-04:00"
related_articles = ["articles/in-review-erwartungtwice-through-the-heart.md","articles/killer-women-shadwell-operas-doublebill.md","articles/murky-works-shadwell-opera-presents-the-lighthouse.md"]
related_companies = ["scene/companies/shadwell-opera.md"]
short_description = "&quot;I think people are more suggestible than we like to admit. The operation of the so-called &quot;suspension of disbelief&quot; in the theatre is a great example of this. When I go to see a show, I spend the first period struggling to understand, to analyse, to engage, and then, at some point that I don&#039;t even recognise (if it&#039;s good) or notice, a switch goes in my brain and there I am, living entirely in the world of the play. How does that happen? Where else does that happen?&quot;"
slug = "ghost-stories-true-stories-the-lighthouse"
title = "Ghost stories &amp; true stories: The Lighthouse"
+++

## What makes *The Lighthouse* the most challenging work yet for Shadwell Opera?
 
*The Lighthouse* presents numerous musical and dramatic interpretative challenges. First of all, the plot is multi-layered, non-linear, deliberately ambiguous, but at the same time extremely psychologically precise. Understanding how to reconcile those two impulses is the kind of challenge you don't often get to tackle. The piece is a ghost story, but it also isn't. It's about three lighthouse keepers, and it also isn't. Everything that happens in the story also possibly doesn't happen. That kind of calculated ambiguity is a productive problem to solve but also a thorny one!

The interface between music and drama in this piece is also very particular. Maxwell Davies wrote all of these "extended techniques", pushing the singers to ever greater extremes of possibility in terms of what the human voice can do. [Conductor] Finnegan Downie Dear and I have been operating on the assumption that these moments can't just be unintegrated "effects". It would be easy to say "that's mad" and leave it at that. But we've been searching for concrete psychological or dramatic reasons why the music must be as it is. It adds a whole new layer of interpretation into the mix.
 
We've been on a journey with the company exploring repertoire that, in one way or another, pushes towards extremes. For a time we were trying to hone our craft by focussing on pieces with only one or two characters. With *The Lighthouse* we're up to three, which, though small, is a stepping stone for us onto bigger things.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508896237034/2017-10-24---In-the-Penal-Colony-Shadwell-Opera-pc-Nick-Rutter.jpg.jpg)
<figcaption>*In the Penal Colony*, Shadwell Opera. Photo: Nick Rutter.</figcaption>
</figure>
 
## Are there any unique dramatic challenges with staging an opera inspired by a true story?

This is a great question and goes to the heart of what I think the piece is about. Why do we give something credibility? Whether that's a ghost story, a piece of theatre, an explanation for something unexplainable, the theology of a religion - what, exactly, makes us accept some things as credible and reject others? 

What I'm getting at is, I think people are more suggestible than we like to admit. The operation of the so-called "suspension of disbelief" in the theatre is a great example of this. When I go to see a show, I spend the first period struggling to understand, to analyse, to engage, and then, at some point that I don't even recognise (if it's good) or notice, a switch goes in my brain and there I am, living entirely in the world of the play. How does that happen? Where else does that happen? For me the whole "true story" thing is a way into these questions as it foregrounds "credibility" as they key to suspending your disbelief. The example I keep talking about to the cast is *Paranormal Activity* or other "found footage" films, where the presence of the camera within the story means that you're not able to dissociate yourself from the horror unfolding by telling yourself it's not real. The artificiality of film is removed and suddenly, you're there, watching something that really happened. That's a great dramatic conceit but one you have to handle carefully.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508896245520/2017-10-24---Emily-Long-in-Into-the-Little-Hill-Shadwell-Opera-photo-Nick-Rutter.jpg.jpg)
<figcaption>Emily Long in *Into the Little Hill*, Shadwell Opera. Photo: Nick Rutter.</figcaption>
</figure>

## What are some of the pieces still on your director's bucket list?
 
Ha! I'd like to direct films, theatre, and opera. Too many too mention! I've recently had the opportunity to write some things for performance. I want to do more of that - making something entirely new is really exciting for me and has felt liberating. In terms of opera though, I'd like to tackle all the great pieces of the 20th century. *Wozzeck*, *Lulu*. *Peter Grimes*. *Death in Venice*. The Janáček operas. *Rusalka*. At the same time, I also want to try more of the experimental Italian modernist stuff. I love Berio's music - but there's a whole range of 1960s music theatre that needs to be seen more. 

In terms of ambition, the opera that I'd do tomorrow if I could do anything would be *Die Meistersinger von Nürnberg*. I listen to it a lot. It's total theatre. The characters are so so real and flawed and human. The relationships are unbelievably rich. Going into those characters' lives would be an unimaginably great pleasure for me. I'd love to share how much I love that piece with audiences. And one day, *Parsifal*. In the meantime I have slightly smaller projects to focus on! I'd like to try to make sense of some Handel. And next year I get to tick off a big one - I'm directing and designing *Don Giovanni* at the Teatru Manoel in Malta with a lovely international cast. I've been dreaming about this production for years and now I finally get to actually bring it to life!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508896334022/2017-10-24---Sammy-Furness-and-Angharad-Lyddon-in-Diary-of-the-One-who-Disappeared-Shadwell-Opera-Grimeborn--credit-Robert-Workman.jpg.jpg)
<figcaption>Sammy Furness and Angharad Lyddon in *The Diary of One Who Disappeared*, Shadwell Opera/Grimeborn. Photo: Robert Workman.</figcaption>
</figure>

## What do you hope listeners will take away from this production of *The Lighthouse*?
 
This is always such a hard question to answer without biasing people's experience of the show. If I could sum up what the whole thing means in words alone then it wouldn't be worth making the production! But really, I think the piece is one of those ones where you'll come out feeling one thing and then maybe, over time it'll change in your head. One of my favourite writers, Jack Green, calls this "timegrowth". I think Hitchcock called it the "icebox" scene - where you only realise some sort of profound inconsistency when you're back at home, looking in the fridge. When the show is in progress a lot of stuff doesn't occur to you. If this all sounds cryptic then people will have to come to see the show!

>The Lighthouse runs at Hackney Showroom November 3-12. For details and ticket information, follow our box office links below.
