+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2017-08-14T21:43:00-04:00"
lastmod = "2017-08-15T22:12:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502849008987/2017-08-15---Bubble.jpg.jpg"
publishDate = "2017-08-15T22:08:00-04:00"
related_articles = ["articles/things-more-important-than-opera.md","articles/art-is-not-action.md","articles/when-art-is-not-enough-opera-activism.md"]
related_companies = ["scene/companies/bayerische-staatsoper.md"]
short_description = "The appalled opera goers make claims about wasted money and travel time, and they take a strange stance of half-defending, half-blaming the performers onstage. But the main objections seem to be the apparent &quot;desecration&quot; of Wagner&#039;s work. &quot;Yes, I naively assumed that Wagner’s family had obeyed his very exacting wishes, and that Bayreuth was the place to see his operas as he intended them,&quot; writes Peacock."
slug = "getting-vexed-over-wagner-other-narcissisms"
title = "Getting vexed over Wagner &amp; other narcissisms"
+++

Over at Norman Lebrecht's *Slipped Disc*, you can [read the angry letters](http://slippedisc.com/2017/08/a-composer-and-a-violinist-are-appalled-by-bayreuths-ring/) written by conductor Rodrigo Ruiz and violinist Kerenza Peacock, who were dissatisfied with their time at the Bayreuth Festival this summer. Basically, they hated [Frank Castorf's *Ring Cycle*](https://www.theguardian.com/music/musicblog/2013/aug/02/frank-castorf-bayreuth-ring-cycle) - a production that earned similar [outrage and boos](https://www.youtube.com/watch?v=wQTUOeXmhMI) when it came to the Festival in 2013.

"I feel completely heartbroken, sad, angry, outraged, and abused," writes Ruiz. "In an opera, the plot, the text, and the music are all part of a single whole. Those are things that are set, and that can’t be changed. Period...In the current state of things, it almost seems like the music establishment wants us to feel grateful they’ve left us the music."

"I came here in search of beauty," whines Peacock. "It breaks my heart that I could not applaud the performers at the end of tonight's opera...By agreeing to take part, these performers are accomplices in this damaging production."

<figure data-type="video">
<iframe src="https://giphy.com/embed/1bYaHhGtueIqQ" width="480" height="204" frameBorder="0" class="giphy-embed" allowFullScreen></iframe><p><a href="https://giphy.com/gifs/gross-jack-sparrow-disgusted-1bYaHhGtueIqQ"></a></p>
</figure>

The appalled opera goers make claims about wasted money and travel time, and they take a strange stance of half-defending, half-blaming the performers onstage. But the main objections seem to be the apparent "desecration" of Wagner's work. "Yes, I naively assumed that Wagner’s family had obeyed his very exacting wishes, and that Bayreuth was the place to see his operas as he intended them," writes Peacock in the comments section following her letter.

Speaking of the comments, [this thread](http://slippedisc.com/2017/08/a-composer-and-a-violinist-are-appalled-by-bayreuths-ring/#comments) is a bit of a minefield:

"Directors like Castorf and Kosky with their puerile political agendas and outright trashing of Wagner's vision are a blight on the Master's legacy," writes one commenter. "Audiences and musicians need to take a stand and refuse to associate themselves with such travesties."

Another chimes in, "If it isn't in the stage directions, it shouldn't be in the opera."

Just...sigh. Look. I've bitched in the past about [productions that I've found stupid](/in-review-tcherniakovs-don-giovanni/). I don't think "artistic opinion" is a free-for-all, and I do think there should be technique and structure to a director's interpreting an opera. [I've also said](/things-more-important-than-opera/) that when a society has time to kvetch about productions of Wagner operas, that society is in reasonably good health (as opposed to places where the people cannot afford the luxury of being outraged over opera).

If art is meant to provoke, it certainly succeeded with Ruiz and Peacock. And though emotional responses are good and healthy, there's something about these strongly-held opinions that feels incredibly small-minded. You might say it's a really disigenuous thing to say, as a person who runs an opera-centric blog, but it's just a *show*, after all; is it really worth getting so riled up? 

What I really mean is this: in August, 2017, is an "ugly" production of a Wagner opera *really* worth so much of your heart? In recent months, and even more in recent weeks, the world's events have asked us to look up from our individual lives and join the collective. Aren't fears of two owners of micropenises nuking the world to smithereens meant to overshadow the horrors of *Regietheater*? When Nazis drive their cars into crowds of people, does it not lessen the emotional effect of seeing some bad opera in Bayreuth? Is there any irony in holding staunch opinions, inflexible to the new, when there's frightening evidence of what happens when the stupid comes up against the close-minded?

It's maddening, because I do think that opera is powerful. Sure, it's a niche art form that doesn't enjoy mainstream popularity, but opera extends generously into larger society by challenging its artists to do extraordinary things with their bodies and voices, and giving its listeners emotional experiences that come out of a combination of the physical and the spiritual. I care about opera a lot, and I think there's room for us to spend time on it. 

But opera goers screaming "abuse" and making passive-aggressive comments about how they simply "could not applaud" for a *goddamn show* are currently testing my patience.
