+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-03-07T17:26:45+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1551979382/media/2019/03/sqGeorgeBenjaminJavierdelRealTeatroReal.jpg"
primary_image_credit = "George Benjamin. Photo: Javier del Real."
related_articles = []
related_companies = []
related_people = []
short_description = "This was an example of intelligent, thoughtful programming, a wonderful way to showcase Ensemble Modern, and an opportunity to feature the work George Benjamin, a true household name by now."
slug = "a-new-household-name-george-benjamin"
title = "A new household name: George Benjamin"
youtube_url = ""

+++
It is not unusual for George Benjamin to draw a crowd particularly after the critical acclaim widespread success of his two most recent operas [_Written on Skin_](/in-review-written-on-skin-at-roh/) (2012) and _Lessons in Love and Violence_ (2018). But Wigmore Hall was abuzz with energy and excitement at this first of two back-to-back concerts featuring Benjamin as he heads up the Frankfurt-based Ensemble Modern, one of the world's foremost contemporary music ensembles. Each concert features a major work by Benjamin alongside a carefully curated programme of accompanying selections. This evening we were treated to a UK premiere by Cathy Millikin, ensemble pieces by Christian Mason and Luigi Dallapiccola, and forming the second half of the programme, George Benjamin's first opera _Into the Little Hill_.

>The text has a precision and clarity akin to Benjamin's writing. The two complimented each other beautifully.

_Into the Little Hill_, commissioned by the Festival d'Automne à Paris and premiered in 2006, is the first in a series of collaborations between Benjamin and playwright Martin Crimp, a union which later produced _Written on Skin_ and _Lessons in Love and Violence_. A one-act clocking in at about 63 minutes, _Into the Little Hill_ it is a succinct re-imagining of the beloved tale of the pied piper of Hamelin. The story has its origin in the 13th century where it became legend in Lower Saxony, Germany. Whether there ever was a piper, is unknown but the tale has prevailed through the ages, becoming popularized in the 19th century by the Brothers Grimm in their publications of fairy-tales for children.

This retelling, however, has very little of the playful, childlike character the story is known for and instead focuses on the betrayal of the Minister, who refused to pay the piper, and the devastation at the loss of the children. Like the two Benjamin/Crimp collaborations that follow, the story blends the archaic with the modern. It is never quite clear whether we are in the 13th century or the 21st. The text is purposefully vague to present a world that exists outside of time. This allows for general political comments to be made that apply across time and that are therefore, very affecting. Crimp's text is masterful; so subtle and streamlined and yet incredibly impactful. The text has a precision and clarity akin to Benjamin's writing. The two complimented each other beautifully.

>Komsi, for whom this role was written, had a clear and astonishingly versatile voice.

Though I would be very interested in seeing a staged production of this opera, I didn't miss any of the trappings. In fact, I found that because of the way the piece is constructed; giving each singer multiple roles to portray, it lent itself very well to a concert performance. The music is strong enough and evocative enough to stand on its own while graciously providing support for the singers. The music was compact and in servitude to the story, working in perfect tandem with the text. Benjamin employed some unexpected timbres in the orchestra making use of the mandolin and banjo to provide a folk-like quality to the sound as well as the magnificent and rare sound as well as the magnificent and rare sound of the bass-flute as the representation of the piper's magical music.

The singing was extremely accomplished from both soprano Amu Komsi and contralto Helena Rasker. Komsi, for whom this role was written, had a clear and astonishingly versatile voice. Pushed to the very limits of her range, she gave a performance that was full of charisma and surprise. I did feel however, that she may have pushed the envelope a little too far and could have kept the performance a little more contained; could have sung more as opposed to demonstrating. There was a marked difference in the way Rasker handled the performance though both performers brought their own unique qualities to the stage. In the role of the Minister Rasker was grounded and stoic with a sound that was powerful yet controlled.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1551979917/media/2019/03/GeorgeBenjaminKaiBienert.jpg){{% /md %}}

<figcaption>George Benjamin. Photo: Kai Bienert.</figcaption>

</figure>

The three pieces that formed the first half of the programme complimented the opera perfectly. First up was the UK premiere of Australian composer Cathy Milliken's ensemble piece _Bright Ring_. Inspired by her previous work with Ensemble Modern and the vitality that comes from collaboration, the energy of this piece was palpable. It was a collection of improvisational moments of growth followed by dissipation. Overwhelming moments of activity with highly percussive strings were broken by a thinning of the texture and a general feeling of release in repeated patterns over and over again. But always present was the evocative storytelling and grandeur of the piece.

>It is rare that new music concerts of this scale are so well attended.

English composer Christian Mason's _Layers of Love_ (2015) was an exploration of the feeling of longing for the unknown. It had a searching quality as it hovered in and around the tonic, each instrument stood alone in a cacophonous sea of sound like the many "voices" in one's head, all vying for attention. The sense of rhythmic pulse that came in by the second half of the piece felt like a welcoming familiarity after the tenuous chaos. In a short amount of time Mason created a journey from beginning to end while maximizing the limits of instrumental potential.

Finally, we heard Dallapiccola's _Piccola musica notturna_. A master of mid-century serialism, Dallapiccola's music can somehow feel slightly off-kilter and yet so surreally beautiful all at once. His 12-tone writing was uniquely lyrical and in the case of this piece, featured a warm, rounded instrumentation of harp, strings, celeste, and woodwinds. It was evocative, atmospheric, and often like most good things, over too soon.

This was an example of intelligent, thoughtful programming, a wonderful way to showcase Ensemble Modern, and an opportunity to feature the work George Benjamin, a true household name by now. It is rare that new music concerts of this scale are so well attended, and it was a joy to see so many people appreciating and learning from this exciting repertoire. It was certainly well received and very rightly so.