+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-03-16T17:11:00-04:00"
lastmod = "2018-03-22T21:33:00-04:00"
preamble = "[FAWN Chamber Creative](/scene/companies/fawn-chamber-creative/) continues their cross-genre Convergence Series with [*Belladonna*](https://www.fawnchambercreative.com/events/upcoming/), a new techno-opera presented on **March 22** at Kensington Hall. The Series was initiated by FAWN Artistic Director Amanda Smith as a way for the FAWN team to work with artists outside operatic circles; for *Belladonna*, librettist Gareth Mattey - a specialist in writing queer narratives for opera - collaborates with director/designer Amanda Smith, modular synth artist Acote, composer/double-bassist Adam Scime, Jonathan MacArthur (tenor), Darren Creech (pianist), contemporary dancer Mary-Dora Bloch-Hansen, and guest mezzo-soprano Camille Rogers.\n\nWe spoke with Mattey about [*Belladonna*](https://www.fawnchambercreative.com/events/upcoming/), its influences in Classicism and botany, what it means to write a queer techno opera."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521234674207/GarethMattey.jpg.jpg"
primary_image_credit = "Gareth Mattey, librettist for FAWN Chamber Creative's Belladonna. Photo: Johannes Hjorth."
publishDate = "2018-03-16T21:49:00-04:00"
related_articles = ["articles/a-call-for-new-music-fawn-chamber-creative.md","articles/a-fiercely-queer-opera-for-halloween.md","articles/what-a-long-strange-trip-its-been-belladonna.md"]
related_companies = ["scene/companies/fawn-chamber-creative.md"]
short_description = "Opera as an art form has always been very accepting of me and other LGBTQ+ people but rarely depicts us on stage. I feel like my work is attempting to develop an intervention in this; to focus on how opera has always delighted in plays of gender and sexuality and, in developing narratives around queer individuals (whether entirely original or adaptations) to bring back an understanding of opera as a strange, queer art form."
slug = "gareth-matteys-belladonna-is-unashamedly-queer"
title = "Gareth Mattey&#039;s Belladonna is &quot;unashamedly queer&quot;"
+++

## What is a queer narrative, and how do you adapt "unashamedly queer" stories to a musical or operatic setting?

Queer is such a fascinating and interesting word for me because of how much potential it contains. Queer is not only an important word with regards to sexuality and gender (being broadly re-appropriated from an insult) but also has its roots in meaning odd, strange and even to disrupt or ruin. 

So a queer narrative is something that takes queer characters as its focus but also something that seeks to queer the nature and approach of that narrative in the first place. For me, this is about how we create musical and dramatic works that subvert and play with ideas of form, structure, shape and intention while dealing directly with issues and stories that involve and concern LGBTQ+ individuals.

To return to queer as odd, I think there's something we all need to accept about operatic works - we do not live in a world where everything is sung and musical, so opera is unavoidably a bit strange and a bit queer by nature! 

This is something that excites me a lot. Opera as an art form has always been very accepting of me and other LGBTQ+ people but rarely depicts us on stage. I feel like my work is attempting to develop an intervention in this; to focus on how opera has always delighted in plays of gender and sexuality and, in developing narratives around queer individuals (whether entirely original or adaptations) to bring back an understanding of opera as a strange, queer art form.

Of course, I'm still exploring with what queerness specifically in relation to music can be and am incredibly excited to have the chance to experiment further with *Belladonna* and FAWN!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521234655834/Belladonna.jpg.jpg)
</figure>

## What sort of symbolism exists in *Belladonna*? 

When talking to Amanda about what key ideas had already been explored and workshopped, there were numerous images that struck me, particularly the name "belladonna". The full Latin name of the deadly nightshade plant is "[atropa belladonna](https://en.wikipedia.org/wiki/Atropa_belladonna)" and exploring the full potential of meaning in this small phrase gave me a lot of exciting material to work with.

In terms of my background as a writer and director, I've always been strongly influenced by the Classical worlds and I've frequently engaged in how Ancient Greece especially has this ancient, ritualistic connection with opera. 

From this fascination, I drew a lot of specific images and names for the piece - the Moirai (or Fates), Clotho, Lachesis and Atropos in particular. These three helped to colour and characterise the three central characters of "Belladonna" but I've really tried to test and twist their relationships beyond this classical source!

The concept of hallucination gave me a lot to explore structurally with the piece - how can a classical structure hold out in the face of hallucination? With "Belladonna", it became tied with the essential queerness of the narrative and space. The hallucinatory power of the plant and its berries really help to shake the foundations of what we're seeing and I've been interested to blur and play with some of the worlds we see performed - what are the indicators I can put in the text to allude to the instability of transitioning between worlds?

Alongside this, there's elements of ancient and modern pastoral poetry, a strong influence from the empty worlds of Beckett and an attempt to be incomplete - to effectively not give the performers everything, but to leave intentional gaps as a provocation for live performance. It's been incredibly exciting hearing and seeing how Amanda and the FAWN team have been committing and responding to this!

## What do you hope listeners will take away from this performance of *Belladonna*?

I'm always a bit worried about this question as I want to try and create pieces that are as open as possible to audience interpretation! Especially when you're dealing with hallucinations as a subject matter, I feel that audience responses will be even harder to judge and predict!

It excites me to hear what audiences may have to say about the performance and to the piece - where do they differ? What provoked that response or this one? Even when first discussing and sharing the material with the company, we reached so many different interpretations of the material and I'm excited to open it further to an audience and hear what they have to say!

If I had to identify one thing, what I most hope they will take away from this performance is a sense of queerness (in some shape or form) and how that has intertwined with new music and drama. I have absolute certainty that the FAWN team have this firmly at the core of the work they're doing with *Belladonna* and I strongly believe that the performance they're creating is going to be exciting, dynamic, unique and (above all) queer!

>*Belladonna* happens March 22, 8:30pm at Kensington Hall in Toronto. For details and tickets, [click here.](https://www.fawnchambercreative.com/events/upcoming/)
