+++
author = ["authors/jenna.md"]
categories = "Review"
date = 2021-10-06T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1633538276/media/2021/10/sqSoundstreams_GARDEN_ipjrfj.jpg"
primary_image_credit = "Image courtesy of Soundstreams."
related_articles = ["articles/squeezebox-at-soundstreams.md", "articles/transfixing-soundstreams-presents-tan-duns-water-passion.md"]
related_companies = ["scene/companies/soundstreams.md"]
related_people = ["scene/people/rebecca-cuddy.md", "scene/people/lindsay-mcintyre.md", "scene/people/cecilia-livingston.md", "scene/people/daniel-cabena.md", "scene/people/mireille-asselin.md"]
short_description = "Garden of Vanished Pleasures is available to stream through October 10, and you should watch before it's gone. I'd say this is one of the more mature, well-produced digital items I've seen, and I'm not really surprised that it comes out of Soundstreams."
slug = "a-subtle-burn-garden-of-vanished-pleasures"
title = "A subtle burn: Garden of Vanished Pleasures"
youtube_url = ""

+++
Before it's gone, make sure you delve into the curious world devised by Tim Albery in his world-premiere production for Soundstreams, [_Garden of Vanished Pleasures_](https://soundstreams.ca/performances/main-stage/garden-of-vanished-pleasures/).

It's hard to pinpoint why _Garden_ draws you in, because it's a sum-of-its-parts sort of work. The story is compelling: real-life filmmaker, artist, and queer-rights activist [Derek Jarman](https://en.wikipedia.org/wiki/Derek_Jarman) lives out his final years as an HIV-positive man, tending to his gardens at Prospect Cottage on England's southwest seaside. The music, songs composed by [Cecilia Livingston](/scene/people/cecilia-livingston/) and Donna McKevitt, set texts taken from Jarman's journals. It's all delivered by an excellent foursome of singers — countertenor [Daniel Cabena](/scene/people/daniel-cabena/) (Derek Jarman), sopranos [Mireille Asselin](/scene/people/mireille-asselin/) and [Lindsay McIntyre](/scene/people/lindsay-mcintyre/), and mezzo-soprano [Rebecca Cuddy](/scene/people/rebecca-cuddy/) — and a chamber trio of Brenna Hardy-Kavanagh on viola, Amahl Arulanandam on cello, and music director Rachael Kerr on piano.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1633538758/media/2021/10/Soundstreams_GardenofVanishedPleasures_FullCast_ClaireHarvie_oszrh5.jpg){{% /md %}}

<figcaption>The cast of Garden of Vanished Pleasures, Soundstreams, 2021. Photo by Claire Harvey.</figcaption>

</figure>

The story is about love and lust and gender and isolation, all packed into the vantage point of a man living a stigmatic life, watching helplessly as his friends die from AIDS. The multi-faceted story is echoed in the musical styles, which are certainly varied, if nebulous. The minimalist, still aesthetic feels like a waiting room; the crowded trio harmonies signal the tension of being at once scared, lonely, horny, sick, and alone with one's troubling thoughts; the cabaret-style moments nod to Jarman's life as a queer activist.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1633538689/media/2021/10/Soundstreams_GardenofVanishedPleasures_DanielCabena_ClaireHarvie_d97bh2.jpg){{% /md %}}

<figcaption>Daniel Cabena in Garden of Vanished Pleasures, Soundstreams, 2021. Photo by Claire Harvey.</figcaption>

</figure>

Cabena is surely a perfect fit to portray Jarman. His countertenor voice is filled with layered meanings, hidden commentary about gender and strangeness and oppressive societal limits. Like a good British drama, _Garden of Vanished Pleasures_ is a subtle burn, with muted colours and Albery's signature stark aesthetic, but it unquestionably draws you in. _Garden_ gives me many Britten vibes, probably because of the English-seaside setting enhanced by gorgeous video projections by Michelle Tracey. But it's also the themes of isolation, of being a gay man in a time and place where people hate gay men.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1633538702/media/2021/10/Soundstreams_GardenofVanishedPleasures_MireilleAsselin_ClaireHarvie_lnhl6u.jpg){{% /md %}}

<figcaption>Mireille Asselin in Garden of Vanished Pleasures, Soundstreams, 2021. Photo by Claire Harvey.</figcaption>

</figure>

[_Garden of Vanished Pleasures_](https://soundstreams.ca/performances/main-stage/garden-of-vanished-pleasures/) is available to stream through October 10, and you should watch before it's gone. I'd say this is one of the more mature, well-produced digital items I've seen, and I'm not really surprised that it comes out of [Soundstreams](/scene/companies/soundstreams/).