+++
author = ["authors/daniel-weisman.md"]
categories = "Review"
date = "2019-10-17T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1571280090/media/2019/10/sqAtlantaOperaFrida5770_t1royx.jpg"
primary_image_credit = "Catalina Cuervo in the title role of Frida, The Atlanta Opera, 2019. Photo: Rafterman Photography."
related_articles = ["articles/a-definitive-hit-west-side-story-in-atlanta.md", "articles/fgo-frida.md"]
related_companies = ["scene/companies/the-atlanta-opera.md"]
related_people = ["scene/people/eliza-bonet.md", "scene/people/bryn-holdsworth.md", "scene/people/andres-acosta.md", "scene/people/catalina-cuervo.md"]
short_description = "Frida and Diego encounter many struggles, the communist revolution turning against Diego, the pair travelling to New York, their struggle to carry a pregnancy to full term, and their return to Mexico, which led to Diego’s many affairs."
slug = "cuervos-sophisticated-lyric-frida-in-atlanta"
title = "Cuervo's \"sophisticated, lyric\" Frida in Atlanta"
youtube_url = ""

+++
A biographical opera focusing on the life of famed Mexican painter, Frida Kahlo, composer Robert Xavier Rodriguez' _Frida_ premiered in 1991 with a book by Hilary Blecher, and with monologues and lyrics by Migdalia Cruz. Long awaited, the musical telling of Frida Kahlo's heroic and tragic story has been featured as far as Guadelajara in 2007 for the 110th anniversary of Frida Kahlo's death.

The work itself follows Frida through her life, starting with her tragic bus accident following the loss of her virginity to her childhood sweetheart, her involvement with the communist party, her recovery allowing her to turn to her love of painting, and her rendezvous with death that seemed to linger throughout her survival following the accident. 

She and her sister, Christina, meet Diego Rivera, a famous painter who mentored Frida and eventually became her husband. Frida and Diego encounter many struggles, the communist revolution turning against Diego, the pair travelling to New York, their struggle to carry a pregnancy to full term, and their return to Mexico, which led to Diego’s many affairs, ultimately destroying their marriage - though they reunited near her death and married a second time.

> Cuervo's soprano endures again as a sophisticated, lyric instrument, fitted with a strong sense of musicality and empathy.

The production presented at The Atlanta Opera has endured numerous outings, notably at Michigan Opera Theatre and Florida Grand Opera. The company takes on the beautiful new Sandy Springs Performing Arts Center, a venue that they recently occupied for a performance featuring Stephanie Blythe and the 2018-2019 class of Atlanta Opera Studio Artists. 

The stage is set with abstract visions of Kahlo's work, a gigantic heart, a withering tree sprouting from the arteries, and a large screen in the background; it effectively helps set the obscurities as the Kahlo-Rivera household, a New York City party, Rivera's studio, and more. The costuming, expertly done by Moníka Essen, with wigs by Sue Sittko Schaefer, perfectly captures the stylistically appropriate and effectively dressed the actors, and helps transform them into numerous different roles while sticking strictly with historically accurate and culturally relevant pieces.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571280106/media/2019/10/AtlantaOperaFrida6680_ancalw.jpg){{% /md %}}

<figcaption>Frida, The Atlanta Opera, 2019. Photo: Rafterman Photography.</figcaption>  
</figure>

As the curtain rises on the first act, we are introduced to dancers Miriam Golomb, Rachel Shiffman, and Cansler McGhee, dressed in Calavera costumes, complete with skulled masks. Their dance, a dance inviting Frida to death, interweaves the piece, granting an effervescent sprinkling of hallucination to the piece.

We are introduced to [Catalina Cuervo](/scene/people/catalina-cuervo/) as the title character. She steps from the canvas in spitting image of Frida's icon-- her fiery attitude and intentional interpretation brought a sharp wit and honesty to the woman. Cuervo is no stranger to Frida, having performed this very production at [Florida Grand Opera](/appropriately-strange-frida-at-fgo/), Michigan, and Cincinnati. Likewise, she is no stranger to Atlanta, having sung the title role in their discovery productions of Maria de Buenos Aires for sold out productions twice within the last few years.

> Valdes's performance is one of the musical highlights of the evening, presenting a shimmering top voice and warm, even instrument throughout.

Here, Cuervo's soprano endures again as a sophisticated, lyric instrument, fitted with a strong sense of musicality and empathy. While in some lower parts of the voice, her sound is sometimes swallowed and muffled, the majority of the role was sung with the profound clarity that we have come to expect from the artist. 

Her interpretation of Frida Kahlo is beautifully flawed - a disabled heroine in an ableist society, fighting for what she feels is right, and taking no prisoners as she speaks her mind. There are points, unfortunately, where the score doesn't do her justice - monologues that, while beautifully presented, long for the sensitive undertones of conductor Jorge Parodi's chamber orchestra. Her Frida is led through life, discovering herself, her politics, her sexuality, and eventually coming to terms with her own mortality and sense of self in the triumphant finale.

> Her interpretation of Rivera's jealous and drunken ex, Lupe Marín is comical, strong, and wonderfully uncomfortable.

Alongside her sings Ricardo Herrera, who makes his Atlanta Opera debut at Diego Rivera, Frida's husband. Herrara's strong bass-baritone is woofy, passionate, and buoyant, allowing him to play the part of the carefree lover without much stress. His sensitivity, between meeting Frida and leaving her, his troubles with the communist party, and his return to Mexico, are beautifully portrayed by a seasoned, well tempered actor.

In the role of Cristina Kahlo is American soprano Maria Valdes, who, perhaps, gave the most vocally stable performance of the evening. Valdes, who studied in Atlanta and has been featured in The Atlanta Opera's _Yardbird_, has always been a staple of the city's singer community, cementing her status as an Atlanta success and a genuinely kind artist and colleagues.

Here, Valdes's sparkling soprano tugs empathetically at the hearts of the listener as Cristina, the shyer and possibly more vain of the Kahlo sisters, sings two stunning arias: one discussing Frida's strength and whimsy, and the other asking for her sister's forgiveness in solitude. Valdes's performance is one of the musical highlights of the evening, presenting a shimmering top voice and warm, even instrument throughout.

> The production is successful in telling the story of an artistic heroine and allowing the audience to view her humanity.

Many of the remaining actors perform numerous roles throughout the performance. Tenor [Andres Acosta](/scene/people/andres-acosta/) lends his competent lyric tenor to the role of Frida's first love, Alejandro, as well as the communist lover, Leon Trotsky. Gina Perregrino, a returning artist who graduated from The Atlanta Opera's studio program and impressed us with her work in [_Out of Darkness: Two Remain_](/perfect-for-its-time-heggie-double-bill-in-atlanta/), shows tremendous growth; her interpretation of Rivera's jealous and drunken ex, Lupe Marín is comical, strong, and wonderfully uncomfortable, while her small scene as the grieving mother of Dima is sung with a tender and silky mezzo-soprano.

Returning in his second year as an Atlanta Opera Studio Artist, Jonathan Bryan continues to impress, following up his success in _Dead Man Walking_ and _La traviata_ as Frida and Cristina's father and as Mr. Rockefeller. His voice is substantial inside, deeply resonant and clear, while his acting continues to show a determined and confident edge that will surely blossom into a healthy career.

Mezzo-soprano [Eliza Bonet](/scene/people/eliza-bonet/), who made her TAO debut in [_West Side Story_](/a-definitive-hit-west-side-story-in-atlanta/), takes the stage as the gilted lovers, Mrs. Rockefeller and Natalie Trotsky, two smaller roles that she justifies with a strong stage presence and competent technique.

Nathan Munson - who we have seen triumph in Capitol City Opera's _Gianni Schicchi_ and _Buoso's Ghost_, and The Atlanta Opera's _Seven Deadly Sins_ - takes on the smaller roles as a mourner and as Mr. Ford, inviting his strong, sensitive lyric tenor to mingle, brightly cutting through the orchestration while inviting a rounded, pleasant sound. One hopes we might see him sing something slightly more substantial on The Atlanta Opera's stage, considering his talent and the small roles he's done recently.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571280213/media/2019/10/AtlantaOperaFrida7454_bvgiau.jpg){{% /md %}}

<figcaption>Frida, The Atlanta Opera, 2019. Photo: Rafterman Photography.</figcaption>  
</figure>

Debuting with The Atlanta Opera Studio Program is Jouelle Roberson, whose soprano takes on smaller roles throughout the piece alongside Isaac Kim, Zachary Owen, graduated studio artist [Bryn Holdsworth](/scene/people/bryn-holdsworth/), and Jasmine Habersham. Again, having heard Habersham and Holdsworth over the years - most memorably in [_Out of Darkness: Two Remain_](/perfect-for-its-time-heggie-double-bill-in-atlanta/) - we can't hope but hear them both. Pamina? Manon? I'd pay to hear that.

Overall, the production is successful in telling the story of an artistic heroine and allowing the audience to view her humanity. However, it fails to adequately showcase the talent that The Atlanta Opera sourced to tell the tale. It's exciting to hear the singers in the smaller roles, and disappointing to hear their minimal lines and minimal development. The Stanislavski quote goes, "There are no small parts, only small actors," yet it feels like a relative injustice to the audience as well as the actors, talent that is seemingly stifled in these smaller roles.

This performance of _Frida_ tells a wonderful tale, beautifully performed and directed with an ensemble of capable and stunning singers. Unfortunately, the spotlight isn't wide enough to showcase their talent as well as it needs to be shown.