+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-10-23T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "MassOpera's presentation of [_Freedom Ride_](http://massopera.org/freedom-ride/) happens on November 3, 3pm, at The Strand Theatre in Dorchester, MA."
preamble = "On its way to a 2020 world premiere at Chicago Opera Theatre, [Dan Shore's _Freedom Ride_](http://massopera.org/freedom-ride/) will be part of MassOpera's latest New Opera Workshop on **November 3**.\n\nNamed for the [1961 Freedom Riders](https://en.wikipedia.org/wiki/Freedom_Riders) of the segregated American south, the opera centres on one young student who is pulled into the Civil Rights Movement. We spoke with Shore, stage director Tazewell Thompson, and conductor/COT Music Director [Lidiya Yankovskaya](/talking-with-conductors-lidiya-yankovskaya/), about this MassOpera performance and the larger creation process of new operas like _Freedom Ride_."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1571884605/media/2019/10/sqFreedomRide-resized_iym55h.jpg"
primary_image_credit = "The cast of Freedom Ride at MassOpera, 2019. Photo: Nile Scott Hawver."
related_articles = ["articles/talking-with-composers-alexina-louie.md", "articles/talking-with-conductors-lidiya-yankovskaya.md"]
related_companies = []
related_people = []
short_description = "\"I hope that the audience members will see themselves in the characters on stage, that they will be moved and inspired by the stories those characters tell, and will come away reflecting on how those stories relate to our world today.\""
slug = "operatic-journeys-massopera-presents-freedom-ride"
title = "Operatic journeys: MassOpera presents Freedom Ride"
youtube_url = ""

+++
## What do you think is unique about the structure and aesthetic of _Freedom Ride_?

**Dan Shore**: The storytelling and dramaturgy are actually very traditional, and the musical language tries to reflect the sounds that you would have heard in New Orleans in 1961, with lots of spirituals and gospel and protest songs. And if feels more like a musical from the 1960s than an opera from last week, that's fine with me.

**Tazewell Thompson**: It tells a true story using fictional characters. It presents what is believably perhaps one of many dozens of personal stories that occurred during the summer of 1961 in relation to desegregating the Greyhound and Trailways bus system in the Deep South.

**Lidiya Yankovskaya**: Dan really understands vocal writing. He uses the voice effectively to portray a variety of characters, driving the action forward with the music and allowing every word to shine through clearly, while remaining unafraid to push the boundaries of what the voice can do.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571844380/media/2019/10/FreedomRide3_tallzs.jpg){{% /md %}}

<figcaption>(l-r) Kristen Buabin, Michael Merullo, Tatum Robertson, Todd McNeel, Jr., Melynda Davis, Ezra Joshua Sanders, and Ron Williams, the cast of Freedom Ride at MassOpera, 2019. Photo: Nile Scott Hawver.</figcaption>

</figure>

## What do you think is the opera's message?

**TT**: The work of America's original sin: Race prejudice is a continuous experience and experiment and a constant dark shadow/cloud that is not entirely part of the past; it continues today in our very divisive present. Optimistically, we find forces at work, like during the Civil Rights Era, that seek to eradicate racial strife and bring us close to together, as the black and white Freedom Riders attempted to accomplish in the summer of 1961.

**LY**: This is a very human story about a young person who is discovering herself and weighing big life choices and their consequences. It is a story anyone can relate to - every day, each of us makes choices that affect our opportunities and impact the world and our loved ones.

**DS**: What I was interested in most of all when I was writing it was personal courage. Not all of us are particularly brave, and not all of us are able to naturally and instinctively do the right and moral thing in the face of grave personal danger. But somehow every single one of those people who took part in the Freedom Rides was able to muster the emotional strength and fortitude to do just that.

In the history books and the newspapers and on TV, they are bold and victorious. I wanted to put them onstage scared and unsure and vulnerable, and see what they had to do to become heroes. Because we are also scared and unsure and vulnerable, and we also need to learn how to become heroes. There's a lot of work out there to be done.

## What can you tell us about the opera workshop process that readers may not know?

**DS**: When you're writing, you're just one person sitting at home with a piano and a pad of paper and a bunch of pencils. And you think you're doing a decent job of creating realistic characters and a gripping story, but you don't really know. You never really know until you have actors and an audience. The actors can only bring a story to life if it connects with them emotionally, so the first thing you find out in a workshop is whether or not you gave them honest enough material, and what kind of changes you can make to help them perform their best. Once the audience files into the theater, you find out something else. If they're on the edge of their seats, hearts thumping, breathless with anticipation, you probably did an okay job. If they're bored and start looking at their watches, you have to go back to the piano and start rewriting.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571844396/media/2019/10/FreedomRide1_ukfaix.jpg){{% /md %}}

<figcaption>Tatum Robertson for Freedom Ride, MassOpera, 2019. Photo: Nile Scott Hawver.</figcaption>

</figure>

**LY**: An opera has so many elements and it takes a great deal of time to finesse and edit a work so it can be successful on the stage. A workshop allows the creative team to see the opera in context and to gauge audience reactions to it, without support from production elements like costumes and sets. During a workshop, we discover what is most moving and effective, what is clear to an audience and what doesn't come across, what passes by too quickly or drags on too long. All of those discoveries inform a composer's continued work on the piece.

**DS**: _Freedom Ride_ would be a completely different piece today if it weren't for all of the workshops it's been through, particularly in New Orleans, where I was able to work very closely over a long period of time with a phenomenal group of artists, including all of my students at Xavier University of Louisiana, and they made hundreds and hundreds of suggestions and ideas over the years. So I am a very big fan of the workshop process in general.

## Where does this MassOpera presentation of _Freedom Ride_ fit in with the opera's workshop process?

**LY**: We are moving toward the end of the process, and are now finessing some finer dramaturgical points. With this workshop, we're focusing primarily on the way the orchestra interacts with the singers and addressing any orchestrating challenges.

**DS**: This is very near the end of a process that has taken me eight and a half years. So a lot of this music has been heard before, in New Orleans, in Mexico City, in New York, and here in Boston, although it has been tinkered with an awful lot over the years. But some of it is new, and you'll be hearing it for the very first time. And the orchestrations are brand new, and we’ll all be hearing them for the very first time together!

**TT**: MassOpera will be the most important and impactful workshop for _Freedom Ride_; the penultimate and most insightful. It will be presented in the beautiful Strand Theater. A full orchestra (not just piano accompaniment), the finest local voices of all ages, concert style with suggested staging.

The MassOpera workshop will be the last stop prior to the Chicago Opera Theatre world premiere in February, and it is extraordinarily significant. Composer and librettist, conductor and director will have a final opportunity to hear and see all the pieces pulled together through our own senses and through the ears and eyes of the audience. I am personally grateful for the opportunity MassOpera has afforded me to participate in this necessary workshop.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571844411/media/2019/10/FreedomRide2_p1sg6f.jpg){{% /md %}}

<figcaption>The cast of Freedom Ride at MassOpera, 2019. Photo: Nile Scott Hawver.</figcaption>

</figure>

## What do you hope audiences will take away from these performances?

**TT**: A chance to examine where we've been as a people/Americans; how far we've come in race relations and racial equality and justice, and how far we have yet to go in achieving balance, fairness and respect one's differences; that together we can aspire to so much human fulfillment and dignity; that dividing us creates chaos, fear and misunderstanding.

**DS**: I hope that people who have never been to an opera before will decide that they want to come back and see another one. I hope that people who don't know that much about the Civil Rights Movement will realize how profound and far-reaching that struggle for equality has been and how much has been sacrificed to try to make this this country a better place. And I hope that everyone - especially young people - will see that they really do have the power to change the world by standing up for what they believe in.

**LY**: I hope that the audience members will see themselves in the characters on stage, that they will be moved and inspired by the stories those characters tell, and will come away reflecting on how those stories relate to our world today.