+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-04-10T23:25:00-04:00"
lastmod = "2015-04-10T23:25:00-04:00"
preamble = "<p>\n\t<a href=\"http://dallasopera.org/\" target=\"_blank\" data-mce-href=\"http://dallasopera.org/\">The Dallas Opera</a> has announced an exciting new residential program: the <a href=\"http://dallasopera.org/learn/womens-conducting-institute/\" target=\"_blank\" data-mce-href=\"http://dallasopera.org/learn/womens-conducting-institute/\">Institute for Women Conductors</a>. Running November 28th to December 5th, 2015, the program gives young women the chance to learn and gain conducting experience, with guidance from TDO's Music Director <a href=\"http://dallasopera.org/about/staff/music-director/\" target=\"_blank\" data-mce-href=\"http://dallasopera.org/about/staff/music-director/\">Emmanuel Villaume</a>, and Principal Guest Conductor, <a href=\"http://dallasopera.org/about/staff/guest-conductor/\" target=\"_blank\" data-mce-href=\"http://dallasopera.org/about/staff/guest-conductor/\">Nicole Paiement</a> (pictured above). Six participants will be selected from the application process, and all six will conduct in a final concert with The Dallas Opera Orchestra. <a href=\"http://dallasopera.org/about/staff/general-director/\" target=\"_blank\" data-mce-href=\"http://dallasopera.org/about/staff/general-director/\">Keith Cerny</a>, General Director and CEO of The Dallas Opera, took the time to answer a few of my questions about what I think is an exciting new precedent in training today's artists.\n</p>"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428722480411/Nicole-Paiement-by-Roger-Steen-1_Fotor.jpg.jpg"
primary_image_credit = "Conductor Nicole Paiement. Photo: Roger Steen"
publishDate = "2015-03-02T09:25:00-05:00"
related_articles = ["articles/in-review-hannigan-grazinyte-tyle-BBC-proms.md","articles/dont-miss-everybodys-got-a-story.md","articles/more-operatic-roles-for-women-a-pledge.md"]
related_companies = ["scene/companies/the-dallas-opera.md"]
related_people = ["scene/people/jennifer-condon.md","scene/people/jessica-gethin.md","scene/people/natalie-murray-beale.md","scene/people/stephanie-rhodes.md","scene/people/anna-skryleva.md","scene/people/lidiya-yankovskaya.md","scene/people/arianne-abela.md","scene/people/lucik-aprahamian.md"]
short_description = "The Dallas Opera has announced an exciting new residential program: the Institute for Women Conductors. Running November 28th to December 5th, 2015, the program gives young women the chance to learn and gain conducting experience, with guidance from TDO’s Music Director Emmanuel Villaume, and Principal Guest Conductor, Nicole Paiement (pictured above). Six participants will be selected from the application process, and all six will conduct in a final concert with The Dallas Opera Orchestra."
slug = "fostering-maestras-the-institute-for-women-conductors-at-the-dallas-opera"
title = "Fostering Maestras: The Institute for Women Conductors at The Dallas Opera"
+++

<h2>1. Why is the Institute for Women Conductors an important program in today's classical music scene?</h2>
<p>
	Despite the greater participation of women in advanced conducting programs, many talented women "stall out" before reaching the top tier of the conducting profession. This new program aspires to help participants to bridge the gap between early career success and being engaged to conduct at the world's top performing arts institutions; in doing so, the program is expected to stimulate a national conversation about women conductors and the barriers they continue to face in professional advancement.<a href="http://dallasopera.org/learn/womens-conducting-institute/" target="_blank"> The Institute for Women Conductors at The Dallas Opera</a> will also work to connect interested parties (e.g. artist managers, symphony CEOs and opera company general directors) with carefully selected, top-tier young women conductors, focus more media attention on the issue and last, but certainly not least, elevate the profile of talented women conductors in the minds of key decision makers—those who will select tomorrow's music directors and guest conductors.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428722580079/Paiement2_Fotor.jpg"><img data-resize-src="http://lh3.googleusercontent.com/3fxWHjXack33A_CH1X3WmfLMn9x6AuWc6_RPQC2SuL5YuBm00z4BQuJrw8aLOPU7Nto2CGIlzswir2mCDyYWr5xVEl6p" src="http://lh3.googleusercontent.com/3fxWHjXack33A_CH1X3WmfLMn9x6AuWc6_RPQC2SuL5YuBm00z4BQuJrw8aLOPU7Nto2CGIlzswir2mCDyYWr5xVEl6p=s1200"></a><figcaption>Nicole Paiement leading a rehearsal in the Winspear Opera House, Dallas. Photo: Karen Almond</figcaption></figure>
<h2>2. What level of conducting experience is suitable for the program?</h2>
<p>
	Through its application and screening process, TDO is recruiting participants aged 40 and younger who have already distinguished themselves in some aspect of classical music or opera. Successful applicants may already have achieved some initial success as a regularly performing conductor, but we also encourage distinctively talented instrumentalists, opera coaches and pianists, concertmasters, music staff, composers, and even well-established singers to apply. In general, we would expect the applicant to have at least some limited track record in conducting, but there are many cases over the last 200 years where sheer musical talent trumped limited past experience as a conductor; you need only look at Gustav Mahler's early career as an example to observe the speed at which a conductor can develop if the right opportunities are given to a uniquely gifted individual. Consequently, we encourage candidates reflecting a wide range of musical backgrounds to apply.
</p>
<h2>3. What kind of professional advice do young conductors need at the beginning of their careers, and how does the Institute for Women Conductors fit in?</h2>
<p>
	In our view, young women conductors need a blend of musical training and experience in performance, as well as coaching and guidance in important aspects of career management – especially in a field still so dominated by men. For the former area, Institute participants will have the chance to work directly with the superb <a href="http://dallasopera.org/about/staff/orchestra/" target="_blank">Dallas Opera Orchestra</a>, and participate in master classes with our Music Director [Emmanuel Villaume] and Principal Guest Conductor [Nicole Paiement], as well as hearing perspectives on how to partner most effectively with a concertmaster – an important contributor to success for any conductor. In the area of career management, we will also include other elements in the curriculum, including: finding the right artist manager; personal branding and image management; conducting successful media interviews (rehearsed through role plays); guest lecturers providing various perspectives on succeeding in a male-dominated field, and more technical areas such as selecting repertoire for career impact, the role of contemporary opera, and accepting and declining specific engagements. For many of these areas, there are no "right" answers or approaches; rather, we aspire to sensitize the program participants to the underlying issues and suggest a range of responses from which they can select the approach that works best for them.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428722660755/KAP_7316A_Fotor.jpg"><img data-resize-src="http://lh3.googleusercontent.com/iDk27_zl8nyZicfHCiTBBWRvZXuk6V-09qdkqLjLX-KaeHJQOTzTsPtqo_G6ypoRpkpxmjL8PmscGNoi8IAvBRNXMyHk" src="http://lh3.googleusercontent.com/iDk27_zl8nyZicfHCiTBBWRvZXuk6V-09qdkqLjLX-KaeHJQOTzTsPtqo_G6ypoRpkpxmjL8PmscGNoi8IAvBRNXMyHk=s1200"></a><figcaption>Music Director Emmanuel Villaume. Photo: Karen Almond</figcaption></figure>
<h2>4. More and more women are pursuing conducting as a career; how do you think this will change the classical music industry, or its reception?</h2>
<p>
	Conducting, like any other profession, can be thought of as a "pipeline", where new entrants gradually increase their skills and build their reputations, develop their careers, and then eventually retire. As noted before, many more women are pursuing conducting training, and, with the right opportunities and encouragement, will enter the field and eventually distinguish themselves as top-tier international conductors. In general, many other fields, such as law, business, government, academics – even airline pilots – have benefitted greatly over previous decades from being able to draw on the "missing 50%" of their respective talent pools, as women have entered the field; this situation is the same for conducting, and certainly orchestras have benefitted artistically from hiring more women players in their ranks over the last several decades. In addition, women conductors will influence the classical music field in two further ways. First, by adding so much talent to the underlying talent pool, they will naturally increase the range of the artistic approaches taken to both new and established works, which is always beneficial for any art form. Second, having a better balance between men and women conductors on the podium allows the performers to better "mirror" their audiences, making classical music with orchestra a more representative and inclusive experience. This inclusiveness will help performing arts organizations sell tickets, raise money, and better serve the community in which they reside.
</p>
<p>
	Applications for the <a href="http://dallasopera.org/learn/womens-conducting-institute/" target="_blank">Institute for Women Conductors</a> are due April 15, 2015. For more information and application requirements, <a href="http://dallasopera.org/learn/womens-conducting-institute/" target="_blank">click here</a>.
</p>
