+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-09-02T14:00:00-04:00"
lastmod = "2015-04-16T15:42:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429213312316/hspink01a.jpg.jpg"
publishDate = "2014-09-02T14:00:00-04:00"
related_articles = ["articles/what-oscarssowhite-can-learn-from-opera.md","articles/being-a-nice-person-why-art-really-really-matters.md"]
short_description = "Are we a forgiving bunch, us opera-lovers?  There&#039;s a curious phenomenon of forgiving outdated social mores (racism, for example) in works of theatre and opera that we really like. It seems like fans of opera and musical theatre will look at plenty of bad onstage behaviour in their favourite show, and chalk it up to metaphor or &quot;the way it was back then&quot;. It&#039;s oddly forgiving in a world which feeds largely upon criticism."
slug = "forgiving-racism-onstage"
title = "Forgiving Racism Onstage"
+++

Are we a forgiving bunch, us opera-lovers? There's a curious phenomenon of forgiving outdated social mores (racism, for example) in works of theatre and opera that we really like. It seems like fans of opera and musical theatre will look at plenty of bad onstage behaviour in their favourite show, and chalk it up to metaphor or "the way it was back then". It's oddly forgiving in a world which feeds largely upon criticism.

Just look at an opera like _Madama Butterfly_. A Google search will return just as many results about _Butterfly_'s controversial reception history as about the show itself. If there were to be a film made with the same plot, it would obviously have to be a masterpiece of racial commentary to pass itself off as anything but racist-championing. And Puccini is at fault too; I'm not saying it isn't fascinating to see how he uses original Japanese melodies throughout his score, but _where_ he uses them is just so suspect. With the exception of her love duet with Pinkerton, Butterfly stubbornly sings in her own modal harmonies and pentatonic tunes. I suppose all the chromaticism gets the best of her, just like it did with Carmen. There's a clear bit of musical racism, I suppose. It has stayed in the mainstream operatic canon since its rocky premiere in 1904; but apparently [everyone is afraid of making judicial changes or cuts](http://www.telegraph.co.uk/news/uknews/1542633/Opera-expert-says-Puccinis-Butterfly-is-racist.html) to avoid the more bluntly ignorant moments.

Other culprits are shows like _The Mikado_ for which with each passing year the argument from posterity strengthens. Recently a [Seattle Repertory Theatre](https://www.seattlerep.org/) production of _The Mikado_ [wound up in the press](http://www.thestranger.com/seattle/the-problem-with-the-mikado/Content?oid=20174728) for having a cast of nearly 40 singers and actors, none of them Japanese. Awkward casting decisions (and alleged used of "[yellowface](http://www.nikkeiview.com/blog/2013/05/its-time-to-take-the-offensive-yellowface-of-the-mikado-off-the-stage/)") aside, _The Mikado_ is consistently at the front of the argument over exoticism as a tool for satire, and simply outdated ways of telling stories. Says Brendan Kiley at [_The Stranger_](http://www.thestranger.com/seattle/the-problem-with-the-mikado/Content?oid=20174728), _"The Mikado_<span style="color: #222222;"> may be brilliant, and its original intentions may have been to satirize British society by way of satirizing a fictionalized version of Japanese society, but it's aggressively obtuse to perform a racially charged, Victorian-era play and not address the problems with the source material." There's gross confusion of Japanese and Chinese cultural elements, and the characters have names like Nanki-Poo.</span>

There's also the racial justification for bad behaviour of traditionally black characters like [Othello](http://dramatica.com/analysis/othello#mc) and [Monostatos](http://www.theguardian.com/music/2008/jul/09/classicalmusicandopera.comment), who simply can't control their tempers because of they're Moors, and the problem of whether or not _Porgy and Bess_ is too much a story about black people written by white people. Not to mention all those awkward moments in shows like _West Side Story_ or _South Pacific,_ where the American lenses are enough to make you cringe.

I even remember going to the [Stratford Festival](http://www.stratfordfestival.ca/) years ago with my mother to see a few shows, one of which was [_Gigi_](http://en.wikipedia.org/wiki/Gigi_(musical)), the 1958 musical by Lerner and Loewe. The issue with _Gigi_ wasn't racism; it was that the show was about an older bachelor who develops romantic feelings for his old friend's _granddaughter_. He's got songs like "I Remember it Well" where he's totally creepy about this much younger girl, but they're written as true love ballads in the context of the show. I remember mom and I wondering afterwards just why _Gigi_ is still done. Maybe the larger message was lost of me, but is there a real need to preserve parts of our culture that represent elements in which we've achieved positive change?

I'll be fair and talk about the historical truth that some cultures become _en vogue_ for other cultures. Everything Turkish was all the rage while Mozart was a live, and at the end of the 19th century, there was a [craze](http://en.wikipedia.org/wiki/Japonism) for everything Japanese. And there was [plenty of bad science](http://en.wikipedia.org/wiki/Scientific_racism) being done resulting in "scientific racism", largely towards black people, that helped create "raging" characters like Othello.

I just find it fascinating what we decide to ignore in our entertainment. _Madama Butterfly_ has probably stood the test of time largely because the music is so freaking fantastic, just like _Otello_ and _Die Zauberflöte_. _The Mikado_ is G&S, which usually go over well with the general public, as do shows like _South Pacific_ and _West Side Story_. I think the neat thing about this problem is that it will continue to push directors to truly find something to say with these pieces, to the point of being judicious enough to toss the thing in the reject pile, at least for another season.
