+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = "2017-10-17T18:48:00-04:00"
lastmod = "2017-10-19T20:33:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508280787063/2017-10-17---square---17.-Matthan-Black%2C-Julia-Hardin%2C-Curtis-Bannister%2C-Melinda-Alberty_The-Scorpions'-Sting.jpg.jpg"
primary_image_credit = "Matthan Black, Julia Hardin, Curtis Bannister, and Melinda Alberty in The Scorpions' Sting, Lyric Opera of Chicago, 2017. Photo: Michael Brosilow."
publishDate = "2017-10-19T20:13:00-04:00"
related_articles = ["articles/opera-for-all-the-magic-victrola.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
short_description = "It must be a difficult task, to write a work specifically for young people that does not come off as overly moralistic or saccharine. Happily, the gist of The Scorpions&#039; Sting - the power of forgiveness and the importance of teamwork - avoids sentimentality by being genuinely funny, (alternating effectively between sarcasm and overt goofiness). "
slug = "for-kids-grown-ups-alike-the-scorpions-sting"
title = "For kids &amp; grown-ups alike: The Scorpion&#039;s Sting"

+++
This past weekend, on an uncommonly dark and stormy Saturday afternoon, Lyric Unlimited kicked off a four-performance run of [_The Scorpions' Sting: an Opera for Young People_](https://www.lyricopera.org/concertstickets/calendar/2017-2018-other/productions/lyricopera/the-scorpions-sting-opera-tickets) at the Studebaker Theater in downtown Chicago. The production marks the U.S. premiere of the opera, with text and music by Canadian composer [Dean Burry](/scene/people/dean-burry/). This week, _The Scorpions' Sting_ began its tour through Lyric Unlimited's [Opera in the Neighborhoods](https://www.lyricopera.org/lyricunlimited/studentsandteachers/operaintheneighborhoods) program. In total, 30 performances will be given at 15 different locations. Over 20,000 young people will see it, including Chicago Public School students, students in charter and private schools, and home-schooled children, all in grades 3-6.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1546110665/media/2018/12/2017-10-17---Audience-shot-3-The-Scorpions%27-Sting.jpg)<figcaption>Members of the audience at _The Scorpions' Sting_, Lyric Opera of Chicago, 2017. Photo: Michael Brosilow.</figcaption>
</figure>

On Saturday afternoon, it was a joy to see the theater lobby full of children. As we waited for the doors to open, we all eagerly thumbing through our programs, ingeniously designed as activity books, filled with illustrations from the production’s costume designer, Noël Huntzinger, a plot synopsis, information and word games about Ancient Egypt, and a rather brilliant diagram titled "How an Opera is Created." Artist bios took interview form, with questions like, "What did you do for fun as a kid?" and, "Any advice for someone wanting to become a singer?"

_The Scorpions' Sting_ tells the story of a group of archaeology students who find themselves in the Lost Temple of Isis after their professor is bitten by a scorpion. The three students attempt to read the hieroglyphs in the Temple in the hopes they will reveal a cure for the scorpion's poison. As they translate, the mythical story of King Osiris and his scheming brother, Set, plays out in front of them. According to the myth, Set stole the throne of Egypt from his brother, King Osiris, by tricking Osiris during an unusual party game. Queen Isis escapes imprisonment with the help of her sister, Nephthys, a magic sistrum, (an Egyptian percussion instrument), and a group of seven scorpions. The scorpions wind up biting a woman's baby and Isis casts a healing spell that cures the titular scorpions' sting. After our band of archaeology students uncover Isis' spell, they use her magic (and the magic of teamwork!) to cure the professor.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508280918765/2017-10-17---3.-Julia-Hardin%2C-Melinda-Alberty%2C-Matthan-Black_The-Scorpions'-Sting.jpg.jpg)
<figcaption>Julia Hardin, Melinda Alberty, and Matthan Black in _The Scorpions' Sting_, Lyric Opera of Chicago, 2017. Photo: Michael Brosilow.</figcaption>
</figure>

It must be a difficult task, to write a work specifically for young people that does not come off as overly moralistic or saccharine. Happily, the gist of _The Scorpions' Sting_ - the power of forgiveness and the importance of teamwork - avoids sentimentality by being genuinely funny, (alternating effectively between sarcasm and overt goofiness). And the choice to use Egyptian myth and archeology was a fantastic one - what child, (or person, for that matter) isn't captivated by the pyramids, hieroglyphs, kings, mummies, and attendant mysteries of Ancient Egypt?

The design of _The Scorpions' Sting_ was calibrated for maximum efficiency: the score was played from the piano by music supervisor, Matthew Gemmill, the set, (designed by Lauren Nigri) was simple but looked fabulous on the Studebaker stage and I have no doubt it will travel well to its upcoming venues.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508280927045/2017-10-17---9.-Melinda-Alberty-and-Matthan-Black%2C-The-Scorpions'-Sting.jpg.jpg)
<figcaption>Melinda Alberty and Matthan Black in _The Scorpions' Sting_, Lyric Opera of Chicago, 2017. Photo: Michael Brosilow.</figcaption>
</figure>

The costumes, which ranged from modern-day student-y looks to draped gowns and fanciful collars, were also well-executed. Huntzinger is to be particularly commended for the zany and wildly effective seven-scorpions costume.

And surely those costumes all involved a deal of well-placed velcro because between the cast of four singers, they portrayed ten different characters over the course of the 45-minute opera. All four cast members are to be commended not just for their flawless quick changes but for their great diction; I didn't miss a single word. Soprano Melinda Alberty was a sweet-voiced Sally Smith - the good-hearted, big-brained student who urges the others to help her find a cure for the sting. Though her voice was occasionally lost in ensemble numbers, it was moving and crystal-clear everywhere else, particularly during the more dramatic moments when she was singing as Isis, the Goddess of Healing. Curtis Bannister was a goofy Professor Hornby and perfectly toed the line between sinister and silly as Set. Julia Hardin and Matthan Black gamely performed three roles each. Hardin has a great physical ease onstage and her expressive voice was especially lovely when she sang as Nephthys. Matthan Black was especially charming as a gung-ho Osiris and all seven scorpions. Black has a fantastic sense of comic timing and his physical humor elicited giggles from children and adults alike.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508280955095/2017-10-17---6.-Curtis-Bannister%2C-Julia-Hardin%2C-Matthan-Black_The-Scorpions'-Sting.jpg.jpg)
<figcaption>Curtis Bannister, Julia Hardin and Matthan Black in _The Scorpions' Sting_, Lyric Opera of Chicago, 2017. Photo: Michael Brosilow.</figcaption>
</figure>

I wish the cast and crew of this production the best of luck as they take this show out of the theater and into schools across Chicago!