+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = "2019-01-21T20:52:46+00:00"
disclaimer = ""
image_gallery = []
postamble = "HGO's production of _Florencia en el Amazonas_ runs through February 3. For details, [click here](https://www.houstongrandopera.org/florenciaenelamazonas)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1548103901/media/2019/01/sqHGO-Florencia-2019-OrchestraDressRehearsal-PhotographerLynnLane-159.jpg"
primary_image_credit = "Ana María Martínez as Florencia Grimaldi in Florencia en el Amazonas, HGO, 2019. Photo: Lynn Lane."
related_articles = ["articles/a-butterfly-but-not-from-puccini.md"]
related_companies = ["scene/companies/houston-grand-opera.md"]
related_people = ["scene/people/joshua-guerrero.md", "scene/people/alicia-gianni.md", "scene/people/norman-garrett.md", "scene/people/ana-maria-martinez.md"]
short_description = "Martínez's inimitable dulcet vibrato tones had a way of embodying the butterflies into which her character eventually transforms. Anybody wanting an avenue to approach this opera would do well to begin with her music, which offers this opera's most audible links with the traditional Puccinian repertoire which is her specialty."
slug = "florencia-en-el-amazonas-takes-on-a-life-of-its-own-at-hgo"
title = "Florencia en el Amazonas takes on a life of its own at HGO"
youtube_url = ""

+++
Houston Grand Opera's legacy of promoting contemporary operas was triumphantly vindicated on the opening night of their production of Daniel Catán's [_Florencia en el Amazonas_](https://www.houstongrandopera.org/florenciaenelamazonas), a drama concerning people's helplessness in the face of nature in all its raw power. Inspired by characters drawn from the magical realist works of Colombian author Gabriel García Márquez, this work could be truly said to have taken on a life of its own with the number of fans it has inspired (what with it having brought Spanish-language opera into its own in this country beyond what even the Metropolitan Opera's 1916 premiere of _Goyescas_ could dream of accomplishing), though this is in no way to describe this work as a passing fad, for it is quite simply a profound masterwork that cannot fail to leave a provocative impression.

> _Florencia en el Amazonas_ is the epitome of the best elements of opera mixed together with an elusive authentic modernist sense of adventure.

The news of this production came to me just as I began to essay an intensive study of the Spanish language; this, in combination with the recent multiplicity of Spanish-language television and films on Netflix, made my attendance a certainty. What better way to practice listening comprehension than see how much text I could understand without looking at the surtitles? I'd say I was 50 percent successful in this case, and this was reasonable given how difficult it was for voices to penetrate the sometimes dense orchestration, though I did understand enough to perceive that the rigid blocks of surtitles lent themselves imperfectly to conveying the gist of librettist Marcela Fuentes-Berain's limpid, malleable text.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548104983/media/2019/01/HGO-Florencia-2019-OrchestraDressRehearsal-PhotographerLynnLane-2.jpg){{% /md %}}

<figcaption>The Houston Grand Opera Chorus in Florencia en el Amazonas, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>

</figure>

Certainly Florencia ([Ana María Martínez](/scene/people/ana-maria-martinez/)) was the character whose journey I could follow most easily, generally because the often-strident violins were well under control during her unencumbered, airborne lines. Indeed, Martínez's inimitable dulcet vibrato tones had a way of embodying the butterflies into which her character eventually transforms. Anybody wanting an avenue to approach this opera would do well to begin with her music, which offers this opera's most audible links with the traditional Puccinian repertoire which is her specialty; her role also exemplifies the way in which this is an opera about characters as opposed to plot, and therefore rewards a great deal of focus.

Besides Florencia, the role that most immediately stands out would have to be Ríolobo ([Norman Garrett](/scene/people/norman-garrett/)), who is the embodiment of the world of spirits that haunt this magical realist universe. Even as he makes his first appearance at the open-air marketplace of Leticia (whose _La bohème_-reminiscent vendors the Houston Grand Opera Chorus eagerly portrayed with highly naturalistic vitality), he gives an air of knowing that the world has its own plans for the cast. Always stentorian, somewhat puckish, though never quite predatory in appearance as he flicked about the rotating riverboat, Garrett was always keen to remind us of the dangers of the mighty Amazon (these fluvial spirits being portrayed by an array of speedy dancers clad in colorful costumes, periodically spiriting articles away from the passengers). Indeed, as the benevolent and wise Capitán (David Pittsinger) longingly and with great pathos implored the mighty and stormy river to have mercy on his vessel, the omnipresent Ríolobo was particularly arresting in invoking the protection of the spirits, whose choral response from the balconies was uncannily terrifying, entirely sufficient to remind me of the atmosphere in many an opera's incantation or underworld scene.

> Here a raucous woodwind passage, there a brass section moment, the combined result giving me the feeling of wading through the exotic wordscapes of Doña Bárbara.

Ríolobo was particularly charismatic as well when announcing the day's special lunch of iguana, much to Paula's ([Nancy Fabiola Herrera](/scene/people/nancy-fabiola-herrera/)) chagrin; this should not be a surprise, given that Herrera was very apt at expressing some sort of declamatory emotion or opinion about everything. As Alvaro, baritone Thomas Glass was an agreeably gallant and affable presence who was somehow able to maintain a degree of gentlemanly composure throughout the action, even when inexplicably rescued from the lethal currents in the second act.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548105108/media/2019/01/HGO-Florencia-2019-OrchestraDressRehearsal-PhotographerLynnLane-28.jpg){{% /md %}}

<figcaption>Ana María Martínez as Florencia Grimaldi in Florencia en el Amazonas, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>

</figure>

The couple of Rosalba ([Alicia Gianni](/scene/people/alicia-gianni/)) and Arcadio ([Joshua Guerrero](/scene/people/joshua-guerrero/)) were quite dynamic in their own right. Arcadio, a typically earnest tenor, showed a existential struggle to find purpose in his life beyond the regular voyages of the El Dorado, one which he expressed with authenticity and evenness throughout his range. Rosalba, whose high tessitura should easily indicate her generally intense personality, could be seen to feel deeply her loss to the river of her precious notes on a prospective biography of the diva Florencia. When the latter was prompted, incognito, to utter something akin to "there's nothing about her life that is either not in your memory or fantasy," I was instantly reminded of the inferno which destroyed a great portion of the extensive collection of Brazil's National Museum, in which case, this line is quite literally true. Such is the anguish present at realizing the ultimate tenuousness of human knowledge.

> Catán, a native of Mexico City, has rightly had his music hailed alongside the likes of Debussy, Ravel, and Puccini for its brilliance, luminescence, and fluency in deployment of soaring vocal lines

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548105286/media/2019/01/HGO-Florencia-2019-OrchestraDressRehearsal-PhotographerLynnLane-76.jpg){{% /md %}}

<figcaption>(l-r) Joshua Guerrero as Arcadio, Nancy Fabiola Herrera as Paula, Tommy Glass as Alvaro and Alicia Gianni as Rosalba in Florencia en el Amazonas, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>

</figure>

Catán, a native of Mexico City, has rightly had his music hailed alongside the likes of Debussy, Ravel, and Puccini for its brilliance, luminescence, and fluency in deployment of soaring vocal lines atop a lush and colorful, yet always supportive orchestral apparatus, deploying tonal harmonies with monolithic assurance, though in a subtly rhythmically unstable and amorphous universe that makes any comparison to any of those masters ever so slightly in need of qualification. In addition, there were definitely echoes of the sort of austere modalism employed by earlier Mexican modernists such as Carlos Chávez and Blas Galindo, but in a more Romantic surrounding. At any rate, this music was never in danger of becoming becalmed, even if it became placid in several places; it was always rhythmic and did well to convey the river's inexorable course. For my part, this music most immediately reminds me of the work of Albéric Magnard, whose enigmatic, capricious, even Mahlerian Belle époque symphonies might enjoy greater fortune if he had not prematurely succumbed to the opening salvos of the Great War.

Maestro Patrick Summers led this orchestral maelstrom with the great assurance that comes out of devotion to a masterwork which he has known for years, the desire to make everything count, with humility enough to understand that a powerhouse like this can easily consume those who approach it recklessly. Although Catán's selective deployment of turgid bass instrument textures (with good reason given the surroundings) made balance a very tricky proposition even at the best of times, this was generally easy to overlook because of the composer’s ability to keep the rest of the score always interesting. Here a raucous woodwind passage, there a brass section moment, the combined result giving me the feeling of wading through the exotic wordscapes of Doña Bárbara. And did I mention the tasteful steel drums?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548105409/media/2019/01/HGO-Florencia-2019-OrchestraDress-PhotographerLynnLane-90.jpg){{% /md %}}

<figcaption>Norman Garrett as Ríolobo in Florencia en el Amazonas, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>

</figure>

In sum, this opera quite simply needs its own appreciation course, for _Florencia en el Amazonas_ is more than merely a multi-layered operatic masterwork of subtlety in all aspects, that shows just how insufficient one listening is to enable one to take it all in, or merely an introduction to the compelling dramatic world of the Latin American literary boom; rather, it is the epitome of the best elements of opera mixed together with an elusive authentic modernist sense of adventure.