+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-03-04T21:58:00+01:00"
lastmod = "2017-03-06T16:55:00+01:00"
preamble = "Winnipeg-based [Flipside Opera](/scene/companies/flipside-opera/) is all about getting opera and classical music heard by Manitoban audiences, and providing performance opportunities to the province's talented artists. \n\nTheir current project celebrates the music of Manitoba-born composer, John Greer; [\"Greeriad\"](https://www.flipsideopera.com/greeriad) (a play on the [\"Schubertiade\"](https://en.wikipedia.org/wiki/Schubertiade)) had its Winnipeg performance last month, and on **March 10, 8pm**, it returns to Manitoba at Brandon University. Singers singers: Jessica Kos-Whicher, Judith Oatway, Elizabeth Surdhar, Aaron Hutton, Matt Pauls, and pianists Lisa Rumpel and Dr. Laura Loewen, pay homage to Greer's music, and to the notable Canadian roots which the artists and composer share.\n\nWe spoke with soprano and Flipside Opera co-Artistic Director Judith Oatway, and with John Greer himself, about [Greeriad](https://www.flipsideopera.com/greeriad), and the important symbiosis between Canadian companies and Canadian composers."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1488661101054/2017-03-04---Greeriad.jpg.jpg"
primary_image_credit = "Aaron Hutton, tenor, and Elizabeth Surdhar, mezzo-soprano, both singing in Flipside Opera's \"Greeriad\". "
publishDate = "2017-03-06T16:55:00+01:00"
related_companies = ["scene/companies/flipside-opera.md"]
short_description = "&quot;I am more grateful than I can say for opportunities such as the Flipside Greeriad, to see my songs performed by artists who understand them from the inside out and who can pass their full message on to an empathetic audience. I am on the Board of Directors for the Canadian Art Song Project, a nation-wide organization dedicated to the promotion of new Canadian vocal music. I realize from this central standpoint how regionalized artistic expression is or can be.&quot;"
slug = "flipside-opera-throws-a-greeriad"
title = "Flipside Opera throws a &quot;Greeriad&quot;"
+++

## What appealed to you about *Greeriad*, and why did you want to bring it to Manitoba audiences?

**Judith Oatway**: Lisa Rumpel, Dawn Bruch and I, who are co-artistic directors of Flipside Opera, have all had John's music on our bucket list of performances for some time.  Part of Flipside's goal is to make this art form more accessible to non traditional audiences.  The combination of a 'house concert'/intimate performance space and John's immediately emotional, folk-inspired music was a good fit for us.  John's music is extremely challenging for singers and pianists which makes for a rewarding experience to perform.    There is something familiar in his music and our hope is that Manitoban audiences will feel this too.  I really believe that John Greer's music captures an essence of 'Prairieness' no matter what the subject matter.

## What kind of musical aesthetic do you find comes out of your Prairie-inspired works?
	
**John Greer**: This is a difficult question to answer.  My Dad & Mom grew up on on the prairies (Kerrobert, SK and Selkirk, MB) and I was raised here until the end of my undergraduate studies and a "gap year", so I feel my "default" thoughts and way of thinking belong to the prairies.   Even when I set British writers like Walter de la Mare, Wilfred Owen or Anna Jameson or American writers like Dorothy Parker, or when I set Canadian folk song from the north, the west coast or the Maritimes, I am doing so from some kind of prairie perspective.  So my idea of a Maritime tale like the rescue of the sunken Mary Ellen Carter will always have a slightly exotic central-Canadian cast to it.  

But the Greeriad program does have some very distinctive "Prairie" pieces in it! *Sarah Binks* is the fictitious "Sweet Songstress of Saskatchewan", but she was created by Manitoban professor Paul Hiebert and known and loved by many prairie residents especially of past generations.   Of course, the songs feature square-dance rhythms and even some borrowed tunes (such as the infectious reel "Whisky Before Breakfast"!)  But like all dwellers of the plains, Sarah searched far afield.  She translated Heine poetry, so I was able to set her idiosyncratic translations to  Schumann's music, as seemed most appropriate.  Sarah was to me as Heine was to Schumann!  The *Log Drivers Waltz* is written by a Saskatchewan writer, Wade Hemsworth, so when arranging that song, I simply had to be as authentic and true to the original song as possible.   In *All Around the Circle* the prairies are represented by on folk song: *Old Grandma*. In setting this movement, my image was of a stoic older couple similar, perhaps, to the famous couple with the pitch fork in Grant Wood’s painting American Gothic.  Though Wood was American, we probably share more with our American prairie brothers and sisters than we do with residents of disparate regions of our vast and culturally diverse country!

In my most recent chamber work, *A Prairie Boy's Life*, I was able to enjoy musically portraying prairie meteorological and natural phenomena (first snow, blizzards, sun dogs, thunder storms, crows, chickadees, Lake Winnipeg, etc.) and because of this, I feel it is my most idiosyncratic prairie piece to date.  

## What kind of audience feedback have you gotten from previous performances?

**JO**: For *Greeriad*'s performances this past weekend, we had overwhelmingly positive feedback.  We programmed some chestnuts to let everyone sit back and enjoy familiar melodies as well as programming some more challenging repertoire. Numerous people commented on the concert's pacing, programming and high quality performances. A few even called it one of their favourite concerts to date!

In our past performances (*Heavyweights and Bathtubs*, *Bus Stops and Bridge*) we have been encouraged by the support and feedback from audiences.  We are trying to offer challenging repertoire which highlights Manitoban artists and composers whenever possible.  We are also performing repertoire that no one else is programming. 


## What sort of responsibility do you think Canadian companies have to the music of Canadian composers?

**JG**: If Canadian companies don't encourage and feature Canadian composition, no one will.  I realized when I lived and worked in the USA as a music educator how strong and virtually impenetrable the cultural walls are even between two neighbour English-speaking countries!   It was such a relief and also stimulation to return to Canada and resume creative work and collaborations with our many talented artists and performers.  Once the opportunity to write a new work is given to an eager composer, it is then up to him / her to create a work so universal that will also be of interest to performers and audiences in other lands and cultures.  I've always found it fascinating to observe the reactions of audiences to a piece like *All Around the Circle* in places as different as Denmark, England or the United States.  For me it shows the power of words and music to communicate nuances of a cultural identity more directly and efficiently than most other genres or mediums.  But whoever choses to perform a work like this must at least strive to "become Canadian" for the length of the performance! 

## How do young companies benefit from working directly with composers?

**JO**: We have had the great pleasure of working on *Greeriad* with John Greer, and with [Neil Weisensel](https://nweisensel.wordpress.com/2017/02/25/greeriad-the-songs-of-john-greer/) (on his opera *Gisela in her Bathtub*) last season.  How lucky are we that these two composers are from Manitoba?!  This relationship can be amazing and a huge boost to young companies.  Our experience has been that their generosity has been immense and we are so grateful for that.  You can gain a lot of insight into their process and they are often so willing to work with you. They can offer you information about the work you won't find in the score.  

## How did you choose the selections for *Greeriad*?

**JG**: The *Greeriad*  program was chosen by (artistic directors) Dawn and Judy.   (They will be able to give you the particular details, as I don’t even know them myself!)  I merely left a complete repertoire list with Judith and made a suggestion that if they wanted to entice fine soloists to the program to sing some of the vocal quartets, they should also consider assigning solos to each member of the quartet with as much variety as possible: men's songs and women's songs, songs for high voices and low.  I knew that Judith and Dawn would know their singers well and would pick songs that would show them off to best advantage.  This was accomplished to the king's taste in this particular program!   Had I planned the program myself, I probably would have made it a little more serious and "arty".  But the inclusion of many of my fun and accessible arrangements of more well-known tunes balanced the program beautiful and ended up showing off the full versatile scope of each singer.

**JO**: This was difficult.  We had some pieces we knew we would include such as *Sarah Binks* and *All Around the Circle*.  As John mentioned, we started with a list of all his works where we learned of more works than we knew!  We were interested with repertoire that incorporated folk music and uniquely Canadian stories. We also wanted all the texts to be compelling. There was a lot of fun and funny repertoire on this program which is certainly a reflection of our personalities as artistic directors.  

The biggest challenge was that we offered selections from several song cycles.  We needed them to make sense to the listeners despite the missing songs.  We gave a lot of thought to each singer's strengths as we selected repertoire.   I think we succeeded on both accounts. 

## What does it mean to you for your music to be presented around Manitoba, by a Manitoba-based company?

**JG**: I am more grateful than I can say for opportunities such as the Flipside *Greeriad*, to see my songs performed by artists who understand them from the inside out and who can pass their full message on to an empathetic audience.  I am on the Board of Directors for the [Canadian Art Song Project](/scene/companies/canadian-art-song-project/), a nation-wide organization dedicated to the promotion of new Canadian vocal music.  I realize from this central standpoint how regionalized artistic expression is or can be.  

Sheer distance isolates central Canada from the coasts and the north.  There is a feeling of unity and solidarity amongst those dedicated to prairie life that, to my way of thinking, is not unlike the sort of pioneer spirit that brought our ancestors to Canada in the first place.  (My mother's parents immigrated here from Scotland, so even though the Prairies are settled now, the process itself continues.)  Populations don't choose a place to live unless they are happy there, and I find the residents of the Prairies at least as proud of and as dedicated to their chosen neighbourhoods as Canadians from any other quarter.  For some of us, such as myself, we don't fully realize how much we are Prairie children until we leave to live and work elsewhere.  

All of these feelings can be captured and communicated in song, if the venue and dedicated performers are there to do the communicating.  And the audiences will come!    

