+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = "2018-09-27T12:40:00-04:00"
lastmod = "2018-09-28T08:48:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538079908375/sqRenee_Fleming_-_Poemes_3_cropped_-_credit_Andrew_Eccles_Decca.jpg.jpg"
primary_image_credit = "Photo: Decca/Andrew Eccles."
publishDate = "2018-09-28T08:48:00-04:00"
related_articles = ["articles/piotr-beczala.md","articles/in-review-der-rosenkavalier-at-roh.md"]
related_people = ["scene/people/renee-fleming.md"]
short_description = "When soprano Renée Fleming offers a concert without any operatic repertoire, you wonder what the &quot;People&#039;s Diva&quot; will sing. Not surprisingly, in front of a capacity crowd, Fleming delivered with luscious morsels of her career after opera."
slug = "fleming-enchants-luscious-morsels-of-postopera-career"
title = "Fleming enchants: luscious morsels of post-opera career"
+++

She's graced opera stages around the world and is perhaps one of the most recognized classical singers of our generation.

So when soprano Renée Fleming offers a concert without any operatic repertoire, you wonder what the "People's Diva" will sing. Not surprisingly, in front of a capacity crowd, Fleming delivered with luscious morsels of her career after opera.

The first half of the program featured works of Richard Strauss. Perhaps in a nod to one of Fleming's signature opera roles, the Calgary Philharmonic Orchestra kicked off the evening with the orchestral suite of *Der Rosenkavalier*. Fleming retired the role of the worldly princess Marschallin with the Metropolitan Opera in April 2017 to critical acclaim.

Fleming then walked on stage, dressed in a fuschia gown, to offer Strauss' collection of the *Four Last Songs*. The collection, completed in 1948, reflects the composer's sense of calm and peace with his impending death. In the first two songs, "Spring" and "September", the lushness of Strauss' orchestration overshadowed Fleming at times. However, in the song "When Falling Asleep", Fleming truly took flight, her clear, supple voice ever vibrant and flowing above the orchestra. Her final words of the first half, "Is this perhaps Death?", foreshadow the new direction in which Fleming has taken her voice and career.

For the second half, Fleming offered selections from two new worlds for her singing: film soundtracks and musical theatre. Her first set included songs she recorded for films: Licinio Refice's *Ombra di Nube* (featured in the 2018 hostage drama *Bel Canto*), Friedrich von Flotow's "Tis the last rose of summer" from the opera *Martha* (featured in the 2017 crime drama *Three Billboards Outside Ebbing, Missouri*), and "You'll Never Know" by Alexandre Desplat (featured in the 2017 Academy award-winning film *The Shape of Water*). In this set of film music, the audience was treated to Fleming's lower register, which boasts a richness and a depth that she rarely (if ever) used to such a degree on the operatic stage. Her jazzy performance of "You'll Never Know" featured a flugelhorn solo by none other than Maestro Rune Bergmann himself, a welcome surprise for the capacity crowd in the concert hall and watching on the orchestra's live stream. Of note, to show off this new timbre, Fleming elected to use a microphone for this half of the concert.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538079924003/Renee_Fleming_pc_Andrew_Eccles_Decca_c_300dpi_edit.jpg.jpg)
<figcaption>Photo: Decca/Andrew Eccles.</figcaption>
</figure>

Fleming's final set included selections from the musical theatre songbook, including "Til There Was You" from *The Music Man*, a medley of "Love and Love Alone" and "Winter" from *The Visit*, "August Winds" from *The Last Ship*, and "The Glamorous Life" from *A Little Night Music*. As in the previous set of film music, the audience heard Fleming sing with her rich, lower register, but the demands of Stephen Sondheim had her return to her operatic technique to handle the demands of "The Glamorous Life". As Fleming stated, the works of Rodgers and Hammerstein and Sondheim have become classical, having stood the test of time for so many years.

Of course, following such a varied program, the audience wasn't ready to let the famed soprano go just yet, and Fleming naturally had a few encores prepared. The first was a stirring rendition of the well-known Irish ballad *Danny Boy*, a song she performed recently at the funeral of US Senator John McCain. Now with the Calgary Philharmonic Orchestra at the ready instead of the five-person chamber ensemble at the McCain funeral, Fleming sang with a calm serenity that reminded us of Strauss' *Four Last Songs* from earlier in the evening.

Her second encore, a sing-along version of "I Could Have Danced All Night" from the musical *My Fair Lady*, seemed to be a brief respite as she prepared for her true encore, the well-known operatic aria "O mio babbino caro" from Puccini's *Gianni Schicchi*. For this final number, Fleming put the microphone away, allowing her silvery soprano to soar with freedom and vitality. It was with this final number that the audience leapt to its feet, knowing they had witnessed a truly special performance.
