+++
author = ["authors/frank-pesci.md"]
categories = "Op-ed"
date = "2017-05-10T14:47:00-06:00"
lastmod = "2017-06-25T10:15:00-06:00"
preamble = "This is an essay originally published on [*New Music Box*](http://www.newmusicbox.org/articles/a-fine-mess-an-emerging-opera-composer-vs-the-american-new-opera-machine/), re-posted here with permission from the author."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1494450726593/2017-05-11---Puzzle.jpg.jpg"
publishDate = "2017-05-12T10:22:00-06:00"
related_articles = ["articles/the-future-of-opera-is-indie.md","articles/preparing-for-performance-what-i-didnt-know-i-knew.md","articles/the-big-and-everpresent-whats-next.md"]
related_companies = ["scene/companies/fort-worth-opera.md"]
short_description = "I soon learned that cold-shopping an out-of-the-box stage work is a thorny, if not downright impossible, proposition.  In the autumn of 2015, I reached out to roughly 200 small- to medium-sized American opera companies. In a 100-word email, I introduced myself and asked for a five-to-ten-minute phone conversation about trends in the commissioning and production of new opera (a subject that obviously interested me but was benign enough for an initial discussion)."
slug = "fine-mess-composer-new-opera"
title = "A fine mess: an emerging opera composer vs. the American new opera machine"
+++

By the time you read this, I will be nearing the culmination of Fort Worth Opera's ["Frontiers"](http://www.fwopera.org/operas/frontiers/) showcase — a major step into the American new opera scene for an emerging composer. In these essays, I intend to chronicle my experience preparing for, and participating in, this opportunity. As a point of entry, I’ll detail how I got myself into this mess to begin with.

I live with opera, literally.  I regularly perform as an opera chorus member and supernumerary, I'm married to a coloratura soprano whose career has led us to a European address, and opera takes up the vast majority of my current workload. I was led to embrace the art form by my father, who unwittingly instilled in me what would become the two pillars of my musical aesthetic—jazz and opera. He was a "dance band" bass player in his New Jersey youth who later became the middle-aged man sitting in his recliner and sobbing along with *La Bohème* during the Met radio broadcast. He took me to my first opera — *Carmen*, presented by the now-defunct company in Baltimore — where an old man directly behind me mercilessly booed the Toreador, planting the seed of my fascination with music for the stage and the effect it could have on those listening.

After college, I laid out a ten-year plan to develop the skills I thought I needed to write opera.  Beginning with the voice, I wrote and sang choral music and art song, learning how singers thought and operated (no small feat). Next, I worked my way from solo instrumental pieces to chamber music to full orchestra, settings songs for voice and chamber instrumentation and simulating Puccini arias and duets along the way.

About six years into this project came an opportunity. Axe 2 Ice Productions was an alternative theater troupe in Boston whose mainstay was Bent Wit Cabaret, a monthly mashup of burlesque, spoken word, performance art, musical numbers, and other oddities.  The music director, a colleague of mine, asked if I would write a seven-minute opera for a "mystery" themed show.  Of course I said, "Yes! What could possibly go wrong?" and quickly settled on Edgar Allan Poe's story, "The System of Dr. Tarr and Prof. Fether," with its maniacal asylum proprietor, a melodramatic sense of foreboding, a slew of fantastic side characters, and an unpredictable — yet inevitable — climax that could only have come out of the mind of Poe.

Time being very short, I surgically cut away at Poe's original text, coalescing the action into a single scene with a brief introduction and afterword.  The original version came to 15 minutes with piano accompaniment.  I trimmed it down to around 8 minutes for Bent Wit and scored it for their house band.  A year later, Boston Opera Collaborative presented the original 15-minute version on a program that was aptly titled "Opera Goes to Hell." Three years later, I expanded the work in order to realize a more complete adaptation of Poe's story, resulting in a three-act, 90-minute piano/vocal score.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1494449557906/OperKoelnNeuenStaatenhaus.jpg.jpg)<figcaption>the Opera Köln Neuen Staatenhaus. Photo: Frank Pesci.</figcaption>
</figure>

## Good for me…now what?

I soon learned that cold-shopping an out-of-the-box stage work is a thorny, if not downright impossible, proposition.  In the autumn of 2015, I reached out to roughly 200 small- to medium-sized American opera companies. In a 100-word email, I introduced myself and asked for a five-to-ten-minute phone conversation about trends in the commissioning and production of new opera (a subject that obviously interested me but was benign enough for an initial discussion). I received about 40 responses and eventually spoke with representatives of around 20 companies. My lone question was: "What conditions would need to be in place for your company to consider commissioning a new work, or producing a recently composed work?"

Along with the wealth of information I received on a wide range of topics — including the desire to produce new works in line with the needs and wants of the constituency, the lack of new female roles, the challenges of the heavy subject matter of many new works, and the industry-wide discussions surrounding successfully raising funds for commission — it was said in almost every conversation that relationships are paramount to developing new works. None of the companies I spoke with would consider premiering a completed opera from a composer with whom they had no relationship, and most would opt for the chance to build a project from the ground up.

Sidebar: In my experience over the last four years working in German opera houses, it appears that many of the same rules apply for a composer trying to break in, particularly the development of a relationship with administrators to foster a work that resonates with the particular audience of the commissioning house. Beyond that, the opera culture—not to mention the new opera scene—is rather different from that of the USA in a number of ways. Germany is, for better or worse, a bit of an opera bubble. Its undeniable opera tradition can weigh heavily on itself (sometimes to the point of ignoring the obvious contributions of other cultures), but it's generally not afraid to take risks in presenting new works or new concept-driven adaptations of the repertoire. This is simply part of their opera culture, and they have developed an audience for it. On the other hand, the interest in new works in Germany still favors very dense, difficult, and abstract composition (in some ways, the train never left Darmstadt), and newly commissioned works from non-Germans have been extremely rare. One thing in my favor, however, is that Germans love competition winners, and mentioning my being selected for the Frontiers showcase at Fort Worth Opera has given me a few second chances already.

One of my calls in 2015 was to Darren K. Woods (the then-General Director of Fort Worth Opera) who encouraged me to apply to Frontiers, which is one of the few new opera development programs with an unrestricted public submission process. This in and of itself is at the heart of the struggle I have felt as an emerging opera composer: the need to be heard and venues in which to be heard (outside of a sheltering institution) are precious few but, in the course of my phone calls, I learned that being aggressive in attacking these opportunities doesn’t necessarily lead anywhere. Realistically, however, in no way are these opportunities a silver bullet. They are, at best, a chance to meet with decision makers in the field and to present my best work: that which, for me, demonstrates my understanding of the repertoire, of the voice, of dramaturgy, and of a sincere compositional aesthetic.

Seven years after the first phrases were written, I am enjoying the opportunity to work with singers and the music staff at Fort Worth to bring twenty minutes of my Poe opera to life. I am days away from the showcase and the opportunity to present my work and interact with decision makers from all over the country.

Next week: How did I prepare to present myself to the opera world? Or, "Does this tweed make me look like an opera composer?"
