+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-04-15T20:50:00-04:00"
lastmod = "2018-04-23T20:43:00-04:00"
preamble = "As [Heartbeat Opera](/scene/companies/heartbeat-opera/) gears up for its fourth annual [Spring Festival](http://www.heartbeatopera.org/spring-festival-2018/), Artistic Director Ethan Heard is in rehearsals for his poignant adaptation of Beethoven's only opera, [*Fidelio*](https://www.heartbeatopera.org/fidelio) (**May 3-13**). Heard has written new English dialogue with Marcus Scott to bring the story of political prisoners into 2018; Heartbeat Opera's production features a primarily black cast, and a true \"Prisoners' Chorus\" of incarcerated members of 6 prison choirs across the Midwest.\n\nWe spoke with Heard about his [*Fidelio*](https://www.heartbeatopera.org/fidelio), and the unique research he did on the opera's relevant themes.\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523839803758/sqEthanHeard.jpg.jpg"
primary_image_credit = "Ethan Heard, Co-Artistic Director of Heartbeat Opera and director of Fidelio, May 3-13 at Baruch Performing Arts Center."
publishDate = "2018-04-23T20:43:00-04:00"
related_articles = ["articles/real-prisoners-voices-make-heartbeat-operas-fidelio-resonate.md"]
related_companies = ["scene/companies/heartbeat-opera.md"]
short_description = "&quot;I hope people who know Fidelio already will be surprised and challenged to experience the opera in a new way. I hope newcomers to Fidelio will come away with admiration for Beethoven&#039;s beautiful music and appreciation of this story&#039;s powerful resonance today. I hope all audience members will take away questions and concerns that they continue to talk about and wrestle with.&quot;"
slug = "fidelio-still-political-in-2018"
title = "Fidelio: still political in 2018"
+++

## What about *Fidelio* did you see as adaptable and relevant to a contemporary story and new texts?

In choosing a project to direct this season, I wanted to find a piece that could come to life in a visceral and politically meaningful way in 2018. Beethoven's *Fidelio* jumped out to me as the story of a woman who disguises herself to infiltrate the prison where she believes her husband has been wrongfully incarcerated. 

I started imagining what the 2018 American version of this story looks and sounds like. A corrupt leader wishes to discredit and silence his opponents - sound familiar? I also started reading about our criminal justice system and the epidemic of mass incarceration. Ultimately, we decided our new adaptation, featuring new English dialogue, would make Stan (formerly Florestan) a Black Lives Matter activist. His wife Leah (formerly Leonore) would disguise herself as Leo (formerly Fidelio) to seek employment at the prison.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523839396204/FidelioCompanyFirstDay.jpg.jpg)
<figcaption>The *Fidelio* company on the first day of rehearsals.</figcaption>
</figure>
 
### Can you tell us about your project to feature 6 prison choirs in a special recording of Beethoven's Prisoners' Chorus? What did you learn from the experience?

Heartbeat makes essentialized productions for intimate venues. We knew we had to find a creative way to [bring Beethoven's famous Prisoners' Chorus to life](https://www.press-citizen.com/story/news/education/university-of-iowa/2018/03/21/oakdale-iowa-prison-choir-new-york-opera-heartbeat-opera/445862002/). We wondered if we could find a way to bring the voices of real incarcerated people "into the room." 

Dan [Schlosberg, our Music Director,] knew Amanda Weber, a conductor of a prison choir called Voices of Hope in Minnesota. We reached out to her to see what might be possible. Amanda was enthusiastic about getting involved, and soon, we had connected with three other conductors - and five more choirs - in Iowa, Kansas, and Ohio. Dan made a new SATB arrangement of the chorus and assigned a chunk of the song to each choir. The choirs will record the audio for their segment, and our sound designer will stitch the recordings together. Our live band will accompany the audio track in performance. Dan and I visited four of the choirs March 20-25 and captured video footage, which will be edited into a montage to be projected during the performance as well.

Dan and I had never visited a prison before March 20. Upon entering the Oakdale Prison in Iowa, my understanding of what it means to be incarcerated began to shift and deepen. I met men - young and old - who had been in prison for many years. I began to wonder about the purpose of their sentences. I was profoundly impressed by the choir rehearsals and how music-making brought inmates and volunteers together in a healing and uplifting creative process. I left thinking about freedom in a new and more grateful way.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523839404374/HeartbeatOperaFidelio.jpg.jpg)
<figcaption>Ethan Heard and Music Director Daniel Schlosberg, visiting the choir directors correctional facilities. Clockwise from top: Kirk Carson/Arts In Prison, KS; Catherine Roma, Warren Correctional Institute, OH; Mary Cohen/Oakdale Community Choir, IA.</figcaption>
</figure>

## How do you think Beethoven's political ideals would translate into the American climate today?

I hope we will see and hear Beethoven's political ideals through this production! 

## What do you hope audiences will take away from your adapted *Fidelio*?

I hope people who know *Fidelio* already will be surprised and challenged to experience the opera in a new way. I hope newcomers to *Fidelio* will come away with admiration for Beethoven's beautiful music and appreciation of this story's powerful resonance today. I hope all audience members will take away questions and concerns that they continue to talk about and wrestle with.

>[*Fidelio*](https://www.heartbeatopera.org/fidelio) runs May 3-13 at the Baruch Performing Arts Center, 55 Lexington Avenue, NYC. For details and ticket information, [click here.](https://www.heartbeatopera.org/fidelio)
