+++
author = ["authors/melissa-ratcliff.md"]
categories = "Review"
date = "2018-10-15T10:59:00-04:00"
lastmod = "2018-10-15T20:52:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539636257180/sqFidelio_0643.jpg.jpg"
primary_image_credit = "Brent Turner (Florestan) and Aviva Fortunata (Leonore/Fidelio) in Pacific Opera Victoria's production of Fidelio, 2018. Photo: Emily Cooper."
publishDate = "2018-10-15T20:52:00-04:00"
related_companies = ["scene/companies/pacific-opera-victoria.md"]
related_people = ["scene/people/aviva-fortunata.md","scene/people/peter-mcgillivray.md","scene/people/owen-mccausland.md","scene/people/miriam-khalil.md","scene/people/brent-reilly-turner.md"]
short_description = "In fact, this whole production makes reference to human rights abuses across the world; projected background images include those of Colombian mothers protesting the army-sponsored murder of their sons, to Goya&#039;s painting &quot;The Third of May&quot;, a depiction of the execution of unarmed soldiers. This production misses no opportunity to shine a light on the corruption of power, and the resultant loss of human rights."
slug = "fidelio-as-a-mirror-of-human-rights"
title = "Fidelio as a mirror of human rights"
+++

[Pacific Opera Victoria](/scene/people/pacific-opera-victoria/)'s season opener is [Beethoven's *Fidelio*](https://www.pov.bc.ca/fidelio.html) - a production that POV has only tackled once in its history. In this modernized version, the action takes place in a setting vaguely reminiscent of a South American dictatorship of the 1960/70s, with the heroine  Leonore joining a resistance faction in an attempt to free her husband, a political prisoner being held without trial.

The set is a raked stage at stark angles in what is made to look like a platform of compressed shoes. In fact, shoes come into play several more times in the show, whether dropped from the ceiling or shoveled from a grave. The empty shoes appear to symbolize the victims "disappeared" by this corrupt government, recalling both the recent empty shoe protests of France and the USA, and the mounds of empty shoes discovered at the liberation of Auschwitz in 1945.

In fact, this whole production makes reference to human rights abuses across the world; projected background images include those of Colombian mothers protesting the army-sponsored murder of their sons, to Goya's painting "The Third of May", a depiction of the execution of unarmed soldiers. This production misses no opportunity to shine a light on the corruption of power, and the resultant loss of human rights.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539636525779/Fidelio_0352.jpg.jpg)
<figcaption>Aviva Fortunata (Leonore/Fidelio) and the Pacific Opera Victoria Chorus in Pacific Opera Victoria's production of *Fidelio*, 2018. Photo: Emily Cooper.</figcaption>
</figure>

Soprano [Aviva Fortunata](/scene/people/aviva-fortunata/) played the title role of Fidelio/Leonore, and brought a great deal of sensitivity to a difficult role. Her voice was clear and pristine, and rang effortlessly to the back of the hall. 

In this version, Marzelline (Miriam Khalil) and Jaquino (Owen McCausland) help Leonore disguise herself as the boy Fidelio, and are part of the resistance movement to get her into the prison (acted out in mime during the overture). It's an unusual take on the backstory, and unfortunately makes it harder to believe Marzelline's profession of love and eagerness to marry the "boy" Fidelio, as she would know it's Leonore in disguise. 

Bass Valerian Ruminski as Rocco really came into his stride in Act II, shining brilliantly in the trio, and his conflict about whether or not to follow his orders to aid in killing Florestan was very emotional and convincing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539636373177/Fidelio_0599.jpg.jpg)
<figcaption>Brent Turner (Florestan) and Aviva Fortunata (Leonore/Fidelio) in Pacific Opera Victoria's production of *Fidelio*, 2018. Photo: Emily Cooper.</figcaption>
</figure>

Baritone [Peter McGillivray](/scene/people/peter-mcgillivray/) as Pizarro portrayed his character's pettiness and cruelty with aplomb. He conveyed villainy rooted in pure selfishness, and affected the cowardice and cruelty of the jailer so well that he was met with a rousing chorus of boos at the curtain call - well-deserved and for all the right reasons!

Tenor [Brent Reilly Turner](/scene/people/brent-reilly-turner/) was a force of nature as Florestan. Remarkably strong and dynamic in vocal performance, his moment in prison of chasing a single beam of light across his cell was heartbreaking.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539636385317/Fidelio_0266.jpg.jpg)
<figcaption>Peter McGillivray (Don Pizarro) in Pacific Opera Victoria's production of *Fidelio*, 2018. Photo: Emily Cooper.</figcaption>
</figure>

The POV Chorus, portraying prisoners let out to their prison yard for a small moment of sunshine,  were artfully bleak and unsettling. Recoiling from touch, light, and the slightest threat of punishment, they effectively communicated a profound sense of hopelessness. With acting skills matched by their formidable vocal performance, the Chorus conveyed the pathos of the prisoners' lot movingly. 

Much of the setting of *Fidelio* was created through projections, thanks to Projection Designer Monica Hernandez. With subtle pieces of animation, the projections were effective at giving the feeling of imprisonment and gloom throughout. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539636441411/Fidelio_0434.jpg.jpg)
<figcaption>Aviva Fortunata (Leonore/Fidelio); Brent Turner (Florestan); Owen McCausland (Jaquino); Miriam Khalil (Marzelline); Neil Craighead (Don Fernando); Valerian Ruminski (Rocco) in Pacific Opera Victoria's production of *Fidelio*, 2018. Photo: Emily Cooper.</figcaption>
</figure>

The final scene, when all the characters are reunited, was hugely powerful. The singers and orchestra united in full force for a dynamic ending that inspired a profound sense of rekindled hope. Again, the Chorus might be especially worthy of praise here, with a young back-of-the-stage chorus couple's tearful reunion at the beginning of the finale so convincingly heartfelt and genuine.  

>Pacific Opera Victoria's production of *Fidelio* runs through October 21. For details and ticket information, [click here.](https://www.pov.bc.ca/fidelio.html)
