+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = "2019-03-18T21:58:51+00:00"
disclaimer = ""
image_gallery = []
postamble = "Florida Grand Opera's production of _Frida_ runs through March 30. For details and tickets, [click here](https://tickets.fgo.org/Tickets/EventDetails.aspx?id=1718)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1552948764/media/2019/03/sqDSC_2080.jpg"
primary_image_credit = "Catalina Cuervo in the title role of Frida, Florida Grand Opera, 2019. Photo: Chris Kakol."
related_articles = ["articles/florencia-en-el-amazonas.md", "articles/in-review-cosi-fan-tutte-at-roh.md"]
related_companies = ["scene/companies/florida-grand-opera.md"]
related_people = ["scene/people/jessica-e-jones.md", "scene/people/zaray-rodriguez.md", "scene/people/catalina-cuervo.md"]
short_description = "Frida Kahlo was Mexican, an artist, a woman, disabled, queer, Communist. Though the pacing of the opera was choppy and piecemeal, resembling a biopic in its sweeping depiction of her teenage romance, her life-altering bus accident, her revolutionary politics, and her turbulent marriage, the format was well suited to highlight the many intersecting facets of Kahlo's complex and richly lived biography."
slug = "appropriately-strange-frida-at-fgo"
title = "Appropriately strange: Frida at FGO"
youtube_url = ""

+++
A screeching chorus of monkeys, a lesson in Mexican political history, an ode to menstruation, a Broadway showtune about eyebrows. To call Florida Grand Opera's production of _Frida_ "eclectic" would be like calling Frida Kahlo's life "unusual" – the understatement of the century.

Performed at the Miramar Cultural Centre, a midsize community arts venue a far cry from the grand stage of FGO's usual home in downtown Miami, _Frida_ was presented with community outreach in mind. Before the show, guests were greeted by an outdoor performance from Ballet Folklorico Ameyal, a Miami-based Mexican folk music and dance ensemble who later made a delightful onstage cameo as wedding merrymakers. Later, exiting after curtain call, audience members were handed a carnation as they walked out the door.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552954769/media/2019/03/DSC_1401.jpg){{% /md %}}

<figcaption>A scene from Frida, Florida Grand Opera, 2019. Photo: Chris Kakol.</figcaption>

</figure>

The subject of the opera – the life of an icon whose activism, as much as her artwork, have taken on a surging fan base in contemporary popular culture – paired with composer Robert Xavier Rodriguez's playful, pop-aware pastiche and librettists Hilary Belcher and Migdalia Cruz's unabashed forays into foul-mouthed Spanglish – a South Florida hallmark – made _Frida_ an ideal choice to present to an audience outside of an operatic comfort zone.

> Cuervo's glimmering operatic voice was joined by a rich musical theatre timbre and by her melodious speaking voice.

Besides, _Frida_ itself threw any notion of comfort zone out the window, defying categorization into any one genre just as Kahlo could not be pinned into any single category or identity. Operatic arias melted into mariachi; philosophical spoken monologues preceded gaudy ensemble numbers set to cheesy rhymes – upon Kahlo's arrival in New York, a gaggle of affluent partygoers, caricatures of American capitalism, chanted, "The people here are happy / As happy as can be!"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552954789/media/2019/03/DSC_1499.jpg){{% /md %}}

<figcaption>A scene from Frida, Florida Grand Opera, 2019. Photo: Chris Kakol.</figcaption>

</figure>

Frida Kahlo was Mexican, an artist, a woman, disabled, queer, Communist. Though the pacing of the opera was choppy and piecemeal, resembling a biopic in its sweeping depiction of her teenage romance, her life-altering bus accident, her revolutionary politics, and her turbulent marriage, the format was well suited to highlight the many intersecting facets of Kahlo's complex and richly lived biography. In the title role, soprano [Catalina Cuervo](/scene/people/catalina-cuervo/) brought charisma, wit, and captivating musicality to a score that demanded a broad vocal range in twisting melodies that at times thwarted tonality. Cuervo's glimmering operatic voice was joined by a rich musical theatre timbre and by her melodious speaking voice, which brought gravitas and passion to monologues that might otherwise have come across as melodrama.

> Rodriguez's luminous and lurid score undulating as Frida bathed, naked, flanked by male and female lovers, her 1939 _What I Saw in the Water_ projected in the background.

As Kahlo's husband Diego Rivera, bass-baritone Ricardo Herrera sang strongly, keeping pace with the opera's mood swings from tender love songs to bouts of ego and marital tumult. His reunion with Kahlo and proposal to remarry in the final scene were especially memorable, as Herrera spun giddily across the stage, singing a folk song with silly lyrics to entertain his bedridden ex, with an earnest sweetness to his voice that had been missing from angrier moments in the score.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552954817/media/2019/03/DSC_1150.jpg){{% /md %}}

<figcaption>A scene from Frida, Florida Grand Opera, 2019. Photo: Chris Kakol.</figcaption>

</figure>

Young artists pulled double or even triple duty in supporting roles, with mezzo-soprano [Zaray Rodriguez](/scene/people/zaray-rodriguez/)'s moving turn as a grieving mother contrasting with her colourful appearances as drunk wedding crasher Lupe. Mezzo-soprano Mariya Kaganskaya excelled in the dual roles of haughty Mrs. Rockefeller and fed-up Natalia Trotsky, and soprano [Jessica E. Jones](/scene/people/jessica-e-jones/) as Kahlo's sister Cristina sang with a sweet voice and calm sensitivity.

> The most successful moments brought Kahlo's art to life in thoughtful and breathtaking ways.

Production design played a central role in the storytelling, with sets and costumes by Monika Essen, originally for Michigan Opera Theatre, drawing inspiration from the magical realism of Kahlo's art to create a jungle of oddities: an anatomical heart blossoming into a tree; an antlered ballerina seemingly sprung from Kahlo's 1946 _The Wounded Deer_; a trio of mariachis in _calavera_ masks, haunting Frida upon her multiple brushes with death.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552954841/media/2019/03/DSC_1756.jpg){{% /md %}}

<figcaption>A scene from Frida, Florida Grand Opera, 2019. Photo: Chris Kakol.</figcaption>

</figure>

The most successful moments brought Kahlo's art to life in thoughtful and breathtaking ways: tears silently falling, thanks to a bit of theatre magic, from the all-seeing eye of the fragmented self-portrait that formed the basis of the set; a grotesque maypole with bright red ribbons, violently torn apart to symbolize her miscarriage, inspired by her 1932 painting _Henry Ford Hospital_; Rodriguez's luminous and lurid score undulating as Frida bathed, naked, flanked by male and female lovers, her 1939 _What I Saw in the Water_ projected in the background.

> FGO's _Frida_ was a strange opera – fast-paced, touching, at times darkly comic, esoteric, pained, and colourful.

Meanwhile, some heavy-handed imagery challenged these moments of magic. A red-and-yellow hammer and sickle appeared on the projection screen at every mention of Communism; and a projected photo of Kahlo and Rivera's adjacent pink and blue houses, seemingly cut and pasted from Google Images, set the scene for the opening of Act II, underestimating the audience's imagination.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552954865/media/2019/03/DSC_2566.jpg){{% /md %}}

<figcaption>A scene from Frida, Florida Grand Opera, 2019. Photo: Chris Kakol.</figcaption>

</figure>

Rodriguez's score was gripping, though every spoken monologue felt like a missed opportunity for a true opera "moment"; the work cruised along without a showstopping aria or heart-wrenching musical climax. Led by conductor Roberto Kalb, the chamber-sized orchestra, augmented by accordion, saxophone, and guitar, brought colour and rhythm to the folk-inspired melodies, and lent drama to the opera's darkest scenes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552954915/media/2019/03/DSC_3042.jpg){{% /md %}}

<figcaption>Catalina Cuervo in the title role of Frida, Florida Grand Opera, 2019. Photo: Chris Kakol.</figcaption>

</figure>

FGO's _Frida_ was a strange opera – fast-paced, touching, at times darkly comic, esoteric, pained, and colourful. Appropriate, then, that director Marco Pelle ended his program note with a quote from Kahlo herself: "There are so many people in the world, there must be someone just like me who feels bizarre and flawed in the same ways I do \[...\] Well, I hope that if you are out there and read this and know that, yes, it's true I'm here, and I'm just as strange as you."