+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = "2019-01-28T15:08:38+00:00"
disclaimer = ""
image_gallery = []
postamble = "_Le nozze di Figaro_ runs at Florida Grand Opera though February 9. For details, [click here](https://tickets.fgo.org/Tickets/EventDetails.aspx?id=1715)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1548726003/media/2019/01/sqFGODSC_5232.jpg"
primary_image_credit = "Le nozze di Figaro, Florida Grand Opera, 2019. Photo: Chris Kakol."
related_articles = ["articles/a-luminous-lucia-at-florida-grand-opera.md"]
related_companies = ["scene/companies/florida-grand-opera.md"]
related_people = ["scene/people/calvin-griffin.md", "scene/people/elena-galván.md", "scene/people/lyubov-petrova.md", "scene/people/jonathan-michie.md"]
short_description = "Florida Grand Opera's Le nozze di Figaro, which opened on January 26 at the Adrienne Arsht Centre in Miami, took an uncharacteristically introspective look at this iconic comedic favourite, in a production that asked all the right questions, but sacrificed some laughs along the way."
slug = "the-women-rule-in-fgos-figaro"
title = "The women rule in FGO's Figaro"
youtube_url = ""

+++
Figaro thinks he's got it made. The Count has granted him and his fiancée the finest servants' quarters in the entire Almaviva estate, conveniently adjacent to the bedroom of the Count and Countess themselves. "Show me a better room," Figaro challenges his bride-to-be.

All too often subjected to the Count's unwanted advances, and terrified by the thought of living next door to her harasser, Susanna balks at her supposed ally's failure to recognize the nefarious reason behind the Count's seeming generosity. Hands on her hips, she chides, "I am Susanna, and you are a fool!"

Predictably, Figaro doesn't believe her.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548725276/media/2019/01/FGODSC_6119.jpg){{% /md %}}

<figcaption>Le nozze di Figaro, Florida Grand Opera, 2019. Photo: Chris Kakol.</figcaption>

</figure>

[Florida Grand Opera](/scene/companies/florida-grand-opera/)'s _Le nozze di Figaro_, which opened on January 26 at the Adrienne Arsht Centre in Miami, took an uncharacteristically introspective look at this iconic comedic favourite, in a production that asked all the right questions, but sacrificed some laughs along the way.

Bass-baritone [Calvin Griffin](/scene/people/calvin-griffin/) sang a guileful and steady Figaro opposite [Elena Galván](/scene/people/elena-galvan/)'s clear and glimmering soprano. As Susanna, Galván was sharp and savvy, standing firm against the Count and offering perceptive, quick-witted asides as the wedding-day chaos unfolded. Galván seemed to have fun in her role, with a compelling lightness and organic ease in both her acting and singing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548728162/media/2019/01/FGODSC_1182.jpg){{% /md %}}

<figcaption>Le nozze di Figaro, Florida Grand Opera, 2019. Photo: Chris Kakol.</figcaption>

</figure>

In a musical highlight of the evening, soprano [Lyubov Petrova](/scene/people/lyubov-petrova/)'s Countess balanced a dolce upper range and thoughtful musicality with effusive regality and confidence. Petrova's "Dove sono" melted into breathtaking diminuendi, while her triumphant pause in response to the unfaithful Count's pleas for forgiveness captured a commanding presence and deft comic pacing – even without singing a single note, Petrova caught some of the show's biggest laughs.

> "Are we squeezing all the fun out of the opera by even asking these questions?"

Bass Simon Dyer nailed gardener Antonio’s drunken antics, while tenor Dylan Morrongiello's strongly acted Don Basilio was worthy of a spinoff appearance guest-hosting _E! News_, and soprano Evan Kardon's Barbarina was sung with splendid tone and a healthy dose of sass. As Cherubino, mezzo-soprano Mariya Kaganskaya also sang resonantly, but struggled to hit punchlines. Likewise, mezzo-soprano Zaray Rodriguez as Marcellina and bass-baritone Rafael Porto as Doctor Bartolo captured odd-couple charm, but with downplayed humour.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548725367/media/2019/01/FGODSC_1392.jpg){{% /md %}}

<figcaption>Le nozze di Figaro, Florida Grand Opera, 2019. Photo: Chris Kakol.</figcaption>

</figure>

As a result, moments of overt comedy seemed out-of-place. The wedding party's [viral video-esque](https://www.youtube.com/watch?v=4-94JhLEiN0) entrance down the aisle felt awkward and slapstick, and Figaro's "Aprite un po' quegli occhi," while well sung, came across like tired, sexist stand-up at a brick wall club: "Women! Am I right?" Even accompanied by Mozart's high-octane score, punctuated by fluttering woodwind solos well played under conductor Andrew Bisantz, the production missed more than one comedic mark.

This subdued take on the ubiquitous classic comes from director Elise Sandell, returning to the Florida Grand Opera stage after a [luminous _Lucia di Lammermoor_](/a-luminous-lucia-at-florida-grand-opera/) last season. In her program note, Sandell emphasizes the challenges of staging an opera that banks its laugh lines on acts of attempted sexual assault. "How do we, a modern audience, reconcile this joyous romp of an opera \[...\] with what should be outrage at the Count's buffoon-ish attempts?" Sandell writes. "When does the joke cross the line to not be funny anymore?"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548725457/media/2019/01/FGODSC_8147.jpg){{% /md %}}

<figcaption>Le nozze di Figaro, Florida Grand Opera, 2019. Photo: Chris Kakol.</figcaption>

</figure>

Indeed, Count Almaviva crosses that line. Raffish and conniving, baritone [Jonathan Michie](/scene/people/jonathan-michie/) sang a stentorian Count oblivious to the toxicity and trauma he inflicts on the women in his life. He's the sort of man who, earlier this month, would have thrown out his Gillette razor in protest.

Mozart's opera leaves no room for doubt that the Count is the villain in this scheme. But just because the Count's crimes are met with comeuppance doesn't excuse the opera stage – and opera audiences – from looking with a critical eye at a long-beloved libretto in which serial acts of harassment and violence are intentionally imbued with humour, and ultimately absolved. As Sandell poses in her program note, "When the moment of truth comes at the end of the opera and it's up to the Countess to forgive the Count, should she? Should we?"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548725496/media/2019/01/FGODSC_1477.jpg){{% /md %}}

<figcaption>Le nozze di Figaro, Florida Grand Opera, 2019. Photo: Chris Kakol.</figcaption>

</figure>

Sandell's timely vision was mirrored by Susan Benson's set design, originally for Michigan Opera Theatre, elaborately painted yet muted and, at times, grim – lent depth and occasional gloom by lighting designer Helena Kuukka. Notably, almost the entire creative team were women, suggesting that this opera, when seen through a lens other than the hegemonic male gaze, has a not-so-funny message to impart.

In the end, it is the strength and persistence of the opera's women, and their support of one another, that brings the Count to his knees. It's fitting, then, that following three acts of humour falling flat, the biggest laugh of the evening came not from the Count's repeated EEOC violations, nor from Figaro's bumbling jealousy, nor from Cherubino's handsy hijinks – but rather from the victorious Countess, now in a position of power, pausing for a beat too long before answering her husband's pleas with an all-too-generous blessing of forgiveness.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548729232/media/2019/01/FGODSC_1591.jpg){{% /md %}}

<figcaption>Le nozze di Figaro, Florida Grand Opera, 2019. Photo: Chris Kakol.</figcaption>

</figure>

"Are we squeezing all the fun out of the opera by even asking these questions?" Sandell wonders in her program note. While this production had been squeezed of some – though not all – of its potential for fun, maybe it’s healthy to take a step back from the laughter and assess how this opera, performed by company after company, season after season, takes on new meaning in a cultural moment and a social movement. "Yes, opera can be \[an\] escape," Sandell asserts, "but no, we shouldn't ignore these questions, and we won't."