+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = 2019-11-21T05:00:00Z
discipline = ""
disclaimer = ""
image_gallery = []
postamble = "Florida Grand Opera's production of [_Don Giovanni_](https://tickets.fgo.org/Tickets/EventDetails.aspx?id=1881) is onstage through December 7."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1574351674/media/2019/11/20191114_Don_Giovanni_173A6470_mdrkmj.jpg"
primary_image_credit = "Florida Grand Opera's production of Don Giovanni, 2019. Photo: Daniel Azoulay."
related_articles = ["articles/in-review-tcherniakovs-don-giovanni.md", "articles/boc-s-don-giovanni-smart-and-relevant.md"]
related_companies = ["scene/companies/florida-grand-opera.md"]
related_people = ["scene/people/elizabeth-caballero.md"]
short_description = "The over-the-top, 50's-horror-movie vibes of the opera's finale? Go ahead and laugh (some in the audience did). But an aria cataloguing thousands of victims of rape; a rapist sharply calling a survivor of his violence \"You bitch!\" – we should feel uncomfortable laughing at these moments."
slug = "rightly-uncomfortable-fgos-don-giovanni"
social_media = []
title = "Rightly uncomfortable: FGO's Don Giovanni"
website = ""
youtube_url = ""

+++
_Content warning: Rape, sexual assault_

***

In their 2019-2020 season, [Florida Grand Opera](/scene/companies/florida-grand-opera/) boasts something few, if any, major opera companies can claim: every single production is to be helmed by a woman stage director. "This is \[a\] first in FGO's company history to have an entire season directed by women, telling these male-dominated stories from a woman's perspective," said Susan Danis, FGO's General Director, in a press release. On the season's opening night, November 16 at the Adrienne Arsht Center in Miami, it was clear that this [_Don Giovanni_](https://tickets.fgo.org/Tickets/EventDetails.aspx?id=1881) represented a shift in storytelling for the company, and for the opera itself.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574351579/media/2019/11/20191114_Don_Giovanni_173A2806_cafxyy.jpg){{% /md %}}

<figcaption>Florida Grand Opera's production of Don Giovanni, 2019. Photo: Daniel Azoulay.</figcaption>  
</figure>

Early on in director Mo Zhou's production, the title character – a dark and urgent turn by star baritone [Elliot Madore](/scene/people/elliot-madore/) – was shown to be a particularly chilling breed of villain. Swords clashing, the Commendatore disarmed the Don, his weapon falling to the ground. When the victorious Commendatore turned his back to his opponent and begins to sheath his sword, Giovanni lunged to stab him in the back with a concealed dagger. Still not satisfied, Giovanni then grabbed the fallen Commendatore by the neck and strangled him to death, watching the life drain from his eyes.

> Her change of heart toward the Don no longer felt like yet another helpless woman falling for Giovanni's old tricks.

Madore's Giovanni was, refreshingly, far from sympathetic. His portrayal was short-tempered and fueled by obsession, quick to raise an arm and threaten to strike Donna Elvira or hold Leporello at knifepoint. In her program note, Zhou emphasizes the opera's indisputable echoes of the current moment: "It is hard not to face _Don Giovanni_ without thinking about what has happened in the #MeToo movement." Yet, she maintained, the opera is, at its core, not really about Don Giovanni at all. "The story weaves together a journey of six people who seek justice \[and\] challenge the acquiescence of a status quo."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574351606/media/2019/11/20191114_Don_Giovanni_173A2951_suytqu.jpg){{% /md %}}

<figcaption></figcaption>  
</figure>

Set design by John Pascoe and lighting design by Nate Wheatley made for a grim, greyscale backdrop as Giovanni's evils unfolded. Meanwhile, colorful costuming from designer Ann Hould-Ward drew the eye toward the bonds that formed between the justice seekers who would ultimately prevail. During the masquerade trio, sung in stellar, snugly balanced harmonies in a highlight of the evening, Elvira, Anna, and Ottavio donned sparkling colored capes that, worn side by side, made the three protagonists appear unified and larger-than-life, ready to take on a real-life villain.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574351617/media/2019/11/20191114_Don_Giovanni_173A3150_dvdfgx.jpg){{% /md %}}

<figcaption>Florida Grand Opera's production of Don Giovanni, 2019. Photo: Daniel Azoulay.</figcaption>  
</figure>

Zhou's production successfully shone a spotlight on the inner lives of the women whose lives are uprooted by Giovanni's violence, greed, and rage. Donna Elvira, sung by soprano [Elizabeth Caballero](/scene/people/elizabeth-caballero/) with a sparkling tone and richly emotive range of color, was played as a resolute decrier of injustice rather than a jealous and vengeful ex. Her change of heart toward the Don (or, toward Leporello in disguise) no longer felt like yet another helpless woman falling for Giovanni's old tricks. Instead, Caballero sang an Elvira who, even through the most traumatic of circumstances, believed that anyone, even Don Giovanni, could change for the better: "He betrayed and abandoned me, but I would still forgive him."

Soprano Aslief Willmer's Zerlina was sarcastic and coy, sung with glowing color and exceptional artistry. This Zerlina was, in a way, Don Giovanni's mirror, lying to Masetto – a solid performance from baritone Michael Miller – manipulating him to keep their relationship intact. Yet, while Giovanni exerted his power free from punishment (leaving his disguised sidekick to catch the community's flak in his place), Zerlina was criticized, stalked, and assaulted. In the end, it was Zerlina who hastened Don Giovanni's demise, her cry for help summoning a coalition of survivors and allies demanding justice.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574351627/media/2019/11/20191114_Don_Giovanni_173A3341_fhccoz.jpg){{% /md %}}

<figcaption>Florida Grand Opera's production of Don Giovanni, 2019. Photo: Daniel Azoulay.</figcaption>  
</figure>

As Donna Anna, soprano Elizabeth de Trejo took on a sombre and raw portrayal, with a bright _dolce_ tone agilely navigating the darkness of her role. As she described the details of her attempted rape to Don Ottavio – a warm tone and thoughtful acting from tenor Nicholas Huff – terror tinged her recitative with a halting, earnest pace, gradually gaining momentum as the fearful memories of that night blended with a fierce mixture of resilience and rage.

> We should feel uncomfortable watching these moments on stage, period.

Yet, immediately following her graphic account, the scene transitioned into a bantering dialogue between Giovanni and Leporello (bass-baritone Federico De Michelis, resonantly sung). The audience took in a detailed testimony of harrowing trauma, then turned around and laughed alongside the man who had wrought it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574351651/media/2019/11/20191114_Don_Giovanni_173A4424_gkboj2.jpg){{% /md %}}

<figcaption>Florida Grand Opera's production of Don Giovanni, 2019. Photo: Daniel Azoulay.</figcaption>  
</figure>

This, perhaps, is the core challenge of _Don Giovanni_ – that even in the hands of a director who sees the villain for who he is, even in a production that offers no sympathy for a serial rapist and murderer (as no production should) – even then, the opera remains a comedy. Between Da Ponte's wordplay and Mozart's sizzling score, Leporello's antics and Zerlina's flightiness, the audience is left to laugh at punchlines around every corner.

The opera's inevitable hell scene ushered in an all-too-short appearance from some of the production's finest design elements: eerie, imaginative demons danced and writhed in front of a fiery red backdrop, ominously lit amid a tumble of fog. The Commendatore was a convincing statue brought to life, bolstered by make-up designer Sue Schaefer and bass Kevin Langan's stentorian performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574351663/media/2019/11/20191114_Don_Giovanni_173A4750_gjaoqk.jpg){{% /md %}}

<figcaption>Florida Grand Opera's production of Don Giovanni, 2019. Photo: Daniel Azoulay.</figcaption>  
</figure>

The over-the-top, 50s-horror-movie vibes of the opera's finale? Go ahead and laugh (some in the audience did). But an aria cataloguing thousands of victims of rape; a rapist sharply calling a survivor of his violence "You bitch!" – we should feel uncomfortable laughing at these moments.

We should feel uncomfortable watching these moments on stage, period.