+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2017-11-18T14:04:00-05:00"
lastmod = "2017-11-18T15:56:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511031727253/2017-11-18---square---171109_Hudson_Opera_MOUA-2181-1.jpg.jpg"
primary_image_credit = "Michaela Martens as Susan B. Anthony in The Mother of Us All, Hudson Hall, 2017. Photo: Matthew Placek."
publishDate = "2017-11-18T15:56:00-05:00"
related_articles = ["articles/rb-schlather-susan-b-anthony-connecting-opera-with-community.md","articles/david-hertzbergs-the-wake-world-a-strange-and-sexy-synergy.md"]
related_people = ["scene/people/rb-schlather.md","scene/people/robert-osborne.md","scene/people/marc-molomot.md","scene/people/dominic-armstrong.md","scene/people/nancy-allen-lundy.md","scene/people/michaela-martens.md"]
short_description = "Martens&#039; Susan B. Anthony grows more and more exhausted by the selfish idiocy of the men in power. She becomes a reluctant yet unstoppable hero, wearied by the immense task in front of her yet brimming with moral certitude."
slug = "feminist-truths-the-mother-of-us-all"
title = "Feminist truths: The Mother of Us All"
+++

Gertrude Stein predicted in her libretto for *The Mother of Us All* (music by Virgil Thomson) that the fight for women's equal rights and representation would extend beyond her lifetime. The opera's protagonist, the suffragette hero Susan B. Anthony, sung effortlessly by the captivating dramatic mezzo-soprano [Michaela Martens](/scene/people/michaela-martens/), persistently argues for feminist truths against a nation insistent on maintaining its patriarchal structure.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511032804347/2017-11-18---171109_Hudson_Opera_MOUA-2231.jpg.jpg)
<figcaption>*The Mother of Us All*, Hudson Hall, 2017. Photo: Matthew Placek.</figcaption>
</figure>
 
Anthony meets resistance from a slew of male characters. John Adams ([Marc Molomot](/scene/people/marc-molomot/)) is a horny, drooling sycophant chasing Constance Fletcher's (Amanda Boyd) skirt like a dog after a bone. By the end of the piece, he has objectified her into a blind, marble statue. Thaddeus Stevens (Christopher Johnstone) has a mansplaining arioso during which, after asserting nonsensical opinions, he decides that, though not everyone can do what one likes, he can and will. And so on, each man having his chance to undermine women's rights. Martens' Susan B. Anthony grows more and more exhausted by the selfish idiocy of the men in power. She becomes a reluctant yet unstoppable hero, wearied by the immense task in front of her yet brimming with moral certitude.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511032940054/2017-11-18---171108_Hudson_Opera_MOUA-692.jpg.jpg)
<figcaption>Teresa Buccholz in *The Mother of Us All*, Hudson Hall, 2017. Photo: Matthew Placek.</figcaption>
</figure>
 
Director [R.B. Schlather](/scene/people/rb-schlather/)'s minimal set amounted to two platforms on either side of the room's center. In the remarkable act one duet, Susan B. Anthony and Daniel Webster ([Robert Osborne](/scene/people/robert-osborne/)) each occupies one of the risers. Anthony addresses suffragette protesters while Webster kowtows to his fellow congressmen. Webster obfuscates obsequiously to avoid saying anything meaningful that might create political disadvantage. His melodies mope over sinking harmonies. Anthony speaks in unconstrained, bold truisms, her music lyrical and patriotic.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511032928700/2017-11-18---171109_Hudson_Opera_MOUA-2234.jpg.jpg)
<figcaption>*The Mother of Us All*, Hudson Hall, 2017. Photo: Matthew Placek.</figcaption>
</figure>
 
The most unattractive man in the piece is Jo the Loiterer ([Dominic Armstrong](/scene/people/dominic-armstrong/)). He feels entitled to success and power and gloms onto scapegoats on whom he can blame his inability to leverage his privilege. He is ashamed of his name yet furious when his fiancée Indiana Elliot will not take it. He manages to feel disenfranchised despite his unearned advantages.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511032916499/2017-11-18---171108_Hudson_Opera_MOUA-1153.jpg.jpg)
<figcaption>Robert Osborne in *The Mother of Us All*, Hudson Hall, 2017. Photo: Matthew Placek.</figcaption>
</figure>
 
He is also a surrogate for today's arm-chair feminists. This is one of the many deft characterizations in Stein's writing that Schlather and his actor's illuminate well. In a heartbreakingly sung monologue, Anthony asks if any of the men in government can be honest and admit outright they "will not vote my laws". Jo responds first. He proudly admits that he will not pass her laws. Thinking he has said the wrong thing, he equivocates and pledges support. Then he explains that neither position matters because he does not contribute in the law making process and has no vote to cast. He is an example of a man only willing to support women's causes when it requires nothing of him.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511032870730/2017-11-18---171108_Hudson_Opera_MOUA-1155.jpg.jpg)
<figcaption>Kent Smith in *The Mother of Us All*, Hudson Hall, 2017. Photo: Matthew Placek.</figcaption>
</figure>
 
Stein's signature repetitions and non-sensical phrases confound on the page, but in action, thrill. Her language is more behavioral than textual and achieves clarity when transmitted through bodies in action. Without the acoustic help of a domed stage, clear behavioral messages were vital. A lot of the sung text was indecipherable, but Schlather and his singers largely succeeded in crafting behavior than conveyed their message clearly. That said, it was a shame to miss the myriad subtleties of the language.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511032848042/2017-11-18---171109_Hudson_Opera_MOUA-1541.jpg.jpg)
<figcaption>Ella Loudon in *The Mother of Us All*, Hudson Hall, 2017. Photo: Matthew Placek.</figcaption>
</figure>

The production has other shortcomings. Schlather's concept for the characters of Gertrude Stein ([Nancy Allen Lundy](/scene/people/nancy-allen-lundy/)) and Virgil Thomson (Kent Smith) is confounding. An athletic, feminine, blond woman plays Stein. No justification emerges for this antithetical casting. With Thomson, there is no sense of the prickly, barb-witted personality for which the composer is known. The most egregious element is the pair's generic, flirtatious, hetero relationship deeply at odds with their historical identities.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511032838357/2017-11-18---171108_Hudson_Opera_MOUA-1037.jpg.jpg)
<figcaption>Nuiko Wadden and Michaela Martens in *The Mother of Us All*, Hudson Hall, 2017. Photo: Matthew Placek.</figcaption>
</figure>
 
The production ends with an anti-climactic staging that undermines its overall effectiveness. Susan B. Anthony's final speech asks what it means to maintain conviction against unimaginable opposition, and to persist knowing that the change you seek will not materialize in your lifetime. But the stage picture is bland. Susan B. Anthony leans against a wall for the entire aria as the cast slowly circles the play area. The audience roots for a triumph as the piece fizzles to its end.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511032815409/2017-11-18---171109_Hudson_Opera_MOUA-1982.jpg.jpg)
<figcaption>The cast of *The Mother of Us All*, Hudson Hall, 2017. Photo: Matthew Placek.</figcaption>
</figure>
