+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2019-11-15T05:00:00Z
discipline = ""
disclaimer = ""
image_gallery = []
postamble = "Boston Lyric Opera's production of [_Fellow Travelers_](https://blo.org/fellow-travelers/) is onstage through November 17."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1573843051/media/2019/11/sqBLO2019-FellowTravelers-5128_kmt0gr.jpg"
primary_image_credit = "(l-r) Jesse Blumberg (Fuller), Simon Dyer, and David McFerrin (Interrogators) in Fellow Travelers, Boston Lyric Opera, 2019. Photo: Liza Voll."
related_articles = ["articles/schoenberg-in-hollywood-a-heap-of-excess.md", "articles/fellow-travelers-is-luminous-in-chicago.md"]
related_companies = ["scene/companies/boston-lyric-opera-1.md"]
related_people = []
short_description = "As Thomas Mallon said in the TalkBack after the performance, the suffering of LGBT+ people brought on by witch-hunting politicians in the 50s was unspeakable, and it is a place he hopes we never return to."
slug = "fellow-travelers-a-cathartic-necessary-affair"
social_media = []
title = "Fellow Travelers a cathartic, necessary affair"
website = ""
youtube_url = ""

+++
Whenever people discuss the state of the fight for gay rights across the past fifty years, I find there is a profound level of ignorance from people not familiar with LGBT+ history about exactly what kind of perils such people used to face in the past.

Even fewer seem to understand the inhumane toll that such perils used to hold for them as well, or even how they relate to the struggles that befall such people even today. People might balk at the suggestion that opera could be a tool to help open a discussion about such things, but as BLO's general and artistic director Esther Nelson stated in a short pre-performance speech, opera can help other people feel empathy for those who are different.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573843106/media/2019/11/BLO2019-FellowTravelers-4871_jydvno.jpg){{% /md %}}

<figcaption>Jesse Blumberg (Hawkins Fuller) and Jesse Darden (Timothy Laughlin) in Fellow Travelers, Boston Lyric Opera, 2019. Photo: Liza Voll.</figcaption>

</figure>

Thus, we turn to Boston Lyric Opera's production of [_Fellow Travelers_](https://blo.org/fellow-travelers/), an opera set during the Lavender Scare. Thomas Mallon's novel about the affair that government workers Hawkins Fuller and Timothy Laughlin engage in during this little known offshoot of McCarthyism that targeted gay and lesbian people reads as perfect operatic material from the start; its story about a passionate affair which is ultimately snuffed out by a decision made under the tensions brought about by the society around them contains just the right level of drama for such a treatment.

> Spears' vocal lines contain such rich depths of character that make it eminently clear what each character is feeling.

Greg Pierce's libretto manages to strike just the right balance between focusing on the love story and the effect that the politics of the day has on the relationship, and it does just enough to paint a picture of the unjust circumstances that lead Hawkins to embark on his betrayal.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573843118/media/2019/11/BLO2019-FellowTravelers-4900_pjkqwi.jpg){{% /md %}}

<figcaption>(l-r) Jesse Darden (Timothy Laughlin), Cheslea Basler (Mary Johnson), and Michelle Trainor (Secretary Miss Lightfoot) in Fellow Travelers, Boston Lyric Opera, 2019. Photo: Liza Voll.</figcaption>

</figure>

Composer Gregory Spears' music is minimalist almost to a fault, with rhythmic patterns that insistently chug onwards within the orchestra. One might think that this approach would perhaps come off rather samey, but Spears' limited compositional materials convey a dramatic shift in mood with something so simple as the subtlest change in the use of his palate. Insistent piano notes at the same time highlight the tension in scenes where Hawkins is interrogated by government officials, while slow, pulsing chords highlight Tim thanking God for sending him the gift of his love for Hawkins.

But perhaps more importantly, the orchestra acts as a backdrop for the text setting: the orchestra here almost never calls attention to itself, which is a very rare thing for an opera orchestra to do.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573843128/media/2019/11/BLO2019-FellowTravelers-4970_snsyca.jpg){{% /md %}}

<figcaption>(l-r) Jesse Darden (Laughlin) and Jesse Blumberg (Fuller) in Fellow Travelers, Boston Lyric Opera, 2019. Photo: Liza Voll.</figcaption>

</figure>

I am thankful, however, that the orchestration takes a step back, for the real strength of the opera's music lies in the writing for the voice. Spears' vocal lines contain such rich depths of character that make it eminently clear what each character is feeling, even without the cast's excellent diction. Hawkins is almost reverent towards Tim when he talks about Bermuda during the first time they have relations: his lines are set in the low ranges of his baritone, something that elevates his admiration of Tim's body take on an almost holy significance in the moment.

> The pregnant pauses between Hawkins and Tim's first lines only heighten the sexual tension that underlies their first few interactions.

Tim's stutter upon being introduced to the senator whom he eventually works for is set in such a rapidly fired-off monotone that it perfectly conveyed his character's nerves at the situation, and this still fits in with the passionate rise and fall of his line as he's praying to God, describing his affair in prayer. Even the rantings of Joseph McCarthy himself carried weight, with the way the vocal writing almost forces the singer to bark out his angriest lines at the top of his register.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573843143/media/2019/11/BLO2019-FellowTravelers-5079_h8mnvy.jpg){{% /md %}}

<figcaption>Michelle Trainor (Secretary Miss Lightfoot, centre) in Fellow Travelers, Boston Lyric Opera, 2019. Photo: Liza Voll.</figcaption>

</figure>

And this is to say nothing of the climactic scene in which Hawkins outs Tim to the authorities, a scene that contains four characters almost screaming at the tops of their registers in such a way that it hammered home the harsh reality of the opera's society. And then there is how the silences in the vocal lines play out in the early part of the show, and how the pregnant pauses between Hawkins and Tim's first lines only heighten the sexual tension that underlies their first few interactions in the show.

> Jesse Blumberg brought a particular bravado and a warm baritone voice to Hawkins Fuller that made him absolutely magnetic to watch.

I could go on describing the ways that practically every other character beat is handled throughout the opera's runtime, but I would be writing this review until the sun rose if I attempted to do so. Suffice to say, this opera is an embarrassment of riches in the ways that vocal writing can be used to build character, and that alone is worth the price of admission.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573843156/media/2019/11/BLO2019-FellowTravelers-5099_qhqiec.jpg){{% /md %}}

<figcaption>Jesse Blumberg (Fuller) and Brianna Robinson (Lucy) in Fellow Travelers, Boston Lyric Opera, 2019. Photo: Liza Voll.</figcaption>

</figure>

It helps that BLO had a stellar cast to bring this vocal writing to life. Jesse Blumberg brought a particular bravado and a warm baritone voice to Hawkins Fuller that made him absolutely magnetic to watch, and made it very easy to see what it was that Timothy sees in him even in the final scene after Hawkins betrays him. Jesse Darden made good on the promise he showed in [_Schoenberg in Hollywood_](/schoenberg-in-hollywood-a-heap-of-excess/) last year, where his somewhat thinner but technically precise voice imbued Timothy Laughlin with a naïveté that suited the character's journey.

> Spears' opera is certainly worthy of the buzz it has generated.

Chelsea Basler was warm and matronly as Hawkins' secretary Mary Johnson: she had a lot of work to support both Hawkins and Timothy in their tribulations throughout the work, and she lived up to this challenge admirably. The remaining cast carried their weight in the end too, with David McFerrin in particular providing a biting edge to Joseph McCarthy that proved why his philosophy was so dangerous to the other characters.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573843209/media/2019/11/BLO2019-FellowTravelers-5238_ncw9fk.jpg){{% /md %}}

<figcaption>(l-r) Jesse Darden (Laughlin) and Jesse Blumberg (Fuller) in Fellow Travelers, Boston Lyric Opera, 2019. Photo: Liza Voll.</figcaption>

</figure>

I have heard that Boston Lyric Opera is just one of many companies that have taken up this opera in its 2019 season; Spears' opera is certainly worthy of the buzz it has generated, and it always warms my composerly heart to see a new opera do so well. For me, however, this extends beyond the opera's quality on its own terms: _Fellow Travellers_ is one of those rare operas that feels important in the broader cultural context that it was created in.

As Thomas Mallon said in the TalkBack after the performance, the suffering of LGBT+ people brought on by witch-hunting politicians in the 50s was unspeakable, and it is a place he hopes we never return to. I hope that, in its success, _Fellow Travellers_' approach to its story helps others see why it is important that we never let things return to the Lavender Scare again.