+++
author = ["authors/jeremiah-sanders.md"]
categories = "Op-ed"
date = "2016-08-31T08:08:00-04:00"
lastmod = "2017-08-14T09:10:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472718492970/2016-09-01---Jeremiah-Square.jpg.jpg"
primary_image_credit = "Jeremiah Sanders, baritone. Photo by Dean Williams, Thrive Photography."
publishDate = "2016-09-01T08:47:00-04:00"
related_articles = ["articles/bodyshaming-productselling-knowing-the-difference.md"]
short_description = "What I do know is I have questions that I hope we all can start to ask ourselves: Where does this critical conversation fit in this profession? What happens when superficial beauty standards discriminate gifted singers out of the business? Is there a way to have a body positive mindset and approach in this industry?"
slug = "fat-phobia-in-opera-its-a-thing"
title = "Fat phobia in opera? It&#039;s a thing"
+++

Opera requires imagination. If that's true, why is it that people can still inflict a lens of "reality" on an art form entirely based on stretching that very concept? 

I was introduced to opera when I was seventeen. I felt I had found my calling when I saw *Die Zauberflöte*, strangely enough. Since then, I have pursued this career where adults play dress up in elaborate tapestries and sing very beautifully while making it all look easy.

After six years, I discovered there are some rigid points of view in circulation. I was clued into the fact that I am too fat to have a career. This introduction came as a surprise. Not because of the weight; I've always been husky, then chubby, overweight, plus sized or big, but now — just fat? 

I simply struggle with the stigma of that word.

My struggle formerly was reconciling my race in a genre without significant representation, meaning I wish I did't have to hunt beyond the maybe five prominent black operatic singers we are all thinking of right now. Little did I know — I should have been more concerned with my weight. 

Now I am plagued with the question of: where does body positivity fit into opera?

The answer? I don't know. I am a twenty-four year old black male opera singer who — even though I've been informed otherwise — will continue to gently stir the pot. What I do know is I have questions that I hope we all can start to ask ourselves: Where does this critical conversation fit in this profession? What happens when superficial beauty standards discriminate gifted singers out of the business? Is there a way to have a body positive mindset and approach in this industry?

One of the most prominent anecdotes I have encountered is Deborah Voigt's weight loss journey. Those who share say it severely impacted her vocal production; thus, to what extent does an artist focus on conforming to a narrow aesthetic that may have negative consequences on their vocal artistry?

Overweight is synonymous with unattractiveness, inflexibility or immobility, all leading to one overall sentiment: if you are bigger, then you are undesirable. The approach to talking about weight loss can also be dispiriting. One euphemistic way I heard someone encourage weight loss was by saying it is important to be fit and strong. I wholeheartedly agree. Other responses include being overlooked for not fitting a certain aesthetic, scrutinized because someone's perception of how a bigger person will look or move on stage, the list goes on. 

There is much cognitive dissonance between believing opera is an art form that embodies all possibilities and knowing people with extra weight may not have a successful career.

My resolve is knowing there is truth in striving to be fit and strong. It is important to be healthy. Opera requires much stamina and endurance. The idea of park and bark a beautiful sound has dissipated. The rise of convenience opera via long distance subscription services and close up, high-definition imaging has not only altered the criteria for physical appearance but also demands more in physicality.

All the same, I still strongly advocate for a body-positive approach to casting, staging, costuming and so on that better represents the true diversity of human beings. We need to cross the Rubicon and not borrow Hollywood's or "the industry's" dated superficial beauty standards that only capture so much on the operatic stage or in HD broadcasts. Let us not sacrifice quality of a gorgeous voice because of the quantity of their waist size; instead, Let us encourage healthy weight loss or weight management.

Part of the business is opening one's self up to the duality of praise and scrutiny. But, be discerning. Talk with teachers and professionals you trust. If you are on a weight loss journey, please practice self-love.
