+++
author = ["authors/melissa-ratcliff.md"]
categories = "Review"
date = 2023-02-27T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1677440596/media/2023/02/sq_The_Birds_Pacific_Opera_0593_raqldc.jpg"
primary_image_credit = "Claire de Sévigné in The Birds, Pacific Opera Victoria, 2023. Photo: David Cooper."
related_articles = []
related_companies = ["scene/companies/pacific-opera-victoria.md"]
related_people = ["scene/people/nathan-keoughan.md", "scene/people/peter-barrett.md", "scene/people/justin-welsh.md", "scene/people/jacqueline-woodley.md", "scene/people/adrian-kramer.md", "scene/people/claire-de-sevigne.md"]
short_description = "De Sévigné’s performance was ethereal and lovely. With a fuller, more mature sound that has maintained all of its agility and height, she soared effortlessly in lengthy, dazzling coloratura over ensembles, duets, and choruses with incredible skill."
slug = "fantasy-is-for-the-birds"
title = "Fantasy is for The Birds"
youtube_url = ""

+++
In a long history of creative new productions, [Pacific Opera Victoria](/scene/companies/pacific-opera-victoria/) brings an imaginative, fantastical rendition of Braunfels' opera _The Birds_. With a score reminiscent of movie-score-meets-Richard-Strauss, POV decided to take this metaphysical/mythological story and ground it very much in Braunfels' reality for its Canadian premiere. It was written while he was serving in the German trenches of WWI, and that is exactly where our story begins.

Hoffegut, played by tenor [Adrian Kramer](/scene/people/adrian-kramer/), and Ratefreund, played by [Peter Barrett](/scene/people/peter-barrett/), begin the show as soldiers in a front line WWI trench in 1918 in Germany. While reminiscing about their lot and the drudgery and sadness around them, they imagine a life living with the Birds.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1677440733/media/2023/02/The_Birds_Pacific_Opera_0450_o0joia.jpg){{% /md %}}

<figcaption>The cast and chorus in The Birds, Pacific Opera Victoria, 2023. Photo: David Cooper.</figcaption>  
</figure>

The artistry of bringing the birds to life was clever and very well-executed. From huge flamingo and ostrich puppets reminiscent of Julie Taymor's designs in Broadway's _The Lion King_, to a feathered, steampunk pickelhaube for the King of the Birds, to a Wren in jodhpurs riding in on a scooter, The birds were each unique in construction and appearance, but formed a seamless whole. Soprano Claire de Sévigné as the Nightingale appears in an LED-lit nest in the sky wearing a black glitter dress and feathered, sparkling headdress, with whimsy and glamour to spare.

De Sévigné’s performance was ethereal and lovely. With a fuller, more mature sound that has maintained all of its agility and height, she soared effortlessly in lengthy, dazzling coloratura over ensembles, duets, and choruses with incredible skill.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1677440753/media/2023/02/The_Birds_Pacific_Opera_0675_v9ejxz.jpg){{% /md %}}

<figcaption>Adrian Kramer and Claire de Sévigné in The Birds, Pacific Opera Victoria, 2023. Photo: David Cooper.</figcaption>  
</figure>

The chorus themselves were each dressed as birds, and the execution of their costumes was so well done that each species of bird was identifiable (at least to an inveterate bird watcher like myself). California quail, cardinals, peacocks, hummingbirds, and many more. And each bird species adopted the mannerisms of their particular bird, either pecking, scratching, running, flitting, as each individual bird would. Such a small detail that so many may have missed, but it was an incredible addition that added so much depth to what could have easily become farcical. There was even a bird wedding in act II that was as charming and adorable as it was hilarious!

The King of the birds, Wiedhopf (Hoopoe), played by baritone [Justin Welsh](/scene/people/justin-welsh/), is convinced by Hoffegut and Ratefreund to build a palace for the birds in the sky, blocking the Gods from the Earth, and gaining power. Welsh’s strong baritone was equally comic and strong, and his interpretation of the bird was subtle and humorous in equal measure.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1677440682/media/2023/02/The_Birds_Pacific_Opera_0275_jpvtbi.jpg){{% /md %}}

<figcaption>(l-r) Justin Welsh, Jacqueline Woodley, Peter Barrett, and Adrian Kramer with chorus in background in The Birds, Pacific Opera Victoria, 2023. Photo: David Cooper.</figcaption>  
</figure>

Eventually the Adler, the Eagle descends (in a WWI German Officer’s uniform) to warn the birds of the dangers of trusting men. Played by baritone [Nathan Keoughan](/scene/people/nathan-keoughan/) (who doubles as Zeus from afar nearer the end of the opera) played the antagonist with phenomenal presence, and a strong rich low end that was fearsome and beautiful.

> Full of incredibly difficult passages, hidden entries, and massive lush orchestration, it came off easily under Vernon's direction.

With the palace built, the birds have risked the wrath of the Gods. Interrupting their celebration is a man, warning them to take their palace down and not anger Zeus any further. The stranger reveals himself as Prometheus. In Greek mythology, Prometheus stole fire from the Gods to give to mankind, and was punished by being chained to a rock and having his liver pecked out by birds every day, only to have to grow back every night, and repeat this cycle for eternity. Here, Prometheus appears with his broken chains, having freed himself from his eternal torment to warn the birds of the consequences of crossing Zeus. Played by bass-baritone Kyle Albertson, he brought the weary, tortured character to life. His bass was phenomenal, although singing a very low part, Albertson had so much heft and brilliance to his voice that it pushed right through the massive score.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1677440821/media/2023/02/The_Birds_Pacific_Opera_0945_pd5t72.jpg){{% /md %}}

<figcaption>Kyle Albertson and Justin Welsh in The Birds, Pacific Opera Victoria, 2023. Photo: David Cooper.</figcaption>  
</figure>

The two humans, Hoffegut (Kramer) and Ratefreund (Barrett) were incredibly well matched. Peter Barrett was funny and whimsical, with a great stage presence, and a smooth, warm voice that belied the difficulty of the music he was performing. Adrian Kramer was an absolute powerhouse of a tenor. His voice was enormous and brilliant without any of the darkness that can often come with a big instrument. In his final moments, Kramer was on his knees, pouring his heart out and the entire performance was glorious.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1677440800/media/2023/02/The_Birds_Pacific_Opera_0722_yljbhs.jpg){{% /md %}}

<figcaption>Adrian Kramer with chorus in The Birds, Pacific Opera Victoria, 2023. Photo: David Cooper.</figcaption>  
</figure>

The mostly-static set was highlighted by a huge circular projection screen, onto which detailed, animated projections were displayed. Designed by Emily Cooper, the projections underscored the story perfectly, being in turn menacing, awe-inspiring, or comic. The projections were phenomenal without pulling the focus from the story, and were a brilliant addition to the fantastical production.

Under the direction of Glynis Leyshon, this story was beautiful from start to finish. The sets, costumes, projections, stage direction were a feast for the eyes and ears, full of playful fantasy, sumptuous detail, and thrilling action. Her previous production of POV’s _Rinaldo_ was filled with the same detailed imagination that made it such a pleasure to watch.

A German Romantic opera score is never an easy undertaking, but Artistic Director Timothy Vernon, in his final season with POV, handled the assembled forces masterfully. Full of incredibly difficult passages, hidden entries, and massive lush orchestration, it came off easily under Vernon's direction.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1677440777/media/2023/02/The_Birds_Pacific_Opera_0706_t2kt4f.jpg){{% /md %}}

<figcaption>Claire de Sévigné and Adrian Kramer in The Birds, Pacific Opera Victoria, 2023. Photo: David Cooper.</figcaption>  
</figure>

With a Canadian premiere, and a story that could easily become overly-intellectualized and abstract, the fanciful setting was a perfect choice to bring this story to a modern audience. I couldn't stop watching every detail, and am excited for the next productions that POV brings.