+++
author = ["authors/kelsey-kudak.md"]
categories = "Review"
date = "2015-10-26T22:42:00-04:00"
lastmod = "2015-10-27T10:07:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445951224430/OWS_HANNIBAL_0086.jpg.jpg"
primary_image_credit = "Photo by Jaka Vinsek."
publishDate = "2015-10-27T09:13:00-04:00"
related_articles = ["articles/brian-mulligan-singing-jack-torrance.md","articles/one-world-symphony-gets-defiant.md","articles/sung-jin-hong-seoul-searching.md"]
related_companies = ["scene/companies/one-world-symphony.md"]
short_description = "Thematically, the darkness of Hannibal is not an unfamiliar subject to opera. Psychopathic heroes and murderers have long taken the stage through works like Wozzeck and Salome, characters like Bluebeard and Scarpia. A lot of operas are bloody. Yet, I’m not sure the question is whether Hong is doing something new. Rather, the point is what he’s doing to make opera contextually relevant to those who otherwise might not go to the opera at all."
slug = "fannibals-in-new-york-one-world-symphony-premieres-hannibal"
title = "Fannibals in New York: One World Symphony premieres Hannibal"
+++

[One World Symphony](/scene/companies/one-world-symphony/)’s Sunday premiere of [*Hannibal*](https://www.youtube.com/watch?feature=player_embedded&v=g-E0KcaR2S0) was like a psychopathic serial killer: equally immense and intimate. Mashing Stravinsky's “Sacrificial Dance” up against Fauré’s *Requiem* against composer [Sung Jin Hong](http://www.oneworldsymphony.org/artists_founders.shtml)’s interpretation of a television show made for a sublimely appropriate start to Halloween week. Anytime you place a full orchestra beneath the dome of a small church--in this case the Church of the Holy Apostles in New York City--the sound is enormous. But when the cast then mingles amidst the audience and the church’s pristine columns, you’ve got opera up close. Hong’s tangible approach is fresh, for both seasoned opera-goers and unseasoned “Fannibals” alike. 
 
Overall, the evening illustrated Hong’s clear passion for composition and his desire to carve a place for classical music amidst today’s mainstream. Each part of the program was obviously calculated: he began with Saariaho’s *Ballade*, moved to Stravinsky’s *The Rite of Spring* and an Aria (performed by harpist Kristi Shade) from Bach’s *Goldberg Variations* (Bach, being a known obsession of Hannibal and a soundtrack to the murders of two police officers during *The Silence of the Lambs*), and ended with the liturgical "hosannas" in Fauré’s *Requiem*. Wearing blotches of fiery red lipstick, stilettos and neckties, the symphony soared through the scores that preluded Hong’s *Hannibal* premiere--juxtaposing the hellish with celestial, fierce brooding with gentle pastoral. 

Before launching into the premiere, Hong provided a causal tutorial on his composition--ensuring the audience (which expected “blood!” “dramatics!” “forbidden love!”) understood his motives.  Hong proclaimed himself a storyteller, and discussed his inspiration for the score--reflecting both the saga and psyche of Hannibal in a remarkably tangible manner: Hong met with a cardiologists to understand the rhythms and murmurs of the heart. He then built a leitmotif inspired by B-A-C-H (B is B flat, H is B natural), and utilized an eerie minor 9th interval/chord to suggest Hannibal’s unease in having eaten his own sister. Eighteen woodwinds, including the uncommon bass and alto flutes, represent 18 voices of Hannibal’s victims; a flute solo sings Abigail’s plight; a bass drum pounds Hannibal’s pathological heart murmur, and the clave taps his pulse. The composition--clear and nuanced in this way--was perhaps dense for the non-musically inclined, but very smart and structurally clear. At the same time, if you weren’t listening for these motifs, the music still delivered the thrills and surprises of a horror flick: crawling string sections, and booming dramatics.

Thematically, the darkness of Hannibal is not an unfamiliar subject to opera. Psychopathic heroes and murderers have long taken the stage through works like *Wozzeck* and *Salome*, characters like Bluebeard and Scarpia. A lot of operas are bloody. Yet, I’m not sure the question is whether Hong is doing something new. Rather, the point is what he’s doing to make opera contextually relevant to those who otherwise might not go to the opera at all. He seems to care so much about accessibility (as does [One World Symphony](http://www.oneworldsymphony.org/contr_commmusic.shtml)), he solicited e-mail responses from the audience and generated a long receiving line to greet each person individually after the show.

Hong’s intricate calculations however, might also be one of his shortcomings. For all his ingenuity and inspiration, there was a long program accompanying the work to make sure the audience wouldn’t miss his nuance. But that, perhaps, is the difficult part. Part of being an audience member is having the license to interpret the work any way we can access it, not necessarily in being told what to think of it. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445951450750/SungJinHong_JVinsek3.jpg.jpg)
<figcaption>Composer and founder of One World Symphony Sung Jin Hong. Photo by Jaka Vinsek.</figcaption>
</figure>

Hong’s heavy-handed symbolism may have secondarily contributed to the disjointed, muddled plot of the "operasode." Anyone not intimately familiar with the television show would have had to rely on Hong’s lengthy notes to fill in the gaping narrative blanks. The libretto was compiled and arranged from Thomas Harris’s novel, *Red Dragon*, NBC’s screenplay, *Hannibal*, and William Blake’s poem, “A Divine Image,” which appears in *Red Dragon*. But, for all the literature arranged in it, the text was at best minimally composed, and gave the cast--especially the iconic Hannibal--little to work with in terms of melodic line and artistic prose. 

Because the opera only contains three short scenes, it is also difficult to find many of the character’s actions credible. In the case of Abigail, for example, she confesses to Hannibal she helped her father murder several women, then allows Hannibal to cradle her paternally, and subsequently, Hannibal stabs her to death--all within a few minutes. It’s as if the rising action of the plot was omitted entirely. Soprano Marie Putko, however, performed nobly; her surgical diction and murderous (pun intended but appropriate) musicality shone. 

The singers, overall, were capable and well cast; countertenor Nicholas Tamagna invoked the angelic, delicate nature of Hong’s composition for Hannibal with the painted smile of a possessed doll. He was reportedly cast to explore the Hannibal’s iconically genderqueer nature, but the exploration stopped at the symbolism of Tamagna’s voice type and well-tailored plaid suit. 

All in all, the outstanding intricacy of the score  and its performance by Hong and his One World Symphony is heartfelt and impassioned. The score's careful design is clearly-executed by Hong, but the libretto remains insufficient for a “non-Fannibal” audience. Merging opera with pop culture is no simple task, and Hannibal is an incredible feat in this regard. Hong’s desire to have his audience understand his work makes this the perfect introduction for any newcomer to classical music and opera.
