+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2016-08-23T18:22:00+01:00"
lastmod = "2016-08-25T14:55:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472061851056/2016-08-25---Norma.jpg.jpg"
primary_image_credit = "Photo: Deborah's Perspective on Flickr."
publishDate = "2016-08-25T14:49:00+01:00"
related_articles = ["articles/cosi-fan-tutte-misogynist-unreasonable.md","articles/why-we-all-love-florence-foster-jenkins.md"]
related_companies = ["scene/companies/royal-opera-house.md","scene/companies/canadian-opera-company.md","scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/sondra-radvanovsky.md","scene/people/isabel-leonard.md","scene/people/russell-thomas.md","scene/people/sonya-yoncheva.md","scene/people/sonia-ganassi.md","scene/people/elizabeth-deshong.md"]
short_description = "For British audiences, the Druids were a healthy dose of exoticism; still, the connection to the ancient societies of their own land likely held some form of national and cultural pride. Perhaps it was just enough mystery to pique interest in Norma, and just enough familiarity to easily identify with the values and decisions of the characters."
slug = "familiar-exotic-a-brief-history-of-bellinis-norma"
title = "Familiar &amp; exotic: a brief history of Bellini&#039;s Norma"
+++

Bellini's *Norma* is the story of the Druid High-Priestess, who has broken her vows by getting involved with the Roman Pollione. Pollione has fallen out of love with Norma, and now loves the priestess Adalgisa. The two women band together over their shared doomed love, after Norma reveals that she has had children by Pollione. They denounce him, and only when Norma volunteers to sacrifice herself - a priestess who offended her faith - to the Druid rites, does Pollione have a change of heart; he joins her on the pyre, and leaves their children to Adalgisa.

By the time *Norma* premiered at La Scala in December of 1831, Vincenzo Bellini had already enjoyed his first taste of success, and his first taste of waning fame. The Italian premieres of *Il pirata* in 1827 and *Bianca e Fernando* in 1828 gained him international recognition, and earned him fees which allowed him to live solely on composing music. 

Bellini's 1829 *Zaira* was, comparatively, a cool reception in Parma and in Florence, but when composer Giovanni Pacini, somewhat of a contemporary rival figure, failed to deliver on his contract with La Fenice, Bellini was given an opportunity (tightly scheduled as it was) for what because *I Capuleti e i Montecchi*. His opera based on *Romeo and Juliet* was an instant success at its premiere in March, 1830, including his adaptation for La Scala, lowering Giuletta's part to suit mezzo-soprano Amalia Schütz-Oldosi.

1831 first saw the Milan premiere of *La sonnambula* in March, and *Norma* was on the Scala stage by December of the same year. The libretto by Romani - also the librettist for Rossini's *Il turco in Italia*, Donizetti's *Anna Bolena*, and Bellini's *I Capuleti e i Montecchi* and *La sonnambula* - was inspired by the play by Alexandre Soumet, *Norma ou l'infanticide*. Bellini had cast Giuditta Pasta as Norma, who had had recent success as Amina in *La sonnambula*, Domenico Donzelli as Pollione, who had earned fame for himself with Rossini's *Otello*, and Giulia Grisi as Adalgisa, who was Pasta's sister (a perfectly cute detail).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472132122183/2016-08-26---Giuditta-Pasta.jpg.jpg)
<figcaption>Giuditta Pasta, on the poster for the 1831 premiere of *Norma* at La Scala.</figcaption>
</figure>

The Scala premiere was a cool reception, although *Norma* grew more popular, running for 39 performances during its first season in Milan. With its Italian cast, *Norma* came to London in 1833, playing at the King's Theatre (now known as Her Majesty's Theatre), which also housed the London premieres of *Don Giovanni*, *Carmen*, and the *Ring Cycle*.

England and Wales had recently experienced a new fascination with the Druids, or what they understood of them at the time. Druidism was mistakenly connected with the ancient Celts of the Iron Age, and the misguided imitations of Iron Age priests (including a few nods to Freemasonry) were at the centre of the [Neo-Druidism](https://en.wikipedia.org/wiki/Neo-Druidism) that came in the late 18th century.

Despite inaccurate reports that the Druids were connected with Stonehenge, or the vague hints at their practice of human and animal sacrifice, the mythology of Druidism - false or not - gave an exciting backdrop for telling stories. Chateaubriand's 1809 novel *Les martyrs* tells the tale of a troublesome love between a Druid princess and a Roman soldier, a story that's notably similar to that of Bellini's *Norma*. In fact, Felice Romani also provided a libretto for Pacini's 1821 opera *La sacerdotessa d'Irminsul*.

The London premiere was a clear success, and its popularity grew more quickly than it had in Italy. Perhaps it was a savvy decision on the parts of Bellini and Romani, but it was at least a fortunate coincidence that *Norma* arrived in London when the Druid mysteries held fascination. For British audiences, the Druids were a healthy dose of exoticism; still, the connection to the ancient societies of their own land likely held some form of national and cultural pride. Perhaps it was just enough mystery to pique interest in *Norma*, and just enough familiarity to easily identify with the values and decisions of the characters.

So, where can you hear some of Bellini's endless melodies mixed with the curious world of Druidism?

*Norma* is on the season line up for three major houses in 2016/17. At the [Royal Opera House](http://www.roh.org.uk/productions/norma-by-alex-olle), *Norma* runs **September 12 to October 8**; the new production by Àlex Ollé stars [Sonya Yoncheva](/scene/people/sonya-yoncheva/) in the title role, opposite [Joseph Calleja](/scene/people/joseph-calleja/) as Pollione, and [Sonia Ganassi](/scene/people/sonia-ganassi/) as Adalgisa. Anthony Pappano conducts.

The [Canadian Opera Company](http://www.coc.ca/PerformancesAndTickets/1617Season/Norma.aspx) presents Kevin Newbury's production on **October 6 to November 5**, with the title role shared by [Elza van den Heever](/scene/people/elza-van-den-heever/) and [Sondra Radvanovsky](/scene/people/sondra-radvanovsky/). [Isabel Leonard](/scene/people/isabel-leonard/) sings Adalgisa, and [Russell Thomas](/scene/people/russell-thomas/) reprises Pollione. Stephen Lord conducts.

Newbury's production heads to [Lyric Opera of Chicago](https://www.lyricopera.org/concertstickets/calendar/2016-2017/productions/lyricopera/norma) in early 2017 (**January 28 to February 24**), another chance to hear Radvanovsky and Thomas; they're joined joined by [Elizabeth DeShong](/talking-with-singers-elizabeth-deshong/) as Adalgisa, and Riccardo Frizza conducts.

Can't wait for the live version? Whet your appetite with Radvanovsky herself, singing the famed "Casta diva" from Bellini's *Norma*:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/xbsK93x9Xzg" frameborder="0" allowfullscreen></iframe>
</figure>
