+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-06-25T11:42:00-04:00"
lastmod = "2017-07-10T23:06:00-04:00"
preamble = "When we go to the opera, what we see onstage is the result of a complicated system of task delegation; some folks do the singing, others look after the lights. Sometimes, there are people onstage who have the simple-yet-vital job of being visible. These are the [supernumeraries](https://en.wikipedia.org/wiki/Supernumerary); they pad out crowd scenes and play silent roles (henchman, bartender, sex worker), adding to the imagined world that surrounds the main operatic action.\n\nWe spoke with Carl Lyons, Matthew Bernstein, Liz Allemang, and Marie Colucci, four such supernumeraries (supers, colloquially) who have graced stages large and small for productions of *Nixon in China*, *Rigoletto*, *La bohème*, *Carmen*, *Roberto Devereux*, and even *#UncleJohn*. Their operatic roles are fascinating, so read on for tips of the trade and great tales from the stage."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499459438619/2017-07-07---Crowd.jpg.jpg"
publishDate = "2017-07-10T11:53:00-04:00"
related_articles = ["articles/tales-from-stage-management.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/against-the-grain-theatre.md"]
short_description = "&quot;Being on stage with these performers is truly a magical experience. You learn very quickly that these people are like high-level athletes. Their instrument is wonderous when you&#039;re close to them. Also, you learn quickly that most of them are pretty funny and entirely approachable (they like to hear how wonderful they are all the time!). Onstage the performers are incredibly focused but also have fun if the opportunity presents itself.&quot;"
slug = "faces-in-the-crowd-operas-supernumeraries"
title = "Faces in the crowd: opera&#039;s supernumeraries"
+++

## How did you get involved in your supernumerary work, specifically in opera?

**Marie Colucci**: I knew Mark Zurowski, who was the [Canadian Opera Company](/scene/companies/canadian-opera-company/)'s supernumerary coordinator around 2000, and he knew how much I loved opera so encouraged me to become a super. My first opera was *Idomeneo*, which was performed at the Hummingbird Centre in 2001.

**Liz Allemang**: In late 2008, I had been working in television as a writer/producer when my company announced layoffs. The climate for jobs was bleak, so I sought something to fill my time and distract me from job search ennui. My dad had been a super and I always thought it sounded like an interesting opportunity to meet people and to learn to share my dad’s enthusiasm for opera. I tracked down the supernumerary coordinators who were looking for two female supers for *Fidelio*. The director had wanted older women (I was 23 at the time and looked about 12), but I was allowed to "audition" and got cast a couple of weeks later. I've been doing operas ever since.

**Matthew Bernstein**: My wife, Risa, saw an ad in the *Globe* asking for "bald-headed" men to appear in an opera (*From the House of the Dead*). She asked the COC to call me as she knew I wouldn't. They did, and asked me to come down to the costume department on Front Street so they could have a look at me. When I arrived, the costume staff said I was what they were looking for - and I was in the opera! After that, I caught the bug and have had the opportunity to participate in several more operas.

**Carl Lyons**: I had always had the idea of being in productions right from the early days of university. The actual year I subscribed to the Canadian Opera Company, an email blast came from the COC seeking supers since they required over 100 for a production of *The Dialogue of the Carmelites*. I immediately emailed back my "yes" response. Luckily, I was the right size, and the rest is history. That production was magnificent and there were so many of us, it was an instant "summer camp" experience. Some of the folks I met there are quite good friends now.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499216065971/2017-07-05---Block---Boheme---Lyons.jpg.jpg)
<figcaption>Carl Lyons (bottom) with Adanya Dunn as Musetta and Gregory Finney as Alcindoro (top) in Against the Grain Theatre's *La bohème*, 2017. Photos by Darryl Block.</figcaption>
</figure>

## What have you learned about opera singers, from being so close to them onstage?

**Colucci**: To be honest, once I am on stage I don't think of them as opera singers but rather as real characters. I just finished supering in *Tosca*, and while it was [Adrianne Pieczonka](/scene/people/adrianne-pieczonka/) or [Keri Alkema](/talking-with-singers-keri-alkema/) singing the role of Tosca, they were simply Tosca to me. Singers spend a great deal of time preparing for their roles, and once they enter the playground – the stage - they leave themselves at the door and become the character, and I fully embrace that.

**Allemang**: They are totally normal people with extraordinary, hard-earned talents. Their work ethic leaves me awestruck and I've certainly applied this insight to my own approach. Even if I’m tired and have had a long day, I make a conscious effort to leave that behind when I'm on stage. If the principals can show up and deliver beyond expectations, I certainly have no excuse not to bring my all.

And they're human: Some bring their families to keep them company, some bring their PlayStations to pass the time. We may think it's a glamorous life, but the reality is grounded in hard work and, sometimes, loneliness: a number of the principals spend 300 days a year on the road. They're happy to have a life outside of work. I've had the pleasure of going for tacos with singers, showing them Toronto and lending them books to read between scenes in their dressing rooms. It's been a pleasure to have these friendships and you very quickly realize how much you have in common, even though your lives are fundamentally different.

**Bernstein**: Being on stage with these performers is truly a magical experience. You learn very quickly that these people are like high-level athletes. Their instrument is wondrous when you're close to them. Also, you learn quickly that most of them are pretty funny and entirely approachable. Onstage the performers are incredibly focused but also have fun if the opportunity presents itself. When you're close to the action, its very apparent if they're having a good or a poor performance.

**Lyons**: I have learned that opera singers are a dedicated bunch. The training is rigorous, the parts demanding, all those languages to learn, and constant practicing to keep on top of their game. I've also learned that they are amongst the most supportive artists. I find generally, that most artists are supportive of each other. I've seen many performers of most of the performing arts be close friends, very dedicated to the various friendship networks they belong to. So many performers attend each other's performances. One can be sure, no matter which performance one attends, there will be other singers there.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499722707196/2017-07-10---.jpg.jpg)
<figcaption>Matthew Bernstein with his fellow supernumeraries, backstage for *Madama Butterfly*, Canadian Opera Company.</figcaption>
</figure>

## What do you think makes for an excellent supernumerary that everybody wants to work with?

**Bernstein**: I think an excellent "super" does exactly what they're told by the directing staff and has a great attitude. Understand that we're moveable scenery and we're there to help facilitate the performers and the production. Just be happy with whatever the production staff ask you to do. Showing up on time with a smile also helps. It seems that supers make up their own strata within the production (we're at the bottom end), but I think we all really happy to be involved and it's like we have our own little club. Certainly, over the years I've come to know the same people, and for the most part everyone enjoys each other's company.

**Allemang**: Nights and weekends we may be opera prostitutes, plague victims and priests, but by day, supers are everything from retired judges to university students. When you commit, know that the opera will take over your life during rehearsals (up to 10 a week) and shows (you may be at the theatre four nights in a row). Be prepared to fit the rest of your life around the opera's schedule. An excellent super is also flexible and open: Sometimes you'll have to step in for someone at the last minute. Sometimes you'll be married to your dad: in *Nixon in China*, my father and I were cast as a couple. With kids! Our actions were platonic — we ate a TV dinner as a family — though my mother, understandably, did not come to that show. Commit to whatever role you're given and take amusement in the oddity of it all.

**Lyons**: Reliable: show up on time, even early, help out the stage manager and crew with set up and tear-down. Interested: learn about the production – history, flow of the storyline, changes during rehearsals, how your character relates to the story and to the other characters. Supportive: show an interest in the other cast and crew. Be friendly and helpful. Don't be 'negative energy' in the room.

**Colucci**: It is such a privilege to super with the COC and I am incredibly fortunate to be able to work with them. A great deal of preparation goes into putting on such large-scale productions well before a super arrives to their first rehearsal. As a super it is important to be dependable and respectful. It is imperative that supers respond to correspondence from our coordinators in a timely fashion, are on time for scheduled fittings, rehearsals and shows, and are flexible during the rehearsal period since schedules can change daily. It is equally important to be respectful of colleagues from every department. Once in costume, you must be extremely careful that you don't damage them! As well, it is not unusual for supers to be called to audition for a part; for example, I had to audition for both *Dialogues des Carmélites* and *Falstaff*. Therefore, being able to take and execute direction, and, should it happen, seamlessly responding to any unplanned situation on stage cannot be underrated.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499282136444/2017-07-05---Colucci---Rigoletto-2011.jpg.jpg)
<figcaption>Liz Allemang and Marie Colucci in costume for *Rigoletto*, Canadian Opera Company, 2011.</figcaption>
</figure>

## Do you have any good/funny anecdotes from past performances?

**Colucci**: Prior to one of the technical rehearsals for *Lady Macbeth of Mtsenk*, where I played several roles including a lady of the evening, the supers were called for notes (a meeting where the director provides changes that he or she wants to see implemented), which were given with great humour by the amazing assistant director Brent Krysa. As most people know, I like my food and am constantly snacking! I was hungry and enjoying a granola bar when Brent instructed a fellow super of a change, "You are looking a little lonely out there, so its been decided that you will walk on with a tart." "How lucky! He gets to eat food!" I remarked. To which Brent replied, holding back his laughter, "Actually Maria, you are the tart!"

**Allemang**: In one performance of *Roberto Devereux*, I managed to body-check [Sondra Radvonovsky](/talking-with-singers-sondra-radvanovsky/) after I tripped on the bottom rung of my hoop skirt. You don't quite see your life flashing before your eyes in these moments, but you're very cognizant that you've mucked up and that everyone knows. The thing is to not panic, to make it look intentional, to apologize and to not do it again. 

Though period costumes are the stuff of super dreams, they require relearning your new proportions. In *Rigoletto*, we wore these amazing, huge gowns. Something you don’t think about until you have to is the bathroom situation. One of my fondest memories is of a dress rehearsal: we were about to be called to the stage and one of our girls realized she had to pee. It was almost Vaudevillean as she attempted to back into the stall as the clock wound down.

**Bernstein**: Oh yes… Beating up and then lynching [Robert Pomokov](/scene/people/robert-pomakov/) in *Rigoletto* was always fun (the noose was too tight…), and watching [Stefan Vinke](/scene/people/stefan-vinke/) stab [Christine Goerke](/talking-with-singers-christine-goerke/) as she emerged from under the stage with the sword in *Siegfried* was cute. There have been a few "diva" moments in rehearsals; one lady super (playing a prostitute) destroying the costumes by lustily ripping open the uniforms of the male guards in *House of the Dead*, buttons flying everywhere.

**Lyons**: The latest [*La bohème*](/hype-atg-boheme/) [with Against the Grain Theatre] is the freshest. I loved the moments in Act II at the bar, where Musetta slammed her beer on the bar and the liquid (water) shot out of the bottle all over me - sometimes a few drops, sometimes I was drenched. And in the last show the water was replaced with real beer - the look on the performers faces when they had the first sip was memorable.
