+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-07-22T08:00:00-04:00"
lastmod = "2015-04-23T14:33:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429813932876/ELton.jpg.jpg"
publishDate = "2014-07-22T08:00:00-04:00"
related_articles = ["articles/opera-orchestras-robots-or-out-of-the-loop.md","articles/10-pop-singers-with-pipes.md","articles/folds-the-new-fulllength-solo-album-from-nathan-shubert.md"]
short_description = "Well, maybe not everything, but my title isn&#039;t tongue-in-cheek. I&#039;m aware of the stereotypical opinions about singers that are held by instrumentalists within the classical music scenes; I won&#039;t say they&#039;re not there for a reason, but there&#039;s opportunity for learning between these seemingly polar points of origin in music. Now, singers and pianists work closely together within the opera industry; but when you really think about it, it&#039;s an odd pairing."
slug = "everything-i-know-about-the-piano-i-learned-from-singers"
title = "Everything I know about the piano, I learned from singers"
+++

Well, maybe not _everything_, but my title isn't tongue-in-cheek. I'm aware of the stereotypical opinions about singers that are held by instrumentalists within the classical music scenes; I won't say they're not there for a reason, but there's opportunity for learning between these seemingly polar points of origin in music. Now, singers and pianists work closely together within the opera industry; but when you really think about it, it's an odd pairing. On the one hand, the voice and the piano couldn't be more different, simply in terms of _how _they create sound. A singer takes a breath and sustains a (hopefully) lovely sound with control of air speed and resonance and other complicated things. A pianist pours their whole being into the attack of a note, into the initial moment of making sound; we have no say over what happens to the sound after we've hit the key. The quick nature of the piano keys are entirely different from the drawing of a bow on a string or sending air through a resonating chamber, and it results in a more immediate production of sound. Any pianist who has played in an orchestra knows that they'll be perpetually "early" in comparison with their string- and wind-playing colleagues.

On the other hand, singers are emulated by almost all other instruments; for example, string players learn the tricky technique of vibrato, using their left hand to mimic the voice's natural quavering effect on a sustained pitch. But the bigger picture of imitating singers comes from the idea of melody. Composers who get into writing good tunes know that they tend to rise and fall in a manner that resembles exaggerated speech; there's a natural peak to a phrase, swelling towards it and tapering off like a sort of release. The simplest point of reference could be the English sentence: "I love you." Most people would start lower in the voice, rising quickly in pitch and emphasis towards the word "love", and easily relaxing through the word "you". You could emphasize the word "I" instead, or even the word "you", and get pretty different spins on the phrase's meaning; but there almost always exists some sort of arc in the voice. This is the stuff of good tunes, to be found in any Chopin Nocturne.

As a pianist who started off in my own little world of eighty-eight keys and a metronome, the idea of mimicry meant nothing to me. Who cares what _other_ instruments could do? I'm not picking up a violin, or a flute, or learning to sing; why are you bothering me with anecdotes about unrelated instruments? I remember the first time a piano teacher asked me to exhale during a particularly tricky passage of one of the Gershwin _Three Preludes_. He actually wrote it into my music, and I was disgusted. _Exhale_? Really?? What kind of head-in-the-clouds-type of pedagogy was this? Exhale. Psh. Turns out one of the benefits was oxygenating the muscles in my arms and hands in order to physically pull that tricky passage off. But aside from that, the idea of _breathing_, even while I played an instrument that didn't rely on wind to produce sound, started a profound learning curve for me that continued as I began to work with other musicians.

The final intermediary step was playing with cellists. There's plenty of talk about how the cello is the best imitator of the human voice, but the similarities are more interesting than quality of sound. I was playing Samuel Barber's Cello Sonata with a friend of mine during my time in university, and was frustrated with my repeatedly "early" arrival at a certain downbeat. I always made it there before my cellist friend. I was annoyed, because my metronome practice had been diligent, and I was subdividing like crazy. The fault must have been lying with my cellist partner; she was late. I reluctantly asked her about her rhythmic skills, and she told me about the huge, expansive distance that Barber had written between two notes in the cello part, the second of which was due to arrive on that pesky, problematic downbeat. She told me that it just wasn't possible for her to play the notes that Barber had indicated _and_ be perfectly on time with me. Now, that may or may not be true (I don't play the cello), but I remembered this encounter later on, once I began spending more and more time with singers.

The human voice has natural tendencies, and even natural limitations. In most cases, the wider the interval, the more time the voice needs to span it. I'm not saying they're sliding up and down like sirens; but if two notes cover a decent distance in the voice's natural range, the odds are greater that the distance includes a change in register, and requires more from the voice than a small, stepwise movement (proof: try it). The neat thing is that we, as humans who use our voices to communicate, understand this innately, and forgive it. So much so that this immeasurable time taken between a large interval finds its way into the unconscious imitation by almost every other instrument; it manifests itself into a more flexible version of rhythm. It becomes part of a musical phrase, an element that's crucial to keeping the music organic rather than robotic. The catch is, it's hard to write down.

And therein lies the trap into which pianists fall. When a pianist mimics these vocal tendencies, it's all smoke and mirrors. We can't actually make two notes truly _legato_, but we can fake it, with plenty of practice. When we play with singers, we take on the task of accommodating that flexible rhythm in order to really make music with our partner. It seems arbitrary, even affected; but the way to pull it off is to breathe and sing, even from the piano. (Not necessarily in the way pianists like Victor Borge or Glenn Gould sing, although that's charming too.) Breathing and singing vicariously from the keyboard fill in the missing links between the physical natures of the voice and the piano.

In many cases, pianists don't learn to breathe in order to help their playing, because it seems practically unnecessary. But the voice and speech patterns are the starting points for music. In hindsight, it makes utter sense to include this in early piano pedagogy. There's this funny rivalry between instrumentalists and singers, and rhythm seems to fuel the fight. Pianists can improve their skills in _legato_, phrasing, and even rhythm, by leaning in closer and listening to singers. I know I'll never play a Chopin Nocturne the same way again.
